/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterParamIndexBase;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;

public final class FilterHandleSetNode
implements EventEvaluator {
    private final ReadWriteLock nodeRWLock;
    private final Set<FilterHandle> callbackSet;
    private final List<FilterParamIndexBase> indizes;

    public FilterHandleSetNode(ReadWriteLock nodeRWLock) {
        this.nodeRWLock = nodeRWLock;
        this.callbackSet = new LinkedHashSet<FilterHandle>();
        this.indizes = new LinkedList<FilterParamIndexBase>();
    }

    public boolean isEmpty() {
        return this.callbackSet.isEmpty() && this.indizes.isEmpty();
    }

    public int getFilterCallbackCount() {
        return this.callbackSet.size();
    }

    public final ReadWriteLock getNodeRWLock() {
        return this.nodeRWLock;
    }

    public List<FilterParamIndexBase> getIndizes() {
        return this.indizes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void matchEvent(EventBean theEvent, Collection<FilterHandle> matches) {
        this.nodeRWLock.readLock().lock();
        try {
            for (FilterParamIndexBase index : this.indizes) {
                index.matchEvent(theEvent, matches);
            }
            for (FilterHandle filterCallback : this.callbackSet) {
                matches.add(filterCallback);
            }
        }
        finally {
            this.nodeRWLock.readLock().unlock();
        }
    }

    public boolean contains(FilterHandle filterCallback) {
        return this.callbackSet.contains(filterCallback);
    }

    public final void add(FilterParamIndexBase index) {
        this.indizes.add(index);
    }

    public final boolean remove(FilterParamIndexBase index) {
        return this.indizes.remove(index);
    }

    public final void add(FilterHandle filterCallback) {
        this.callbackSet.add(filterCallback);
    }

    public final boolean remove(FilterHandle filterCallback) {
        return this.callbackSet.remove(filterCallback);
    }

    public Set<FilterHandle> getCallbackSet() {
        return this.callbackSet;
    }
}

