/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamIndexStringRangeBase;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.StringRange;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FilterParamIndexStringRange
extends FilterParamIndexStringRangeBase {
    private static final Log log = LogFactory.getLog(FilterParamIndexStringRange.class);

    public FilterParamIndexStringRange(FilterSpecLookupable lookupable, ReadWriteLock readWriteLock, FilterOperator filterOperator) {
        super(lookupable, readWriteLock, filterOperator);
        if (!filterOperator.isRangeOperator()) {
            throw new IllegalArgumentException("Invalid filter operator " + (Object)((Object)filterOperator));
        }
    }

    @Override
    public final void matchEvent(EventBean theEvent, Collection<FilterHandle> matches) {
        Object objAttributeValue = this.lookupable.getGetter().get(theEvent);
        if (objAttributeValue == null) {
            return;
        }
        String attributeValue = (String)objAttributeValue;
        StringRange rangeStart = new StringRange(null, attributeValue);
        StringRange rangeEnd = new StringRange(attributeValue, null);
        NavigableMap subMap = this.ranges.subMap(rangeStart, true, rangeEnd, true);
        if (this.getFilterOperator() == FilterOperator.RANGE_OPEN) {
            for (Map.Entry entry : subMap.entrySet()) {
                if (((StringRange)entry.getKey()).getMin().compareTo(attributeValue) >= 0 || ((StringRange)entry.getKey()).getMax().compareTo(attributeValue) <= 0) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(theEvent, matches);
            }
        } else if (this.getFilterOperator() == FilterOperator.RANGE_CLOSED) {
            for (Map.Entry entry : subMap.entrySet()) {
                if (((StringRange)entry.getKey()).getMin().compareTo(attributeValue) > 0 || ((StringRange)entry.getKey()).getMax().compareTo(attributeValue) < 0) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(theEvent, matches);
            }
        } else if (this.getFilterOperator() == FilterOperator.RANGE_HALF_CLOSED) {
            for (Map.Entry entry : subMap.entrySet()) {
                if (((StringRange)entry.getKey()).getMin().compareTo(attributeValue) >= 0 || ((StringRange)entry.getKey()).getMax().compareTo(attributeValue) < 0) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(theEvent, matches);
            }
        } else if (this.getFilterOperator() == FilterOperator.RANGE_HALF_OPEN) {
            for (Map.Entry entry : subMap.entrySet()) {
                if (((StringRange)entry.getKey()).getMin().compareTo(attributeValue) > 0 || ((StringRange)entry.getKey()).getMax().compareTo(attributeValue) <= 0) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(theEvent, matches);
            }
        } else {
            throw new IllegalStateException("Invalid filter operator " + (Object)((Object)this.getFilterOperator()));
        }
    }
}

