/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterServiceBase;
import com.espertech.esper.filter.FilterServiceEntry;
import com.espertech.esper.filter.FilterServiceGranularLockFactoryNone;
import com.espertech.esper.filter.FilterSet;
import com.espertech.esper.filter.FilterValueSet;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class FilterServiceLockCoarse
extends FilterServiceBase {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public FilterServiceLockCoarse(boolean allowIsolation) {
        super(new FilterServiceGranularLockFactoryNone(), allowIsolation);
    }

    @Override
    public void acquireWriteLock() {
        this.lock.writeLock().lock();
    }

    @Override
    public void releaseWriteLock() {
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterSet take(Set<String> statementId) {
        this.lock.writeLock().lock();
        try {
            FilterSet filterSet = super.takeInternal(statementId);
            return filterSet;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(FilterSet filterSet) {
        this.lock.writeLock().lock();
        try {
            super.applyInternal(filterSet);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long evaluate(EventBean theEvent, Collection<FilterHandle> matches) {
        this.lock.readLock().lock();
        try {
            long l = super.evaluateInternal(theEvent, matches);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long evaluate(EventBean theEvent, Collection<FilterHandle> matches, String statementId) {
        this.lock.readLock().lock();
        try {
            long l = super.evaluateInternal(theEvent, matches, statementId);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterServiceEntry add(FilterValueSet filterValueSet, FilterHandle callback) {
        this.lock.writeLock().lock();
        try {
            FilterServiceEntry filterServiceEntry = super.addInternal(filterValueSet, callback);
            return filterServiceEntry;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(FilterHandle callback, FilterServiceEntry filterServiceEntry) {
        this.lock.writeLock().lock();
        try {
            super.removeInternal(callback, filterServiceEntry);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeType(EventType type) {
        this.lock.writeLock().lock();
        try {
            super.removeTypeInternal(type);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

