/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.service.ExprEvaluatorContextWTableAccess;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.visitor.ExprNodeVariableVisitor;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.filter.ExprNodeAdapterBase;
import com.espertech.esper.filter.ExprNodeAdapterBaseStmtLock;
import com.espertech.esper.filter.ExprNodeAdapterBaseVariables;
import com.espertech.esper.filter.ExprNodeAdapterBaseWTableAccess;
import com.espertech.esper.filter.ExprNodeAdapterMultiStream;
import com.espertech.esper.filter.ExprNodeAdapterMultiStreamNoTL;
import com.espertech.esper.filter.ExprNodeAdapterMultiStreamNoTLStmtLock;
import com.espertech.esper.filter.ExprNodeAdapterMultiStreamStmtLock;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class FilterSpecParamExprNode
extends FilterSpecParam {
    private final ExprNode exprNode;
    private final LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes;
    private final LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes;
    private final transient EventAdapterService eventAdapterService;
    private final transient VariableService variableService;
    private final transient TableService tableService;
    private final boolean hasVariable;
    private final boolean useLargeThreadingProfile;
    private final boolean hasFilterStreamSubquery;
    private final boolean hasTableAccess;
    private int filterSpecId;
    private int filterSpecParamPathNum;
    private static final long serialVersionUID = 2298436088557677833L;

    public FilterSpecParamExprNode(FilterSpecLookupable lookupable, FilterOperator filterOperator, ExprNode exprNode, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, VariableService variableService, TableService tableService, EventAdapterService eventAdapterService, ConfigurationInformation configurationInformation, String statementName, boolean hasSubquery, boolean hasTableAccess) throws IllegalArgumentException {
        super(lookupable, filterOperator);
        if (filterOperator != FilterOperator.BOOLEAN_EXPRESSION) {
            throw new IllegalArgumentException("Invalid filter operator for filter expression node");
        }
        this.exprNode = exprNode;
        this.taggedEventTypes = taggedEventTypes;
        this.arrayEventTypes = arrayEventTypes;
        this.variableService = variableService;
        this.tableService = tableService;
        this.eventAdapterService = eventAdapterService;
        this.useLargeThreadingProfile = configurationInformation.getEngineDefaults().getExecution().getThreadingProfile() == ConfigurationEngineDefaults.ThreadingProfile.LARGE;
        this.hasFilterStreamSubquery = hasSubquery;
        this.hasTableAccess = hasTableAccess;
        ExprNodeVariableVisitor visitor = new ExprNodeVariableVisitor();
        exprNode.accept(visitor);
        this.hasVariable = visitor.isHasVariables();
    }

    public ExprNode getExprNode() {
        return this.exprNode;
    }

    public LinkedHashMap<String, Pair<EventType, String>> getTaggedEventTypes() {
        return this.taggedEventTypes;
    }

    @Override
    public final ExprNodeAdapterBase getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext exprEvaluatorContext) {
        ExprNodeAdapterBase adapter;
        EventBean[] events = null;
        if (this.taggedEventTypes != null && !this.taggedEventTypes.isEmpty() || this.arrayEventTypes != null && !this.arrayEventTypes.isEmpty()) {
            int size = 0;
            size += this.taggedEventTypes != null ? this.taggedEventTypes.size() : 0;
            events = new EventBean[(size += this.arrayEventTypes != null ? this.arrayEventTypes.size() : 0) + 1];
            int count = 1;
            if (this.taggedEventTypes != null) {
                for (String string : this.taggedEventTypes.keySet()) {
                    events[count] = matchedEvents.getMatchingEventByTag(string);
                    ++count;
                }
            }
            if (this.arrayEventTypes != null) {
                for (Map.Entry entry : this.arrayEventTypes.entrySet()) {
                    EventType compositeEventType = (EventType)((Pair)entry.getValue()).getFirst();
                    events[count] = this.eventAdapterService.adapterForTypedMap(matchedEvents.getMatchingEventsAsMap(), compositeEventType);
                    ++count;
                }
            }
        }
        if (this.hasTableAccess) {
            exprEvaluatorContext = new ExprEvaluatorContextWTableAccess(exprEvaluatorContext, this.tableService);
        }
        if (events == null) {
            adapter = this.hasFilterStreamSubquery ? new ExprNodeAdapterBaseStmtLock(this.filterSpecId, this.filterSpecParamPathNum, this.exprNode, exprEvaluatorContext, this.variableService) : (!this.hasVariable ? new ExprNodeAdapterBase(this.filterSpecId, this.filterSpecParamPathNum, this.exprNode, exprEvaluatorContext) : new ExprNodeAdapterBaseVariables(this.filterSpecId, this.filterSpecParamPathNum, this.exprNode, exprEvaluatorContext, this.variableService));
        } else {
            VariableService variableServiceToUse;
            VariableService variableService = variableServiceToUse = !this.hasVariable ? null : this.variableService;
            adapter = this.useLargeThreadingProfile ? (this.hasFilterStreamSubquery ? new ExprNodeAdapterMultiStreamNoTLStmtLock(this.filterSpecId, this.filterSpecParamPathNum, this.exprNode, exprEvaluatorContext, variableServiceToUse, events) : new ExprNodeAdapterMultiStreamNoTL(this.filterSpecId, this.filterSpecParamPathNum, this.exprNode, exprEvaluatorContext, variableServiceToUse, events)) : (this.hasFilterStreamSubquery ? new ExprNodeAdapterMultiStreamStmtLock(this.filterSpecId, this.filterSpecParamPathNum, this.exprNode, exprEvaluatorContext, variableServiceToUse, events) : new ExprNodeAdapterMultiStream(this.filterSpecId, this.filterSpecParamPathNum, this.exprNode, exprEvaluatorContext, variableServiceToUse, events));
        }
        if (!this.hasTableAccess) {
            return adapter;
        }
        return new ExprNodeAdapterBaseWTableAccess(this.filterSpecId, this.filterSpecParamPathNum, this.exprNode, exprEvaluatorContext, adapter, this.tableService);
    }

    @Override
    public final String toString() {
        return super.toString() + "  exprNode=" + this.exprNode.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamExprNode)) {
            return false;
        }
        FilterSpecParamExprNode other = (FilterSpecParamExprNode)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.exprNode == other.exprNode;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.exprNode.hashCode();
        return result;
    }

    public int getFilterSpecId() {
        return this.filterSpecId;
    }

    public void setFilterSpecId(int filterSpecId) {
        this.filterSpecId = filterSpecId;
    }

    public int getFilterSpecParamPathNum() {
        return this.filterSpecParamPathNum;
    }

    public void setFilterSpecParamPathNum(int filterSpecParamPathNum) {
        this.filterSpecParamPathNum = filterSpecParamPathNum;
    }
}

