/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.filter.DoubleRange;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterSpecParamRangeValue;
import com.espertech.esper.filter.StringRange;
import com.espertech.esper.pattern.MatchedEventMap;

public final class FilterSpecParamRange
extends FilterSpecParam {
    private final FilterSpecParamRangeValue min;
    private final FilterSpecParamRangeValue max;
    private static final long serialVersionUID = -3381167844631490119L;

    public FilterSpecParamRange(FilterSpecLookupable lookupable, FilterOperator filterOperator, FilterSpecParamRangeValue min, FilterSpecParamRangeValue max) throws IllegalArgumentException {
        super(lookupable, filterOperator);
        this.min = min;
        this.max = max;
        if (!filterOperator.isRangeOperator() && !filterOperator.isInvertedRangeOperator()) {
            throw new IllegalArgumentException("Illegal filter operator " + (Object)((Object)filterOperator) + " supplied to " + "range filter parameter");
        }
    }

    @Override
    public final Object getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext evaluatorContext) {
        if (this.lookupable.getReturnType() == String.class) {
            return new StringRange((String)this.min.getFilterValue(matchedEvents, evaluatorContext), (String)this.max.getFilterValue(matchedEvents, evaluatorContext));
        }
        Double begin = (Double)this.min.getFilterValue(matchedEvents, evaluatorContext);
        Double end = (Double)this.max.getFilterValue(matchedEvents, evaluatorContext);
        return new DoubleRange(begin, end);
    }

    public FilterSpecParamRangeValue getMin() {
        return this.min;
    }

    public FilterSpecParamRangeValue getMax() {
        return this.max;
    }

    @Override
    public final String toString() {
        return super.toString() + "  range=(min=" + this.min.toString() + ",max=" + this.max.toString() + ')';
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamRange)) {
            return false;
        }
        FilterSpecParamRange other = (FilterSpecParamRange)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.min.equals(other.min) && this.max.equals(other.max);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
        result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
        return result;
    }
}

