/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.metrics.codahale_metrics.metrics.util;

import com.espertech.esper.metrics.codahale_metrics.metrics.core.HealthCheck;
import com.espertech.esper.metrics.codahale_metrics.metrics.core.VirtualMachineMetrics;
import java.util.Set;

public class DeadlockHealthCheck
extends HealthCheck {
    private final VirtualMachineMetrics vm;

    public DeadlockHealthCheck(VirtualMachineMetrics vm) {
        super("deadlocks");
        this.vm = vm;
    }

    public DeadlockHealthCheck() {
        this(VirtualMachineMetrics.getInstance());
    }

    @Override
    protected HealthCheck.Result check() throws Exception {
        Set<String> threads = this.vm.deadlockedThreads();
        if (threads.isEmpty()) {
            return HealthCheck.Result.healthy();
        }
        StringBuilder builder = new StringBuilder("Deadlocked threads detected:\n");
        for (String thread : threads) {
            builder.append(thread).append('\n');
        }
        return HealthCheck.Result.unhealthy(builder.toString());
    }
}

