/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.metrics.jmx;

import com.espertech.esper.metrics.codahale_metrics.metrics.core.MetricName;
import com.espertech.esper.metrics.jmx.JmxGetter;
import com.espertech.esper.metrics.jmx.JmxManaged;
import com.espertech.esper.metrics.jmx.JmxOperation;
import com.espertech.esper.metrics.jmx.JmxParam;
import com.espertech.esper.metrics.jmx.JmxSetter;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonJMXUtil {
    private static Log log = LogFactory.getLog(CommonJMXUtil.class);
    private static final Object LOCK = new Object();

    public static void registerMbean(Object mbean, MetricName name) {
        ObjectName on;
        try {
            on = new ObjectName(name.getMBeanName());
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)("Failed to obtain object name for '" + name.getMBeanName() + "': " + e.getMessage()), (Throwable)e);
            return;
        }
        CommonJMXUtil.registerMbean(mbean, on);
    }

    public static void registerMBeanNonModel(ObjectName objectName, Object internal) {
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(internal, objectName);
        }
        catch (Exception e) {
            log.error((Object)("Error registering mbean: " + e.getMessage()), (Throwable)e);
        }
    }

    public static void unregisterMbean(MBeanServer server, ObjectName name) {
        try {
            server.unregisterMBean(name);
        }
        catch (Exception e) {
            log.error((Object)("Error unregistering mbean: " + e.getMessage()), (Throwable)e);
        }
    }

    public static void unregisterMbean(MetricName name) {
        ObjectName on;
        try {
            on = new ObjectName(name.getMBeanName());
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)("Failed to obtain object name for '" + name.getMBeanName() + "': " + e.getMessage()), (Throwable)e);
            return;
        }
        CommonJMXUtil.unregisterMbean(on);
    }

    public static String buildDefaultURL(String host, int rmiport, int jmxport) {
        return "service:jmx:rmi://" + host + ":" + jmxport + "/jndi/rmi://" + host + ":" + rmiport + "/jmxrmi";
    }

    private static void unregisterMbean(ObjectName name) {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(name);
        }
        catch (Exception e) {
            log.error((Object)("Error unregistering mbean: " + e.getMessage()), (Throwable)e);
        }
    }

    private static void registerMbean(Object mbean, ObjectName name) {
        try {
            CommonJMXUtil.registerMbean(ManagementFactory.getPlatformMBeanServer(), CommonJMXUtil.createModelMBean(mbean), name);
        }
        catch (Exception e) {
            log.error((Object)("Error registering mbean: " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerMbean(MBeanServer server, ModelMBean mbean, ObjectName name) {
        try {
            Object object = LOCK;
            synchronized (object) {
                if (server.isRegistered(name)) {
                    CommonJMXUtil.unregisterMbean(server, name);
                }
                server.registerMBean(mbean, name);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error registering mbean:" + e.getMessage()), (Throwable)e);
        }
    }

    private static ModelMBean createModelMBean(Object o) {
        try {
            RequiredModelMBean mbean = new RequiredModelMBean();
            JmxManaged annotation = o.getClass().getAnnotation(JmxManaged.class);
            String description = annotation == null ? "" : annotation.description();
            ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(o.getClass().getName(), description, CommonJMXUtil.extractAttributeInfo(o), new ModelMBeanConstructorInfo[0], CommonJMXUtil.extractOperationInfo(o), new ModelMBeanNotificationInfo[0]);
            mbean.setModelMBeanInfo(info);
            mbean.setManagedResource(o, "ObjectReference");
            return mbean;
        }
        catch (MBeanException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new RuntimeException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static ModelMBeanOperationInfo[] extractOperationInfo(Object object) {
        ArrayList<ModelMBeanOperationInfo> infos = new ArrayList<ModelMBeanOperationInfo>();
        for (Method m : object.getClass().getMethods()) {
            JmxOperation jmxOperation = m.getAnnotation(JmxOperation.class);
            JmxGetter jmxGetter = m.getAnnotation(JmxGetter.class);
            JmxSetter jmxSetter = m.getAnnotation(JmxSetter.class);
            if (jmxOperation == null && jmxGetter == null && jmxSetter == null) continue;
            String description = "";
            int visibility = 1;
            int impact = 3;
            if (jmxOperation != null) {
                description = jmxOperation.description();
                impact = jmxOperation.impact();
            } else if (jmxGetter != null) {
                description = jmxGetter.description();
                impact = 0;
                visibility = 4;
            } else if (jmxSetter != null) {
                description = jmxSetter.description();
                impact = 1;
                visibility = 4;
            }
            ModelMBeanOperationInfo info = new ModelMBeanOperationInfo(m.getName(), description, CommonJMXUtil.extractParameterInfo(m), m.getReturnType().getName(), impact);
            info.getDescriptor().setField("visibility", Integer.toString(visibility));
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanOperationInfo[infos.size()]);
    }

    private static ModelMBeanAttributeInfo[] extractAttributeInfo(Object object) {
        Object setter;
        Object getter;
        HashMap<String, Method> getters = new HashMap<String, Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        HashMap<String, String> descriptions = new HashMap<String, String>();
        for (Method m : object.getClass().getMethods()) {
            getter = m.getAnnotation(JmxGetter.class);
            if (getter != null) {
                getters.put(getter.name(), m);
                descriptions.put(getter.name(), getter.description());
            }
            if ((setter = m.getAnnotation(JmxSetter.class)) == null) continue;
            setters.put(setter.name(), m);
            descriptions.put(setter.name(), setter.description());
        }
        HashSet attributes = new HashSet(getters.keySet());
        attributes.addAll(setters.keySet());
        ArrayList<ModelMBeanAttributeInfo> infos = new ArrayList<ModelMBeanAttributeInfo>();
        for (String name : attributes) {
            try {
                getter = (Method)getters.get(name);
                setter = (Method)setters.get(name);
                ModelMBeanAttributeInfo info = new ModelMBeanAttributeInfo(name, (String)descriptions.get(name), (Method)getter, (Method)setter);
                Descriptor descriptor = info.getDescriptor();
                if (getter != null) {
                    descriptor.setField("getMethod", ((Method)getter).getName());
                }
                if (setter != null) {
                    descriptor.setField("setMethod", ((Method)setter).getName());
                }
                info.setDescriptor(descriptor);
                infos.add(info);
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
        }
        return infos.toArray(new ModelMBeanAttributeInfo[infos.size()]);
    }

    private static MBeanParameterInfo[] extractParameterInfo(Method m) {
        Class<?>[] types = m.getParameterTypes();
        Annotation[][] annotations = m.getParameterAnnotations();
        MBeanParameterInfo[] params = new MBeanParameterInfo[types.length];
        for (int i = 0; i < params.length; ++i) {
            boolean hasAnnotation = false;
            for (int j = 0; j < annotations[i].length; ++j) {
                if (!(annotations[i][j] instanceof JmxParam)) continue;
                JmxParam param = (JmxParam)annotations[i][j];
                params[i] = new MBeanParameterInfo(param.name(), types[i].getName(), param.description());
                hasAnnotation = true;
                break;
            }
            if (hasAnnotation) continue;
            params[i] = new MBeanParameterInfo("", types[i].getName(), "");
        }
        return params;
    }
}

