/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.map.MapEventBean;
import com.espertech.esper.pattern.MatchedEventConvertor;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.MatchedEventMapMeta;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class MatchedEventConvertorImpl
implements MatchedEventConvertor {
    private final EventBean[] eventsPerStream;
    private final LinkedHashMap<String, Pair<EventType, String>> filterTypes;
    private final LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes;
    private final MatchedEventMapMeta matchedEventMapMeta;

    public MatchedEventConvertorImpl(LinkedHashMap<String, Pair<EventType, String>> filterTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, LinkedHashSet<String> allTags, EventAdapterService eventAdapterService) {
        int size = filterTypes.size();
        if (arrayEventTypes != null) {
            size += arrayEventTypes.size();
        }
        this.eventsPerStream = new EventBean[size];
        this.filterTypes = new LinkedHashMap<String, Pair<EventType, String>>(filterTypes);
        this.arrayEventTypes = arrayEventTypes != null ? new LinkedHashMap<String, Pair<EventType, String>>(arrayEventTypes) : new LinkedHashMap();
        this.matchedEventMapMeta = new MatchedEventMapMeta(allTags.toArray(new String[allTags.size()]), !this.arrayEventTypes.isEmpty());
    }

    @Override
    public EventBean[] convert(MatchedEventMap events) {
        int count = 0;
        for (Map.Entry<String, Pair<EventType, String>> entry : this.filterTypes.entrySet()) {
            EventBean theEvent = events.getMatchingEventByTag(entry.getKey());
            this.eventsPerStream[count++] = theEvent;
        }
        if (this.arrayEventTypes != null) {
            for (Map.Entry<String, Pair<EventType, String>> entry : this.arrayEventTypes.entrySet()) {
                EventBean[] eventArray = (EventBean[])events.getMatchingEventAsObjectByTag(entry.getKey());
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(entry.getKey(), eventArray);
                MapEventBean theEvent = new MapEventBean(map, null);
                this.eventsPerStream[count++] = theEvent;
            }
        }
        return this.eventsPerStream;
    }

    @Override
    public MatchedEventMapMeta getMatchedEventMapMeta() {
        return this.matchedEventMapMeta;
    }
}

