/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.schedule;

import com.espertech.esper.schedule.ScheduleCalendar;
import com.espertech.esper.schedule.ScheduleSpec;
import com.espertech.esper.type.CronOperatorEnum;
import com.espertech.esper.type.CronParameter;
import com.espertech.esper.type.ScheduleUnit;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.Calendar;
import java.util.Date;
import java.util.SortedSet;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ScheduleComputeHelper {
    private static final Log log = LogFactory.getLog(ScheduleComputeHelper.class);
    private static int[] DAY_OF_WEEK_ARRAY = new int[]{1, 2, 3, 4, 5, 6, 7};
    private static final int MIN_OFFSET_MSEC = 1000;

    public static long computeNextOccurance(ScheduleSpec spec, long afterTimeInMillis, TimeZone timeZone) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".computeNextOccurance Computing next occurance, afterTimeInMillis=" + new Date(afterTimeInMillis) + "  as long=" + afterTimeInMillis + "  spec=" + spec));
        }
        afterTimeInMillis = spec.getUnitValues().containsKey((Object)ScheduleUnit.SECONDS) ? (afterTimeInMillis += 1000L) : (afterTimeInMillis += 60000L);
        return ScheduleComputeHelper.compute(spec, afterTimeInMillis, timeZone);
    }

    public static long computeDeltaNextOccurance(ScheduleSpec spec, long afterTimeInMillis, TimeZone timeZone) {
        return ScheduleComputeHelper.computeNextOccurance(spec, afterTimeInMillis, timeZone) - afterTimeInMillis;
    }

    private static long compute(ScheduleSpec spec, long afterTimeInMillis, TimeZone timeZone) {
        ScheduleCalendar result;
        Calendar after;
        while (true) {
            after = spec.getOptionalTimeZone() != null ? Calendar.getInstance(TimeZone.getTimeZone(spec.getOptionalTimeZone())) : Calendar.getInstance(timeZone);
            after.setTimeInMillis(afterTimeInMillis);
            result = new ScheduleCalendar();
            result.setMilliseconds(after.get(14));
            SortedSet<Integer> minutesSet = spec.getUnitValues().get((Object)ScheduleUnit.MINUTES);
            SortedSet<Integer> hoursSet = spec.getUnitValues().get((Object)ScheduleUnit.HOURS);
            SortedSet<Integer> monthsSet = spec.getUnitValues().get((Object)ScheduleUnit.MONTHS);
            SortedSet<Integer> secondsSet = null;
            boolean isSecondsSpecified = false;
            if (spec.getUnitValues().containsKey((Object)ScheduleUnit.SECONDS)) {
                isSecondsSpecified = true;
                secondsSet = spec.getUnitValues().get((Object)ScheduleUnit.SECONDS);
            }
            if (isSecondsSpecified) {
                result.setSecond(ScheduleComputeHelper.nextValue(secondsSet, after.get(13)));
                if (result.getSecond() == -1) {
                    result.setSecond(ScheduleComputeHelper.nextValue(secondsSet, 0));
                    after.add(12, 1);
                }
            }
            result.setMinute(ScheduleComputeHelper.nextValue(minutesSet, after.get(12)));
            if (result.getMinute() != after.get(12)) {
                result.setSecond(ScheduleComputeHelper.nextValue(secondsSet, 0));
            }
            if (result.getMinute() == -1) {
                result.setMinute(ScheduleComputeHelper.nextValue(minutesSet, 0));
                after.add(11, 1);
            }
            result.setHour(ScheduleComputeHelper.nextValue(hoursSet, after.get(11)));
            if (result.getHour() != after.get(11)) {
                result.setSecond(ScheduleComputeHelper.nextValue(secondsSet, 0));
                result.setMinute(ScheduleComputeHelper.nextValue(minutesSet, 0));
            }
            if (result.getHour() == -1) {
                result.setHour(ScheduleComputeHelper.nextValue(hoursSet, 0));
                after.add(5, 1);
            }
            result.setDayOfMonth(ScheduleComputeHelper.determineDayOfMonth(spec, after, result));
            boolean dayMatchRealDate = false;
            while (!dayMatchRealDate) {
                if (ScheduleComputeHelper.checkDayValidInMonth(timeZone, result.getDayOfMonth(), after.get(2), after.get(1))) {
                    dayMatchRealDate = true;
                    continue;
                }
                after.add(2, 1);
            }
            int currentMonth = after.get(2) + 1;
            result.setMonth(ScheduleComputeHelper.nextValue(monthsSet, currentMonth));
            if (result.getMonth() != currentMonth) {
                result.setSecond(ScheduleComputeHelper.nextValue(secondsSet, 0));
                result.setMinute(ScheduleComputeHelper.nextValue(minutesSet, 0));
                result.setHour(ScheduleComputeHelper.nextValue(hoursSet, 0));
                result.setDayOfMonth(ScheduleComputeHelper.determineDayOfMonth(spec, after, result));
            }
            if (result.getMonth() == -1) {
                result.setMonth(ScheduleComputeHelper.nextValue(monthsSet, 0));
                after.add(1, 1);
            }
            int year = after.get(1);
            if (ScheduleComputeHelper.checkDayValidInMonth(timeZone, result.getDayOfMonth(), result.getMonth() - 1, year)) break;
            afterTimeInMillis = after.getTimeInMillis();
        }
        return ScheduleComputeHelper.getTime(result, after.get(1), spec.getOptionalTimeZone(), timeZone);
    }

    private static int determineDayOfMonth(ScheduleSpec spec, Calendar after, ScheduleCalendar result) {
        int dayOfMonth;
        SortedSet<Integer> daysOfMonthSet = spec.getUnitValues().get((Object)ScheduleUnit.DAYS_OF_MONTH);
        SortedSet<Integer> daysOfWeekSet = spec.getUnitValues().get((Object)ScheduleUnit.DAYS_OF_WEEK);
        SortedSet<Integer> secondsSet = spec.getUnitValues().get((Object)ScheduleUnit.SECONDS);
        SortedSet<Integer> minutesSet = spec.getUnitValues().get((Object)ScheduleUnit.MINUTES);
        SortedSet<Integer> hoursSet = spec.getUnitValues().get((Object)ScheduleUnit.HOURS);
        if (spec.getOptionalDayOfMonthOperator() != null || spec.getOptionalDayOfWeekOperator() != null) {
            boolean isWeek = false;
            CronParameter op = spec.getOptionalDayOfMonthOperator();
            if (spec.getOptionalDayOfMonthOperator() == null) {
                op = spec.getOptionalDayOfWeekOperator();
                isWeek = true;
            }
            int currentYYMMDD = ScheduleComputeHelper.getTimeYYYYMMDD(after);
            ScheduleComputeHelper.increaseAfterDayOfMonthSpecialOp(op.getOperator(), op.getDay(), op.getMonth(), isWeek, after);
            int rolledYYMMDD = ScheduleComputeHelper.getTimeYYYYMMDD(after);
            if (rolledYYMMDD > currentYYMMDD) {
                result.setSecond(ScheduleComputeHelper.nextValue(secondsSet, 0));
                result.setMinute(ScheduleComputeHelper.nextValue(minutesSet, 0));
                result.setHour(ScheduleComputeHelper.nextValue(hoursSet, 0));
                return after.get(5);
            }
            if (rolledYYMMDD < currentYYMMDD) {
                throw new IllegalStateException("Failed to evaluate special date op, rolled date less then current date");
            }
            Calendar work = (Calendar)after.clone();
            work.set(13, result.getSecond());
            work.set(12, result.getMinute());
            work.set(11, result.getHour());
            if (!work.after(after)) {
                after.add(5, 1);
                result.setSecond(ScheduleComputeHelper.nextValue(secondsSet, 0));
                result.setMinute(ScheduleComputeHelper.nextValue(minutesSet, 0));
                result.setHour(ScheduleComputeHelper.nextValue(hoursSet, 0));
                ScheduleComputeHelper.increaseAfterDayOfMonthSpecialOp(op.getOperator(), op.getDay(), op.getMonth(), isWeek, after);
            }
            return after.get(5);
        }
        if (daysOfWeekSet == null) {
            dayOfMonth = ScheduleComputeHelper.nextValue(daysOfMonthSet, after.get(5));
            if (dayOfMonth != after.get(5)) {
                result.setSecond(ScheduleComputeHelper.nextValue(secondsSet, 0));
                result.setMinute(ScheduleComputeHelper.nextValue(minutesSet, 0));
                result.setHour(ScheduleComputeHelper.nextValue(hoursSet, 0));
            }
            if (dayOfMonth == -1) {
                dayOfMonth = ScheduleComputeHelper.nextValue(daysOfMonthSet, 0);
                after.add(2, 1);
            }
        } else if (daysOfMonthSet == null) {
            while (true) {
                dayOfMonth = after.get(5);
                int dayOfWeek = after.get(7) - 1;
                if (!daysOfWeekSet.contains(dayOfWeek)) {
                    result.setSecond(ScheduleComputeHelper.nextValue(secondsSet, 0));
                    result.setMinute(ScheduleComputeHelper.nextValue(minutesSet, 0));
                    result.setHour(ScheduleComputeHelper.nextValue(hoursSet, 0));
                    after.add(5, 1);
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                dayOfMonth = after.get(5);
                int dayOfWeek = after.get(7) - 1;
                if (daysOfWeekSet.contains(dayOfWeek) || daysOfMonthSet.contains(dayOfMonth)) break;
                result.setSecond(ScheduleComputeHelper.nextValue(secondsSet, 0));
                result.setMinute(ScheduleComputeHelper.nextValue(minutesSet, 0));
                result.setHour(ScheduleComputeHelper.nextValue(hoursSet, 0));
                after.add(5, 1);
            }
        }
        return dayOfMonth;
    }

    private static long getTime(ScheduleCalendar result, int year, String optionalTimeZone, TimeZone timeZone) {
        Calendar calendar = optionalTimeZone != null ? Calendar.getInstance(TimeZone.getTimeZone(optionalTimeZone)) : Calendar.getInstance(timeZone);
        calendar.set(year, result.getMonth() - 1, result.getDayOfMonth(), result.getHour(), result.getMinute(), result.getSecond());
        calendar.set(14, result.getMilliseconds());
        return calendar.getTimeInMillis();
    }

    private static boolean checkDayValidInMonth(TimeZone timeZone, int day, int month, int year) {
        try {
            Calendar calendar = Calendar.getInstance(timeZone);
            calendar.setLenient(false);
            calendar.set(1, year);
            calendar.set(2, month);
            calendar.set(5, day);
            calendar.getTime();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private static int nextValue(SortedSet<Integer> valueSet, int startValue) {
        if (valueSet == null) {
            return startValue;
        }
        if (valueSet.contains(startValue)) {
            return startValue;
        }
        SortedSet<Integer> tailSet = valueSet.tailSet(startValue + 1);
        if (tailSet.isEmpty()) {
            return -1;
        }
        return tailSet.first();
    }

    private static int getTimeYYYYMMDD(Calendar calendar) {
        return 10000 * calendar.get(1) + (calendar.get(2) + 1) * 100 + calendar.get(5);
    }

    private static void increaseAfterDayOfMonthSpecialOp(CronOperatorEnum operator, Integer day, Integer month, boolean week, Calendar after) {
        DateChecker checker = operator == CronOperatorEnum.LASTDAY ? (!week ? new DateCheckerLastDayOfMonth(day, month) : (day == null ? new DateCheckerLastDayOfWeek(month) : new DateCheckerLastSpecificDayWeek(day, month))) : (operator == CronOperatorEnum.LASTWEEKDAY ? new DateCheckerLastWeekday(day, month) : new DateCheckerMonthWeekday(day, month));
        int dayCount = 0;
        while (!checker.fits(after)) {
            after.add(5, 1);
            if (++dayCount <= 10000) continue;
            throw new IllegalArgumentException("Invalid crontab expression: failed to find match day");
        }
    }

    private static boolean isWeekday(Calendar cal) {
        int dayOfWeek = cal.get(7);
        return dayOfWeek >= 2 && dayOfWeek <= 6;
    }

    public static class DateCheckerMonthWeekday
    implements DateChecker {
        private final Integer day;
        private final Integer month;

        private DateCheckerMonthWeekday(Integer day, Integer month) {
            if (day != null && (day < 1 || day > 31)) {
                throw new IllegalArgumentException("xx day of the month has to be a in range (1-31)");
            }
            this.day = day;
            this.month = month;
        }

        @Override
        public boolean fits(Calendar cal) {
            if (this.month != null && this.month.intValue() != cal.get(2)) {
                return false;
            }
            if (!ScheduleComputeHelper.isWeekday(cal)) {
                return false;
            }
            if (this.day == null) {
                return true;
            }
            Calendar work = (Calendar)cal.clone();
            int target = DateCheckerMonthWeekday.computeNearestWeekdayDay(this.day, work);
            return cal.get(5) == target;
        }

        private static int computeNearestWeekdayDay(int day, Calendar work) {
            int max = work.getActualMaximum(5);
            if (day <= max) {
                work.set(5, day);
            } else {
                work.set(5, max);
            }
            if (ScheduleComputeHelper.isWeekday(work)) {
                return work.get(5);
            }
            if (work.get(7) == 7) {
                if (work.get(5) > 1) {
                    work.add(5, -1);
                    return work.get(5);
                }
                work.add(5, 2);
                return work.get(5);
            }
            if (max == work.get(5)) {
                work.add(5, -2);
                return work.get(5);
            }
            work.add(5, 1);
            return work.get(5);
        }
    }

    private static class DateCheckerLastWeekday
    implements DateChecker {
        private final Integer dayCode;
        private final Integer month;

        private DateCheckerLastWeekday(Integer day, Integer month) {
            if (day != null) {
                if (day < 0 || day > 7) {
                    throw new IllegalArgumentException("Last xx day of the month has to be a day of week (0-7)");
                }
                this.dayCode = DAY_OF_WEEK_ARRAY[day];
            } else {
                this.dayCode = null;
            }
            this.month = month;
        }

        @Override
        public boolean fits(Calendar cal) {
            int max;
            if (this.dayCode != null && this.dayCode.intValue() != cal.get(7)) {
                return false;
            }
            if (this.month != null && this.month.intValue() != cal.get(2)) {
                return false;
            }
            if (!ScheduleComputeHelper.isWeekday(cal)) {
                return false;
            }
            int day = cal.get(5);
            if (day == (max = cal.getActualMaximum(5))) {
                return true;
            }
            int dayOfWeek = cal.get(7);
            return day >= max - 2 && dayOfWeek == 6;
        }
    }

    private static class DateCheckerLastDayOfWeek
    implements DateChecker {
        private final Integer month;

        private DateCheckerLastDayOfWeek(Integer month) {
            this.month = month;
        }

        @Override
        public boolean fits(Calendar cal) {
            if (this.month != null && this.month.intValue() != cal.get(2)) {
                return false;
            }
            return cal.get(7) == 7;
        }
    }

    private static class DateCheckerLastDayOfMonth
    implements DateChecker {
        private final Integer dayCode;
        private final Integer month;

        private DateCheckerLastDayOfMonth(Integer day, Integer month) {
            if (day != null) {
                if (day < 0 || day > 7) {
                    throw new IllegalArgumentException("Last xx day of the month has to be a day of week (0-7)");
                }
                this.dayCode = DAY_OF_WEEK_ARRAY[day];
            } else {
                this.dayCode = null;
            }
            this.month = month;
        }

        @Override
        public boolean fits(Calendar cal) {
            if (this.dayCode != null && this.dayCode.intValue() != cal.get(7)) {
                return false;
            }
            if (this.month != null && this.month.intValue() != cal.get(2)) {
                return false;
            }
            return cal.get(5) == cal.getActualMaximum(5);
        }
    }

    private static class DateCheckerLastSpecificDayWeek
    implements DateChecker {
        private final int dayCode;
        private final Integer month;

        private DateCheckerLastSpecificDayWeek(int day, Integer month) {
            if (day < 0 || day > 7) {
                throw new IllegalArgumentException("Last xx day of the month has to be a day of week (0-7)");
            }
            this.dayCode = DAY_OF_WEEK_ARRAY[day];
            this.month = month;
        }

        @Override
        public boolean fits(Calendar cal) {
            if (this.dayCode != cal.get(7)) {
                return false;
            }
            if (this.month != null && this.month.intValue() != cal.get(2)) {
                return false;
            }
            return cal.get(5) > cal.getActualMaximum(5) - 7;
        }
    }

    private static interface DateChecker {
        public boolean fits(Calendar var1);
    }
}

