/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.client.EPException;
import java.net.MalformedURLException;
import java.net.URL;

public class ResourceLoader {
    public static URL resolveClassPathOrURLResource(String resourceName, String urlOrClasspathResource) {
        URL url;
        try {
            url = new URL(urlOrClasspathResource);
        }
        catch (MalformedURLException ex) {
            url = ResourceLoader.getClasspathResourceAsURL(resourceName, urlOrClasspathResource);
        }
        return url;
    }

    public static URL getClasspathResourceAsURL(String resourceName, String resource) {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        URL url = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            url = classLoader.getResource(stripped);
        }
        if (url == null) {
            url = ResourceLoader.class.getResource(resource);
        }
        if (url == null) {
            url = ResourceLoader.class.getClassLoader().getResource(stripped);
        }
        if (url == null) {
            throw new EPException(resourceName + " resource '" + resource + "' not found");
        }
        return url;
    }
}

