/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleTypeCaster;
import com.espertech.esper.util.SimpleTypeCasterAnyType;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SimpleTypeCasterFactory {
    public static SimpleTypeCaster getCaster(Class fromType, Class targetType) {
        if (fromType == targetType) {
            return new NullCaster();
        }
        if ((targetType = JavaClassHelper.getBoxedType(targetType)) == Integer.class) {
            return new IntCaster();
        }
        if (targetType == Long.class) {
            return new LongCaster();
        }
        if (targetType == Double.class) {
            return new DoubleCaster();
        }
        if (targetType == Float.class) {
            return new FloatCaster();
        }
        if (targetType == Short.class) {
            return new ShortCaster();
        }
        if (targetType == Byte.class) {
            return new ByteCaster();
        }
        if (targetType == Character.class && fromType == String.class) {
            return new CharacterCaster();
        }
        if (targetType == BigInteger.class) {
            return new BigIntCaster();
        }
        if (targetType == BigDecimal.class) {
            if (JavaClassHelper.isFloatingPointClass(fromType)) {
                return new BigDecDoubleCaster();
            }
            return new BigDecLongCaster();
        }
        return new SimpleTypeCasterAnyType(targetType);
    }

    private static class NullCaster
    implements SimpleTypeCaster {
        private NullCaster() {
        }

        @Override
        public Object cast(Object object) {
            return object;
        }

        @Override
        public boolean isNumericCast() {
            return false;
        }
    }

    private static class BigDecDoubleCaster
    implements SimpleTypeCaster {
        private BigDecDoubleCaster() {
        }

        @Override
        public Object cast(Object object) {
            double value = ((Number)object).doubleValue();
            return new BigDecimal(value);
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }
    }

    private static class BigDecLongCaster
    implements SimpleTypeCaster {
        private BigDecLongCaster() {
        }

        @Override
        public Object cast(Object object) {
            long value = ((Number)object).longValue();
            return new BigDecimal(value);
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }
    }

    private static class BigIntCaster
    implements SimpleTypeCaster {
        private BigIntCaster() {
        }

        @Override
        public Object cast(Object object) {
            long value = ((Number)object).longValue();
            return BigInteger.valueOf(value);
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }
    }

    private static class CharacterCaster
    implements SimpleTypeCaster {
        private CharacterCaster() {
        }

        @Override
        public Object cast(Object object) {
            String value = object.toString();
            if (value == null || value.length() == 0) {
                return null;
            }
            return Character.valueOf(value.charAt(0));
        }

        @Override
        public boolean isNumericCast() {
            return false;
        }
    }

    private static class ByteCaster
    implements SimpleTypeCaster {
        private ByteCaster() {
        }

        @Override
        public Object cast(Object object) {
            return ((Number)object).byteValue();
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }
    }

    private static class ShortCaster
    implements SimpleTypeCaster {
        private ShortCaster() {
        }

        @Override
        public Object cast(Object object) {
            return ((Number)object).shortValue();
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }
    }

    private static class IntCaster
    implements SimpleTypeCaster {
        private IntCaster() {
        }

        @Override
        public Object cast(Object object) {
            return ((Number)object).intValue();
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }
    }

    private static class LongCaster
    implements SimpleTypeCaster {
        private LongCaster() {
        }

        @Override
        public Object cast(Object object) {
            return ((Number)object).longValue();
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }
    }

    private static class FloatCaster
    implements SimpleTypeCaster {
        private FloatCaster() {
        }

        @Override
        public Object cast(Object object) {
            return Float.valueOf(((Number)object).floatValue());
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }
    }

    private static class DoubleCaster
    implements SimpleTypeCaster {
        private DoubleCaster() {
        }

        @Override
        public Object cast(Object object) {
            return ((Number)object).doubleValue();
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }
    }
}

