/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.internal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.RollingEventBuffer;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.view.internal.PriorEventBufferChangeCaptureMulti;
import com.espertech.esper.view.window.RelativeAccessByEventNIndex;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PriorEventBufferMulti
implements ViewUpdatedCollection,
RelativeAccessByEventNIndex {
    private final int priorToIndexesSize;
    private final int[] priorToIndexes;
    private final Map<EventBean, EventBean[]> priorEventMap;
    private final RollingEventBuffer newEvents;
    private EventBean[] lastOldData;

    public PriorEventBufferMulti(int[] priorToIndexSet) {
        int maxPriorIndex = 0;
        int[] arr$ = priorToIndexSet;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer priorIndex = arr$[i$];
            if (priorIndex <= maxPriorIndex) continue;
            maxPriorIndex = priorIndex;
        }
        this.priorToIndexesSize = priorToIndexSet.length;
        this.priorToIndexes = new int[this.priorToIndexesSize];
        int count = 0;
        int[] arr$2 = priorToIndexSet;
        int len$2 = arr$2.length;
        for (int i$ = 0; i$ < len$2; ++i$) {
            Integer priorIndex = arr$2[i$];
            this.priorToIndexes[count++] = priorIndex;
        }
        Arrays.sort(this.priorToIndexes);
        this.newEvents = new RollingEventBuffer(maxPriorIndex + 1);
        this.priorEventMap = new HashMap<EventBean, EventBean[]>();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        int i;
        if (this.lastOldData != null) {
            for (i = 0; i < this.lastOldData.length; ++i) {
                this.priorEventMap.remove(this.lastOldData[i]);
            }
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                EventBean newEvent = newData[i];
                this.newEvents.add(newEvent);
                EventBean[] priorEvents = new EventBean[this.priorToIndexesSize];
                for (int j = 0; j < this.priorToIndexesSize; ++j) {
                    int priorIndex = this.priorToIndexes[j];
                    priorEvents[j] = this.newEvents.get(priorIndex);
                }
                this.priorEventMap.put(newEvent, priorEvents);
            }
        }
        this.lastOldData = oldData;
    }

    public void update(EventBean[] newData, EventBean[] oldData, PriorEventBufferChangeCaptureMulti capture) {
        int i;
        if (this.lastOldData != null) {
            for (i = 0; i < this.lastOldData.length; ++i) {
                EventBean oldDataItem = this.lastOldData[i];
                this.priorEventMap.remove(oldDataItem);
                capture.removed(oldDataItem);
            }
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                EventBean newEvent = newData[i];
                this.newEvents.add(newEvent);
                EventBean[] priorEvents = new EventBean[this.priorToIndexesSize];
                for (int j = 0; j < this.priorToIndexesSize; ++j) {
                    int priorIndex = this.priorToIndexes[j];
                    priorEvents[j] = this.newEvents.get(priorIndex);
                }
                this.priorEventMap.put(newEvent, priorEvents);
                capture.added(newEvent, priorEvents);
            }
        }
        this.lastOldData = oldData;
    }

    @Override
    public EventBean getRelativeToEvent(EventBean theEvent, int priorToIndex) {
        if (priorToIndex >= this.priorToIndexesSize) {
            throw new IllegalArgumentException("Index " + priorToIndex + " not allowed, max size is " + this.priorToIndexesSize);
        }
        EventBean[] priorEvents = this.priorEventMap.get(theEvent);
        if (priorEvents == null) {
            throw new IllegalStateException("Event not currently in collection, event=" + theEvent);
        }
        return priorEvents[priorToIndex];
    }

    @Override
    public EventBean getRelativeToEnd(EventBean theEvent, int index) {
        return null;
    }

    @Override
    public int getWindowToEventCount(EventBean evalEvent) {
        return 0;
    }

    @Override
    public Iterator<EventBean> getWindowToEvent(Object evalEvent) {
        return null;
    }

    @Override
    public Collection<EventBean> getWindowToEventCollReadOnly(Object evalEvent) {
        return null;
    }

    @Override
    public void destroy() {
    }

    public Map<EventBean, EventBean[]> getPriorEventMap() {
        return this.priorEventMap;
    }

    public RollingEventBuffer getNewEvents() {
        return this.newEvents;
    }

    @Override
    public int getNumEventsInsertBuf() {
        return this.newEvents.getSize();
    }
}

