/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.internal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.RollingEventBuffer;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.view.internal.PriorEventBufferChangeCaptureSingle;
import com.espertech.esper.view.window.RelativeAccessByEventNIndex;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PriorEventBufferSingle
implements ViewUpdatedCollection,
RelativeAccessByEventNIndex {
    private final int priorEventIndex;
    private final Map<EventBean, EventBean> priorEventMap;
    private final RollingEventBuffer newEvents;
    private EventBean[] lastOldData;

    public PriorEventBufferSingle(int priorEventIndex) {
        this.priorEventIndex = priorEventIndex;
        this.newEvents = new RollingEventBuffer(priorEventIndex + 1);
        this.priorEventMap = new HashMap<EventBean, EventBean>();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        int i;
        if (this.lastOldData != null) {
            for (i = 0; i < this.lastOldData.length; ++i) {
                this.priorEventMap.remove(this.lastOldData[i]);
            }
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                EventBean newEvent = newData[i];
                this.newEvents.add(newEvent);
                EventBean priorEvent = this.newEvents.get(this.priorEventIndex);
                this.priorEventMap.put(newEvent, priorEvent);
            }
        }
        this.lastOldData = oldData;
    }

    public void update(EventBean[] newData, EventBean[] oldData, PriorEventBufferChangeCaptureSingle captureSingle) {
        int i;
        if (this.lastOldData != null) {
            for (i = 0; i < this.lastOldData.length; ++i) {
                EventBean oldDataItem = this.lastOldData[i];
                this.priorEventMap.remove(oldDataItem);
                captureSingle.removed(oldDataItem);
            }
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                EventBean newEvent = newData[i];
                this.newEvents.add(newEvent);
                EventBean priorEvent = this.newEvents.get(this.priorEventIndex);
                this.priorEventMap.put(newEvent, priorEvent);
                captureSingle.added(newEvent, priorEvent);
            }
        }
        this.lastOldData = oldData;
    }

    @Override
    public EventBean getRelativeToEvent(EventBean theEvent, int priorToIndex) {
        if (priorToIndex != 0) {
            throw new IllegalArgumentException("Single prior event buffer takes only a given index of zero");
        }
        EventBean priorEvent = this.priorEventMap.get(theEvent);
        if (priorEvent == null && !this.priorEventMap.containsKey(theEvent)) {
            return null;
        }
        return priorEvent;
    }

    @Override
    public EventBean getRelativeToEnd(EventBean theEvent, int index) {
        return null;
    }

    @Override
    public Iterator<EventBean> getWindowToEvent(Object evalEvent) {
        return null;
    }

    @Override
    public int getWindowToEventCount(EventBean evalEvent) {
        return 0;
    }

    @Override
    public Collection<EventBean> getWindowToEventCollReadOnly(Object evalEvent) {
        return null;
    }

    public Map<EventBean, EventBean> getPriorEventMap() {
        return this.priorEventMap;
    }

    public RollingEventBuffer getNewEvents() {
        return this.newEvents;
    }

    @Override
    public void destroy() {
    }

    @Override
    public int getNumEventsInsertBuf() {
        return this.newEvents.getSize();
    }
}

