/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.internal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.OneEventCollection;
import com.espertech.esper.collection.RefCountedSet;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewDataVisitableContainer;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewDataVisitorContained;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.internal.IntersectView;
import com.espertech.esper.view.internal.LastPostObserver;
import com.espertech.esper.view.internal.LastPostObserverView;
import com.espertech.esper.view.internal.UnionViewFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnionView
extends ViewSupport
implements LastPostObserver,
CloneableView,
StoppableView,
DataWindowView,
ViewDataVisitableContainer {
    private static final Log log = LogFactory.getLog(UnionView.class);
    protected final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;
    private final UnionViewFactory unionViewFactory;
    private final EventType eventType;
    protected final View[] views;
    private final EventBean[][] oldEventsPerView;
    protected final RefCountedSet<EventBean> unionWindow;
    private final List<EventBean> removalEvents = new ArrayList<EventBean>();
    private boolean isHasRemovestreamData;
    private boolean isRetainObserverEvents;
    private boolean isDiscardObserverEvents;

    public UnionView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext, UnionViewFactory factory, EventType eventType, List<View> viewList) {
        int i;
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.unionViewFactory = factory;
        this.eventType = eventType;
        this.views = viewList.toArray(new View[viewList.size()]);
        this.unionWindow = new RefCountedSet();
        this.oldEventsPerView = new EventBean[viewList.size()][];
        for (i = 0; i < viewList.size(); ++i) {
            LastPostObserverView view = new LastPostObserverView(i);
            this.views[i].removeAllViews();
            this.views[i].addView(view);
            view.setObserver(this);
        }
        for (i = 0; i < this.views.length; ++i) {
            for (EventBean theEvent : this.views[i]) {
                this.unionWindow.add(theEvent);
            }
        }
    }

    @Override
    public View cloneView() {
        return this.unionViewFactory.makeView(this.agentInstanceViewFactoryContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        OneEventCollection oldDataColl = null;
        if (oldData != null) {
            this.isDiscardObserverEvents = true;
            try {
                for (View view : this.views) {
                    view.update(null, oldData);
                }
            }
            finally {
                this.isDiscardObserverEvents = false;
            }
            for (EventBean eventBean : oldData) {
                this.unionWindow.removeAll(eventBean);
            }
            oldDataColl = new OneEventCollection();
            oldDataColl.add(oldData);
        }
        if (newData != null) {
            for (EventBean eventBean : newData) {
                this.unionWindow.add(eventBean, this.views.length);
            }
            this.isHasRemovestreamData = false;
            this.isRetainObserverEvents = true;
            try {
                for (View view : this.views) {
                    view.update(newData, null);
                }
            }
            finally {
                this.isRetainObserverEvents = false;
            }
            if (this.isHasRemovestreamData) {
                List<EventBean> removedEvents = null;
                for (int i = 0; i < this.oldEventsPerView.length; ++i) {
                    if (this.oldEventsPerView[i] == null) continue;
                    EventBean[] viewOldData = this.oldEventsPerView[i];
                    this.oldEventsPerView[i] = null;
                    for (EventBean old : viewOldData) {
                        boolean isNoMoreRef = this.unionWindow.remove(old);
                        if (!isNoMoreRef) continue;
                        if (removedEvents == null) {
                            this.removalEvents.clear();
                            removedEvents = this.removalEvents;
                        }
                        removedEvents.add(old);
                    }
                }
                if (removedEvents != null) {
                    if (oldDataColl == null) {
                        oldDataColl = new OneEventCollection();
                    }
                    for (EventBean oldItem : removedEvents) {
                        oldDataColl.add(oldItem);
                    }
                }
            }
        }
        if (this.hasViews()) {
            EventBean[] oldEvents = oldDataColl != null ? oldDataColl.toArray() : null;
            this.updateChildren(newData, oldEvents);
        }
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.unionWindow.keyIterator();
    }

    @Override
    public void newData(int streamId, EventBean[] newEvents, EventBean[] oldEvents) {
        if (oldEvents == null || this.isDiscardObserverEvents) {
            return;
        }
        if (this.isRetainObserverEvents) {
            this.oldEventsPerView[streamId] = oldEvents;
            this.isHasRemovestreamData = true;
            return;
        }
        List<EventBean> removedEvents = null;
        for (EventBean old : oldEvents) {
            boolean isNoMoreRef = this.unionWindow.remove(old);
            if (!isNoMoreRef) continue;
            if (removedEvents == null) {
                this.removalEvents.clear();
                removedEvents = this.removalEvents;
            }
            removedEvents.add(old);
        }
        if (removedEvents != null) {
            EventBean[] removed = removedEvents.toArray(new EventBean[removedEvents.size()]);
            this.updateChildren(null, removed);
        }
    }

    @Override
    public void stopView() {
        for (View view : this.views) {
            if (!(view instanceof StoppableView)) continue;
            ((StoppableView)((Object)view)).stopView();
        }
    }

    @Override
    public void visitViewContainer(ViewDataVisitorContained viewDataVisitor) {
        IntersectView.visitViewContained(viewDataVisitor, this.unionViewFactory, this.views);
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.unionViewFactory;
    }
}

