/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stat;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DerivedValueView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFieldEnum;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.stat.StatViewAdditionalProps;
import com.espertech.esper.view.stat.WeightedAverageViewFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WeightedAverageView
extends ViewSupport
implements CloneableView,
DerivedValueView {
    private final WeightedAverageViewFactory viewFactory;
    private final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private final ExprEvaluator fieldNameXEvaluator;
    private final ExprEvaluator fieldNameWeightEvaluator;
    private EventBean[] eventsPerStream = new EventBean[1];
    protected double sumXtimesW = Double.NaN;
    protected double sumW = Double.NaN;
    protected double currentValue = Double.NaN;
    protected Object[] lastValuesEventNew;
    private EventBean lastNewEvent;

    public WeightedAverageView(WeightedAverageViewFactory viewFactory, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        this.viewFactory = viewFactory;
        this.fieldNameXEvaluator = viewFactory.fieldNameX.getExprEvaluator();
        this.fieldNameWeightEvaluator = viewFactory.fieldNameWeight.getExprEvaluator();
        this.agentInstanceContext = agentInstanceContext;
    }

    @Override
    public View cloneView() {
        return this.viewFactory.makeView(this.agentInstanceContext);
    }

    public final ExprNode getFieldNameX() {
        return this.viewFactory.fieldNameX;
    }

    public final ExprNode getFieldNameWeight() {
        return this.viewFactory.fieldNameWeight;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        double weight;
        double point;
        Number weightnum;
        Number pointnum;
        double oldValue = this.currentValue;
        EventBean oldDataMap = null;
        if (this.lastNewEvent == null && this.hasViews()) {
            HashMap<String, Object> oldDataValues = new HashMap<String, Object>();
            oldDataValues.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), oldValue);
            this.addProperties(oldDataValues);
            oldDataMap = this.agentInstanceContext.getStatementContext().getEventAdapterService().adapterForTypedMap(oldDataValues, this.viewFactory.eventType);
        }
        if (newData != null) {
            for (int i = 0; i < newData.length; ++i) {
                this.eventsPerStream[0] = newData[i];
                pointnum = (Number)this.fieldNameXEvaluator.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                weightnum = (Number)this.fieldNameWeightEvaluator.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                if (pointnum == null || weightnum == null) continue;
                point = pointnum.doubleValue();
                weight = weightnum.doubleValue();
                if (Double.valueOf(this.sumXtimesW).isNaN()) {
                    this.sumXtimesW = point * weight;
                    this.sumW = weight;
                    continue;
                }
                this.sumXtimesW += point * weight;
                this.sumW += weight;
            }
            if (this.viewFactory.additionalProps != null && newData.length != 0) {
                if (this.lastValuesEventNew == null) {
                    this.lastValuesEventNew = new Object[this.viewFactory.additionalProps.getAdditionalExpr().length];
                }
                for (int val = 0; val < this.viewFactory.additionalProps.getAdditionalExpr().length; ++val) {
                    this.lastValuesEventNew[val] = this.viewFactory.additionalProps.getAdditionalExpr()[val].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                }
            }
        }
        if (oldData != null) {
            for (int i = 0; i < oldData.length; ++i) {
                this.eventsPerStream[0] = oldData[i];
                pointnum = (Number)this.fieldNameXEvaluator.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                weightnum = (Number)this.fieldNameWeightEvaluator.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                if (pointnum == null || weightnum == null) continue;
                point = pointnum.doubleValue();
                weight = weightnum.doubleValue();
                this.sumXtimesW -= point * weight;
                this.sumW -= weight;
            }
        }
        this.currentValue = this.sumW != 0.0 ? this.sumXtimesW / this.sumW : Double.NaN;
        if (this.hasViews()) {
            HashMap<String, Object> newDataMap = new HashMap<String, Object>();
            newDataMap.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), this.currentValue);
            this.addProperties(newDataMap);
            EventBean newDataEvent = this.agentInstanceContext.getStatementContext().getEventAdapterService().adapterForTypedMap(newDataMap, this.viewFactory.eventType);
            EventBean[] newEvents = new EventBean[]{newDataEvent};
            EventBean[] oldEvents = this.lastNewEvent == null ? new EventBean[]{oldDataMap} : new EventBean[]{this.lastNewEvent};
            this.updateChildren(newEvents, oldEvents);
            this.lastNewEvent = newDataEvent;
        }
    }

    private void addProperties(Map<String, Object> newDataMap) {
        if (this.viewFactory.additionalProps == null) {
            return;
        }
        this.viewFactory.additionalProps.addProperties(newDataMap, this.lastValuesEventNew);
    }

    @Override
    public final EventType getEventType() {
        return this.viewFactory.eventType;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        HashMap<String, Object> newDataMap = new HashMap<String, Object>();
        newDataMap.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), this.currentValue);
        this.addProperties(newDataMap);
        return new SingleEventIterator(this.agentInstanceContext.getStatementContext().getEventAdapterService().adapterForTypedMap(newDataMap, this.viewFactory.eventType));
    }

    public final String toString() {
        return this.getClass().getName() + " fieldName=" + this.viewFactory.fieldNameX + " fieldNameWeight=" + this.viewFactory.fieldNameWeight;
    }

    public static EventType createEventType(StatementContext statementContext, StatViewAdditionalProps additionalProps, int streamNum) {
        HashMap<String, Object> schemaMap = new HashMap<String, Object>();
        schemaMap.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), Double.class);
        StatViewAdditionalProps.addCheckDupProperties(schemaMap, additionalProps, ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE);
        String outputEventTypeName = statementContext.getStatementId() + "_wavgview_" + streamNum;
        return statementContext.getEventAdapterService().createAnonymousMapType(outputEventTypeName, schemaMap);
    }

    public double getSumXtimesW() {
        return this.sumXtimesW;
    }

    public void setSumXtimesW(double sumXtimesW) {
        this.sumXtimesW = sumXtimesW;
    }

    public double getSumW() {
        return this.sumW;
    }

    public void setSumW(double sumW) {
        this.sumW = sumW;
    }

    public double getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(double currentValue) {
        this.currentValue = currentValue;
    }

    public Object[] getLastValuesEventNew() {
        return this.lastValuesEventNew;
    }

    public void setLastValuesEventNew(Object[] lastValuesEventNew) {
        this.lastValuesEventNew = lastValuesEventNew;
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.viewFactory;
    }
}

