/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ViewServiceHelper;
import com.espertech.esper.view.window.IStreamRandomAccess;
import com.espertech.esper.view.window.KeepAllView;
import com.espertech.esper.view.window.RandomAccessByIndexGetter;
import java.util.List;

public class KeepAllViewFactory
implements DataWindowViewFactory,
DataWindowViewWithPrevious {
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        List<Object> viewParameters = ViewFactorySupport.validateAndEvaluate(this.getViewName(), viewFactoryContext.getStatementContext(), expressionParameters);
        if (viewParameters.size() != 0) {
            String errorMessage = this.getViewName() + " view requires an empty parameter list";
            throw new ViewParameterException(errorMessage);
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    public Object makePreviousGetter() {
        return new RandomAccessByIndexGetter();
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        IStreamRandomAccess randomAccess = ViewServiceHelper.getOptPreviousExprRandomAccess(agentInstanceViewFactoryContext);
        return new KeepAllView(agentInstanceViewFactoryContext, this, randomAccess);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof KeepAllView)) {
            return false;
        }
        KeepAllView myView = (KeepAllView)view;
        return myView.isEmpty();
    }

    @Override
    public String getViewName() {
        return "Keep-All";
    }
}

