/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.DataWindowBatchingViewFactory;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewFactoryTimePeriodHelper;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ViewServiceHelper;
import com.espertech.esper.view.window.IStreamRelativeAccess;
import com.espertech.esper.view.window.RelativeAccessByEventNIndexMap;
import com.espertech.esper.view.window.TimeBatchViewFactoryParams;
import com.espertech.esper.view.window.TimeLengthBatchView;
import java.util.List;

public class TimeLengthBatchViewFactory
extends TimeBatchViewFactoryParams
implements DataWindowViewFactory,
DataWindowViewWithPrevious,
DataWindowBatchingViewFactory {
    protected long numberOfEvents;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        Object[] viewParameters = new Object[expressionParameters.size()];
        for (int i = 1; i < expressionParameters.size(); ++i) {
            viewParameters[i] = ViewFactorySupport.validateAndEvaluate(this.getViewName(), viewFactoryContext.getStatementContext(), expressionParameters.get(i));
        }
        String errorMessage = this.getViewName() + " view requires a numeric or time period parameter as a time interval size, and an integer parameter as a maximal number-of-events, and an optional list of control keywords as a string parameter (please see the documentation)";
        if (viewParameters.length != 2 && viewParameters.length != 3) {
            throw new ViewParameterException(errorMessage);
        }
        this.timeDeltaComputation = ViewFactoryTimePeriodHelper.validateAndEvaluateTimeDelta(this.getViewName(), viewFactoryContext.getStatementContext(), expressionParameters.get(0), errorMessage, 0);
        Object parameter = viewParameters[1];
        if (!(parameter instanceof Number) || JavaClassHelper.isFloatingPointNumber((Number)parameter)) {
            throw new ViewParameterException(errorMessage);
        }
        this.numberOfEvents = ((Number)parameter).longValue();
        if (viewParameters.length > 2) {
            this.processKeywords(viewParameters[2], errorMessage);
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    public Object makePreviousGetter() {
        return new RelativeAccessByEventNIndexMap();
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        IStreamRelativeAccess relativeAccessByEvent = ViewServiceHelper.getOptPreviousExprRelativeAccess(agentInstanceViewFactoryContext);
        return new TimeLengthBatchView(this, agentInstanceViewFactoryContext, this.timeDeltaComputation, this.numberOfEvents, this.isForceUpdate, this.isStartEager, relativeAccessByEvent);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof TimeLengthBatchView)) {
            return false;
        }
        TimeLengthBatchView myView = (TimeLengthBatchView)view;
        if (!this.timeDeltaComputation.equalsTimePeriod(myView.getTimeDeltaComputation())) {
            return false;
        }
        if (myView.getNumberOfEvents() != this.numberOfEvents) {
            return false;
        }
        if (myView.isForceOutput() != this.isForceUpdate) {
            return false;
        }
        if (myView.isStartEager()) {
            return false;
        }
        return myView.isEmpty();
    }

    @Override
    public String getViewName() {
        return "Time-Length-Batch";
    }
}

