/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.CreateSchemaClause;
import com.espertech.esper.client.soda.DataFlowOperator;
import com.espertech.esper.client.soda.EPStatementFormatter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;

public class CreateDataFlowClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String dataFlowName;
    private List<CreateSchemaClause> schemas;
    private List<DataFlowOperator> operators;

    public CreateDataFlowClause() {
    }

    public CreateDataFlowClause(String dataFlowName, List<CreateSchemaClause> schemas, List<DataFlowOperator> operators) {
        this.dataFlowName = dataFlowName;
        this.schemas = schemas;
        this.operators = operators;
    }

    public String getDataFlowName() {
        return this.dataFlowName;
    }

    public void setDataFlowName(String dataFlowName) {
        this.dataFlowName = dataFlowName;
    }

    public List<CreateSchemaClause> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<CreateSchemaClause> schemas) {
        this.schemas = schemas;
    }

    public List<DataFlowOperator> getOperators() {
        return this.operators;
    }

    public void setOperators(List<DataFlowOperator> operators) {
        this.operators = operators;
    }

    public void toEPL(StringWriter writer, EPStatementFormatter formatter) {
        writer.append("create dataflow ");
        writer.append(this.dataFlowName);
        if (this.schemas != null) {
            for (CreateSchemaClause createSchemaClause : this.schemas) {
                formatter.beginDataFlowSchema(writer);
                createSchemaClause.toEPL(writer);
                writer.append(",");
            }
        }
        if (this.operators != null) {
            formatter.beginDataFlowOperator(writer);
            for (DataFlowOperator dataFlowOperator : this.operators) {
                dataFlowOperator.toEPL(writer, formatter);
            }
        }
    }
}

