/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.ConstantExpression;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionBase;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.client.soda.PreviousExpressionType;
import com.espertech.esper.client.soda.PropertyValueExpression;
import java.io.StringWriter;

public class PreviousExpression
extends ExpressionBase {
    private static final long serialVersionUID = -4347875900366616364L;
    private PreviousExpressionType type = PreviousExpressionType.PREV;

    public PreviousExpression() {
    }

    public PreviousExpression(Expression expression, String propertyName) {
        this.addChild(expression);
        this.addChild(new PropertyValueExpression(propertyName));
    }

    public PreviousExpression(int index, String propertyName) {
        this.addChild(new ConstantExpression(index));
        this.addChild(new PropertyValueExpression(propertyName));
    }

    public PreviousExpression(PreviousExpressionType type, Expression expression) {
        this.type = type;
        this.addChild(expression);
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    public PreviousExpressionType getType() {
        return this.type;
    }

    public void setType(PreviousExpressionType type) {
        this.type = type;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.write(this.type.toString().toLowerCase());
        writer.write("(");
        this.getChildren().get(0).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        if (this.getChildren().size() > 1) {
            writer.write(",");
            this.getChildren().get(1).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
        writer.write(41);
    }
}

