/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.collection;

import java.util.Arrays;

public final class MultiKey<T> {
    private final T[] keys;
    private final int hashCode;

    public MultiKey(T[] keys) {
        if (keys == null) {
            throw new IllegalArgumentException("The array of keys must not be null");
        }
        int total = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            total *= 31;
            total ^= keys[i].hashCode();
        }
        this.hashCode = total;
        this.keys = keys;
    }

    public final int size() {
        return this.keys.length;
    }

    public final T get(int index) {
        return this.keys[index];
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MultiKey) {
            MultiKey otherKeys = (MultiKey)other;
            return Arrays.equals(this.keys, otherKeys.keys);
        }
        return false;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        return "MultiKey" + Arrays.asList(this.keys).toString();
    }

    public final T[] getArray() {
        return this.keys;
    }
}

