/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.collection;

import com.espertech.esper.collection.PermutationEnumeration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NumberSetShiftGroupEnumeration
implements Enumeration<int[]> {
    private final int[] numberSet;
    private boolean isShiftComplete;
    private int shiftCount;
    private PermutationEnumeration permutationEnumeration;
    private Map<Integer, List<Integer>> buckets;

    public NumberSetShiftGroupEnumeration(int[] numberSet) {
        if (numberSet.length < 6) {
            throw new IllegalArgumentException("Only supported for at least 6-number sets");
        }
        this.numberSet = numberSet;
    }

    @Override
    public boolean hasMoreElements() {
        if (!this.isShiftComplete) {
            return true;
        }
        this.initPermutation();
        return this.permutationEnumeration.hasMoreElements();
    }

    @Override
    public int[] nextElement() {
        if (!this.isShiftComplete) {
            int[] result = new int[this.numberSet.length];
            int count = this.shiftCount++;
            for (int i = 0; i < this.numberSet.length; ++i) {
                int index = count + i;
                if (index >= this.numberSet.length) {
                    index -= this.numberSet.length;
                }
                result[i] = this.numberSet[index];
            }
            if (this.shiftCount == this.numberSet.length) {
                this.isShiftComplete = true;
            }
            return result;
        }
        this.initPermutation();
        return this.translate(this.permutationEnumeration.nextElement());
    }

    private void initPermutation() {
        if (this.permutationEnumeration != null) {
            return;
        }
        this.buckets = new HashMap<Integer, List<Integer>>();
        for (int i = 0; i < this.numberSet.length; ++i) {
            int bucketNum = i % 4;
            List<Integer> bucket = this.buckets.get(bucketNum);
            if (bucket == null) {
                bucket = new ArrayList<Integer>();
                this.buckets.put(bucketNum, bucket);
            }
            bucket.add(this.numberSet[i]);
        }
        this.permutationEnumeration = new PermutationEnumeration(4);
        this.permutationEnumeration.nextElement();
    }

    private int[] translate(int[] bucketsPermuted) {
        int[] result = new int[this.numberSet.length];
        int count = 0;
        for (int i = 0; i < bucketsPermuted.length; ++i) {
            List<Integer> bucket = this.buckets.get(bucketsPermuted[i]);
            for (int j : bucket) {
                result[count++] = j;
            }
        }
        return result;
    }
}

