/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.factory;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryBase;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryResult;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryUpdateResult;
import com.espertech.esper.core.context.subselect.SubSelectStrategyCollection;
import com.espertech.esper.core.context.subselect.SubSelectStrategyHolder;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.InternalEventRouterDesc;
import com.espertech.esper.core.service.InternalRoutePreprocessView;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementStartMethodHelperSubselect;
import com.espertech.esper.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.epl.spec.UpdateDesc;
import com.espertech.esper.util.StopCallback;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatementAgentInstanceFactoryUpdate
extends StatementAgentInstanceFactoryBase {
    private static final Log log = LogFactory.getLog(StatementAgentInstanceFactoryUpdate.class);
    private final StatementContext statementContext;
    private final EPServicesContext services;
    private final EventType streamEventType;
    private final UpdateDesc desc;
    private final InternalRoutePreprocessView onExprView;
    private final InternalEventRouterDesc routerDesc;
    private final SubSelectStrategyCollection subSelectStrategyCollection;

    public StatementAgentInstanceFactoryUpdate(StatementContext statementContext, EPServicesContext services, EventType streamEventType, UpdateDesc desc, InternalRoutePreprocessView onExprView, InternalEventRouterDesc routerDesc, SubSelectStrategyCollection subSelectStrategyCollection) {
        super(statementContext.getAnnotations());
        this.statementContext = statementContext;
        this.services = services;
        this.streamEventType = streamEventType;
        this.desc = desc;
        this.onExprView = onExprView;
        this.subSelectStrategyCollection = subSelectStrategyCollection;
        this.routerDesc = routerDesc;
    }

    @Override
    public StatementAgentInstanceFactoryUpdateResult newContextInternal(AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        Map<ExprSubselectNode, SubSelectStrategyHolder> subselectStrategies;
        ArrayList<StopCallback> stopCallbacks = new ArrayList<StopCallback>();
        try {
            stopCallbacks.add(new StopCallback(){

                @Override
                public void stop() {
                    StatementAgentInstanceFactoryUpdate.this.services.getInternalEventRouter().removePreprocessing(StatementAgentInstanceFactoryUpdate.this.streamEventType, StatementAgentInstanceFactoryUpdate.this.desc);
                }
            });
            this.services.getInternalEventRouter().addPreprocessing(this.routerDesc, this.onExprView, agentInstanceContext.getAgentInstanceLock(), !this.subSelectStrategyCollection.getSubqueries().isEmpty());
            subselectStrategies = EPStatementStartMethodHelperSubselect.startSubselects(this.services, this.subSelectStrategyCollection, agentInstanceContext, stopCallbacks, isRecoveringResilient);
        }
        catch (RuntimeException ex) {
            StopCallback stopCallback = StatementAgentInstanceUtil.getStopCallback(stopCallbacks, agentInstanceContext);
            StatementAgentInstanceUtil.stopSafe(stopCallback, this.statementContext);
            throw ex;
        }
        StatementAgentInstanceFactoryUpdateResult result = new StatementAgentInstanceFactoryUpdateResult(this.onExprView, null, agentInstanceContext, subselectStrategies);
        if (this.statementContext.getStatementExtensionServicesContext() != null) {
            this.statementContext.getStatementExtensionServicesContext().contributeStopCallback(result, stopCallbacks);
        }
        StopCallback stopCallback = StatementAgentInstanceUtil.getStopCallback(stopCallbacks, agentInstanceContext);
        result.setStopCallback(stopCallback);
        return result;
    }

    @Override
    public void assignExpressions(StatementAgentInstanceFactoryResult result) {
    }

    @Override
    public void unassignExpressions() {
    }
}

