/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventType;
import com.espertech.esper.client.context.ContextPartitionIdentifier;
import com.espertech.esper.client.context.ContextPartitionIdentifierCategory;
import com.espertech.esper.core.context.mgr.ContextControllerAddendumUtil;
import com.espertech.esper.core.context.mgr.ContextControllerFactory;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryBase;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryContext;
import com.espertech.esper.core.context.mgr.ContextControllerStatementBase;
import com.espertech.esper.core.context.mgr.ContextControllerStatementCtxCache;
import com.espertech.esper.core.context.mgr.ContextControllerStatementCtxCacheFilters;
import com.espertech.esper.core.context.mgr.ContextControllerStatementDesc;
import com.espertech.esper.core.context.mgr.ContextInternalFilterAddendum;
import com.espertech.esper.core.context.mgr.ContextPropertyEventType;
import com.espertech.esper.core.context.stmt.AIRegistryAggregationMultiPerm;
import com.espertech.esper.core.context.stmt.AIRegistryExprMultiPerm;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistry;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistryFactory;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.ContextDetail;
import com.espertech.esper.epl.spec.ContextDetailCategory;
import com.espertech.esper.epl.spec.ContextDetailCategoryItem;
import com.espertech.esper.epl.spec.ContextDetailPartitionItem;
import com.espertech.esper.epl.spec.util.StatementSpecCompiledAnalyzer;
import com.espertech.esper.epl.spec.util.StatementSpecCompiledAnalyzerResult;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.FilterValueSetParam;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public abstract class ContextControllerCategoryFactoryBase
extends ContextControllerFactoryBase
implements ContextControllerFactory {
    private final ContextDetailCategory categorySpec;
    private final List<FilterSpecCompiled> filtersSpecsNestedContexts;
    private Map<String, Object> contextBuiltinProps;

    public ContextControllerCategoryFactoryBase(ContextControllerFactoryContext factoryContext, ContextDetailCategory categorySpec, List<FilterSpecCompiled> filtersSpecsNestedContexts) {
        super(factoryContext);
        this.categorySpec = categorySpec;
        this.filtersSpecsNestedContexts = filtersSpecsNestedContexts;
    }

    public boolean hasFiltersSpecsNestedContexts() {
        return this.filtersSpecsNestedContexts != null && !this.filtersSpecsNestedContexts.isEmpty();
    }

    @Override
    public void validateFactory() throws ExprValidationException {
        if (this.categorySpec.getItems().isEmpty()) {
            throw new ExprValidationException("Empty list of partition items");
        }
        this.contextBuiltinProps = ContextPropertyEventType.getCategorizedType();
    }

    @Override
    public ContextControllerStatementCtxCache validateStatement(ContextControllerStatementBase statement) throws ExprValidationException {
        StatementSpecCompiledAnalyzerResult streamAnalysis = StatementSpecCompiledAnalyzer.analyzeFilters(statement.getStatementSpec());
        this.validateStatementForContext(statement, streamAnalysis);
        return new ContextControllerStatementCtxCacheFilters(streamAnalysis.getFilters());
    }

    @Override
    public void populateFilterAddendums(IdentityHashMap<FilterSpecCompiled, FilterValueSetParam[][]> filterAddendum, ContextControllerStatementDesc statement, Object categoryIndex, int contextId) {
        ContextControllerStatementCtxCacheFilters statementInfo = (ContextControllerStatementCtxCacheFilters)statement.getCaches()[this.factoryContext.getNestingLevel() - 1];
        ContextDetailCategoryItem category = this.categorySpec.getItems().get((Integer)categoryIndex);
        ContextControllerCategoryFactoryBase.getAddendumFilters(filterAddendum, category, this.categorySpec, statementInfo.getFilterSpecs(), statement);
    }

    public void populateContextInternalFilterAddendums(ContextInternalFilterAddendum filterAddendum, Object categoryIndex) {
        ContextDetailCategoryItem category = this.categorySpec.getItems().get((Integer)categoryIndex);
        ContextControllerCategoryFactoryBase.getAddendumFilters(filterAddendum.getFilterAddendum(), category, this.categorySpec, this.filtersSpecsNestedContexts, null);
    }

    @Override
    public FilterSpecLookupable getFilterLookupable(EventType eventType) {
        return null;
    }

    @Override
    public boolean isSingleInstanceContext() {
        return false;
    }

    @Override
    public StatementAIResourceRegistryFactory getStatementAIResourceRegistryFactory() {
        return new StatementAIResourceRegistryFactory(){

            @Override
            public StatementAIResourceRegistry make() {
                return new StatementAIResourceRegistry(new AIRegistryAggregationMultiPerm(), new AIRegistryExprMultiPerm());
            }
        };
    }

    @Override
    public List<ContextDetailPartitionItem> getContextDetailPartitionItems() {
        return Collections.emptyList();
    }

    @Override
    public ContextDetail getContextDetail() {
        return this.categorySpec;
    }

    public ContextDetailCategory getCategorySpec() {
        return this.categorySpec;
    }

    @Override
    public Map<String, Object> getContextBuiltinProps() {
        return this.contextBuiltinProps;
    }

    @Override
    public ContextPartitionIdentifier keyPayloadToIdentifier(Object payload) {
        int index = (Integer)payload;
        return new ContextPartitionIdentifierCategory(this.categorySpec.getItems().get(index).getName());
    }

    private void validateStatementForContext(ContextControllerStatementBase statement, StatementSpecCompiledAnalyzerResult streamAnalysis) throws ExprValidationException {
        List<FilterSpecCompiled> filters = streamAnalysis.getFilters();
        boolean isCreateWindow = statement.getStatementSpec().getCreateWindowDesc() != null;
        String message = "Category context '" + this.factoryContext.getContextName() + "' requires that any of the events types that are listed in the category context also appear in any of the filter expressions of the statement";
        if (!isCreateWindow) {
            for (FilterSpecCompiled filter : filters) {
                EventType contextType;
                EventType stmtFilterType = filter.getFilterForEventType();
                if (stmtFilterType == (contextType = this.categorySpec.getFilterSpecCompiled().getFilterForEventType())) {
                    return;
                }
                if (!EventTypeUtility.isTypeOrSubTypeOf(stmtFilterType, contextType)) continue;
                return;
            }
            if (!filters.isEmpty()) {
                throw new ExprValidationException(message);
            }
            return;
        }
        String declaredAsName = statement.getStatementSpec().getCreateWindowDesc().getAsEventTypeName();
        if (declaredAsName != null) {
            if (this.categorySpec.getFilterSpecCompiled().getFilterForEventType().getName().equals(declaredAsName)) {
                return;
            }
            throw new ExprValidationException(message);
        }
    }

    private static void getAddendumFilters(IdentityHashMap<FilterSpecCompiled, FilterValueSetParam[][]> addendums, ContextDetailCategoryItem category, ContextDetailCategory categorySpec, List<FilterSpecCompiled> filters, ContextControllerStatementDesc statement) {
        block3: {
            block2: {
                boolean isCreateWindow;
                boolean bl = isCreateWindow = statement != null && statement.getStatement().getStatementSpec().getCreateWindowDesc() != null;
                if (isCreateWindow) break block2;
                for (FilterSpecCompiled filtersSpec : filters) {
                    boolean typeOrSubtype = EventTypeUtility.isTypeOrSubTypeOf(filtersSpec.getFilterForEventType(), categorySpec.getFilterSpecCompiled().getFilterForEventType());
                    if (!typeOrSubtype) continue;
                    ContextControllerCategoryFactoryBase.addAddendums(addendums, filtersSpec, category, categorySpec);
                }
                break block3;
            }
            String declaredAsName = statement.getStatement().getStatementSpec().getCreateWindowDesc().getAsEventTypeName();
            if (declaredAsName == null) break block3;
            for (FilterSpecCompiled filtersSpec : filters) {
                ContextControllerCategoryFactoryBase.addAddendums(addendums, filtersSpec, category, categorySpec);
            }
        }
    }

    private static void addAddendums(IdentityHashMap<FilterSpecCompiled, FilterValueSetParam[][]> addendums, FilterSpecCompiled filtersSpec, ContextDetailCategoryItem category, ContextDetailCategory categorySpec) {
        FilterValueSetParam[][] categoryEventFilters = categorySpec.getFilterParamsCompiled();
        FilterValueSetParam[][] categoryItemFilters = category.getCompiledFilterParam();
        FilterValueSetParam[][] addendum = ContextControllerAddendumUtil.multiplyAddendum(categoryEventFilters, categoryItemFilters);
        FilterValueSetParam[][] existingFilters = addendums.get(filtersSpec);
        if (existingFilters != null) {
            addendum = ContextControllerAddendumUtil.multiplyAddendum(existingFilters, addendum);
        }
        addendums.put(filtersSpec, addendum);
    }
}

