/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.core.context.mgr.ContextControllerCondition;
import com.espertech.esper.core.context.mgr.ContextControllerConditionCallback;
import com.espertech.esper.core.context.mgr.ContextControllerConditionCrontab;
import com.espertech.esper.core.context.mgr.ContextControllerConditionFilter;
import com.espertech.esper.core.context.mgr.ContextControllerConditionImmediate;
import com.espertech.esper.core.context.mgr.ContextControllerConditionPattern;
import com.espertech.esper.core.context.mgr.ContextControllerConditionTimePeriod;
import com.espertech.esper.core.context.mgr.ContextInternalFilterAddendum;
import com.espertech.esper.core.context.mgr.ContextStatePathKey;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.epl.spec.ContextDetailCondition;
import com.espertech.esper.epl.spec.ContextDetailConditionCrontab;
import com.espertech.esper.epl.spec.ContextDetailConditionFilter;
import com.espertech.esper.epl.spec.ContextDetailConditionImmediate;
import com.espertech.esper.epl.spec.ContextDetailConditionPattern;
import com.espertech.esper.epl.spec.ContextDetailConditionTimePeriod;

public class ContextControllerConditionFactory {
    public static ContextControllerCondition getEndpoint(String contextName, EPServicesContext servicesContext, AgentInstanceContext agentInstanceContext, ContextDetailCondition endpoint, ContextControllerConditionCallback callback, ContextInternalFilterAddendum filterAddendum, boolean isStartEndpoint, int nestingLevel, int pathId, int subpathId) {
        if (endpoint instanceof ContextDetailConditionCrontab) {
            ContextDetailConditionCrontab crontab = (ContextDetailConditionCrontab)endpoint;
            long scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
            return new ContextControllerConditionCrontab(agentInstanceContext.getStatementContext(), scheduleSlot, crontab, callback, filterAddendum);
        }
        if (endpoint instanceof ContextDetailConditionFilter) {
            ContextDetailConditionFilter filter = (ContextDetailConditionFilter)endpoint;
            return new ContextControllerConditionFilter(servicesContext, agentInstanceContext, filter, callback, filterAddendum);
        }
        if (endpoint instanceof ContextDetailConditionPattern) {
            ContextStatePathKey key = new ContextStatePathKey(nestingLevel, pathId, subpathId);
            ContextDetailConditionPattern pattern = (ContextDetailConditionPattern)endpoint;
            return new ContextControllerConditionPattern(servicesContext, agentInstanceContext, pattern, callback, filterAddendum, isStartEndpoint, key);
        }
        if (endpoint instanceof ContextDetailConditionTimePeriod) {
            ContextDetailConditionTimePeriod timePeriod = (ContextDetailConditionTimePeriod)endpoint;
            long scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
            return new ContextControllerConditionTimePeriod(contextName, agentInstanceContext, scheduleSlot, timePeriod, callback, filterAddendum);
        }
        if (endpoint instanceof ContextDetailConditionImmediate) {
            return new ContextControllerConditionImmediate();
        }
        throw new IllegalStateException("Unrecognized context range endpoint " + endpoint.getClass());
    }
}

