/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EPOnDemandPreparedQuery;
import com.espertech.esper.client.EPOnDemandPreparedQueryParameterized;
import com.espertech.esper.client.EPOnDemandQueryResult;
import com.espertech.esper.client.EPStatementException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventSender;
import com.espertech.esper.client.EventTypeException;
import com.espertech.esper.client.UnmatchedListener;
import com.espertech.esper.client.VariableConstantValueException;
import com.espertech.esper.client.VariableNotFoundException;
import com.espertech.esper.client.VariableValueException;
import com.espertech.esper.client.context.ContextPartitionDescriptor;
import com.espertech.esper.client.context.ContextPartitionSelector;
import com.espertech.esper.client.context.ContextPartitionVariableState;
import com.espertech.esper.client.dataflow.EPDataFlowRuntime;
import com.espertech.esper.client.hook.ExceptionHandlerExceptionType;
import com.espertech.esper.client.soda.EPStatementObjectModel;
import com.espertech.esper.client.time.CurrentTimeEvent;
import com.espertech.esper.client.time.CurrentTimeSpanEvent;
import com.espertech.esper.client.time.TimerControlEvent;
import com.espertech.esper.client.time.TimerEvent;
import com.espertech.esper.client.util.EventRenderer;
import com.espertech.esper.collection.ArrayBackedCollection;
import com.espertech.esper.collection.DualWorkQueue;
import com.espertech.esper.collection.ThreadWorkQueue;
import com.espertech.esper.core.context.mgr.ContextManager;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandleComparator;
import com.espertech.esper.core.service.EPAdministratorHelper;
import com.espertech.esper.core.service.EPPreparedQueryImpl;
import com.espertech.esper.core.service.EPPreparedQueryResult;
import com.espertech.esper.core.service.EPPreparedStatementImpl;
import com.espertech.esper.core.service.EPQueryResultImpl;
import com.espertech.esper.core.service.EPRuntimeEventSender;
import com.espertech.esper.core.service.EPRuntimeSPI;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPStatementHandle;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExpressionResultCacheService;
import com.espertech.esper.core.service.InsertIntoLatchSpin;
import com.espertech.esper.core.service.InsertIntoLatchWait;
import com.espertech.esper.core.service.InternalEventRouteDest;
import com.espertech.esper.core.service.InternalEventRouter;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StatementLifecycleSvc;
import com.espertech.esper.core.service.StatementLifecycleSvcImpl;
import com.espertech.esper.core.service.StatementLifecycleSvcUtil;
import com.espertech.esper.core.service.StatementType;
import com.espertech.esper.core.start.EPPreparedExecuteIUDInsertInto;
import com.espertech.esper.core.start.EPPreparedExecuteIUDSingleStreamDelete;
import com.espertech.esper.core.start.EPPreparedExecuteIUDSingleStreamUpdate;
import com.espertech.esper.core.start.EPPreparedExecuteMethod;
import com.espertech.esper.core.start.EPPreparedExecuteMethodQuery;
import com.espertech.esper.core.thread.InboundUnitSendDOM;
import com.espertech.esper.core.thread.InboundUnitSendEvent;
import com.espertech.esper.core.thread.InboundUnitSendMap;
import com.espertech.esper.core.thread.InboundUnitSendObjectArray;
import com.espertech.esper.core.thread.RouteUnitMultiple;
import com.espertech.esper.core.thread.RouteUnitSingle;
import com.espertech.esper.core.thread.ThreadingOption;
import com.espertech.esper.core.thread.TimerUnitMultiple;
import com.espertech.esper.core.thread.TimerUnitSingle;
import com.espertech.esper.epl.annotation.AnnotationUtil;
import com.espertech.esper.epl.declexpr.ExprDeclaredNode;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.epl.metric.MetricReportingPath;
import com.espertech.esper.epl.script.AgentInstanceScriptContext;
import com.espertech.esper.epl.spec.FireAndForgetSpecDelete;
import com.espertech.esper.epl.spec.FireAndForgetSpecUpdate;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StatementSpecMapper;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.spec.StatementSpecUnMapResult;
import com.espertech.esper.epl.spec.util.StatementSpecRawAnalyzer;
import com.espertech.esper.epl.table.mgmt.TableExprEvaluatorContext;
import com.espertech.esper.epl.variable.VariableMetaData;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.event.util.EventRendererImpl;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterHandleCallback;
import com.espertech.esper.metrics.jmx.JmxGetter;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleVisit;
import com.espertech.esper.schedule.ScheduleVisitor;
import com.espertech.esper.schedule.SchedulingServiceSPI;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.timer.TimerCallback;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.util.MetricUtil;
import com.espertech.esper.util.UuidGenerator;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class EPRuntimeImpl
implements EPRuntimeSPI,
EPRuntimeEventSender,
TimerCallback,
InternalEventRouteDest {
    protected EPServicesContext services;
    protected boolean isLatchStatementInsertStream;
    protected boolean isUsingExternalClocking;
    protected boolean isPrioritized;
    protected volatile UnmatchedListener unmatchedListener;
    protected AtomicLong routedInternal;
    protected AtomicLong routedExternal;
    protected EventRenderer eventRenderer;
    protected InternalEventRouter internalEventRouter;
    protected ExprEvaluatorContext engineFilterAndDispatchTimeContext;
    protected ThreadWorkQueue threadWorkQueue;
    protected ThreadLocal<ArrayBackedCollection<FilterHandle>> matchesArrayThreadLocal;
    protected ThreadLocal<ArrayBackedCollection<ScheduleHandle>> scheduleArrayThreadLocal;
    protected ThreadLocal<Map<EPStatementAgentInstanceHandle, Object>> matchesPerStmtThreadLocal;
    protected ThreadLocal<Map<EPStatementAgentInstanceHandle, Object>> schedulePerStmtThreadLocal;
    protected static final Log log = LogFactory.getLog(EPRuntimeImpl.class);

    public EPRuntimeImpl(final EPServicesContext services) {
        this.services = services;
        this.threadWorkQueue = new ThreadWorkQueue();
        this.isLatchStatementInsertStream = this.services.getEngineSettingsService().getEngineSettings().getThreading().isInsertIntoDispatchPreserveOrder();
        this.isUsingExternalClocking = !this.services.getEngineSettingsService().getEngineSettings().getThreading().isInternalTimerEnabled();
        this.isPrioritized = services.getEngineSettingsService().getEngineSettings().getExecution().isPrioritized();
        this.routedInternal = new AtomicLong();
        this.routedExternal = new AtomicLong();
        this.engineFilterAndDispatchTimeContext = new ExprEvaluatorContext(){
            private ExpressionResultCacheService expressionResultCacheService;
            {
                this.expressionResultCacheService = services.getExpressionResultCacheSharable();
            }

            @Override
            public TimeProvider getTimeProvider() {
                return services.getSchedulingService();
            }

            @Override
            public ExpressionResultCacheService getExpressionResultCacheService() {
                return this.expressionResultCacheService;
            }

            @Override
            public int getAgentInstanceId() {
                return -1;
            }

            @Override
            public EventBean getContextProperties() {
                return null;
            }

            @Override
            public AgentInstanceScriptContext getAgentInstanceScriptContext() {
                return null;
            }

            @Override
            public String getStatementName() {
                return null;
            }

            @Override
            public String getEngineURI() {
                return null;
            }

            @Override
            public int getStatementId() {
                return -1;
            }

            @Override
            public StatementAgentInstanceLock getAgentInstanceLock() {
                return null;
            }

            @Override
            public StatementType getStatementType() {
                return null;
            }

            @Override
            public TableExprEvaluatorContext getTableExprEvaluatorContext() {
                throw new UnsupportedOperationException("Table-access evaluation is not supported in this expression");
            }

            @Override
            public Object getStatementUserObject() {
                return null;
            }
        };
        this.initThreadLocals();
        services.getThreadingService().initThreading(services, this);
    }

    @Override
    public void setInternalEventRouter(InternalEventRouter internalEventRouter) {
        this.internalEventRouter = internalEventRouter;
    }

    @Override
    @JmxGetter(name="NumInsertIntoEvents", description="Number of inserted-into events")
    public long getRoutedInternal() {
        return this.routedInternal.get();
    }

    @Override
    @JmxGetter(name="NumRoutedEvents", description="Number of routed events")
    public long getRoutedExternal() {
        return this.routedExternal.get();
    }

    @Override
    public void timerCallback() {
        long msec = this.services.getTimeSource().getTimeMillis();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && ExecutionPathDebugLog.isTimerDebugEnabled) {
            log.debug((Object)(".timerCallback Evaluating scheduled callbacks, time is " + msec));
        }
        CurrentTimeEvent currentTimeEvent = new CurrentTimeEvent(msec);
        this.sendEvent(currentTimeEvent);
    }

    @Override
    public void sendEvent(Object theEvent) throws EPException {
        if (theEvent == null) {
            log.fatal((Object)".sendEvent Null object supplied");
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && (!(theEvent instanceof CurrentTimeEvent) || ExecutionPathDebugLog.isTimerDebugEnabled)) {
            log.debug((Object)(".sendEvent Processing event " + theEvent));
        }
        if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isInboundThreading()) {
            this.services.getThreadingService().submitInbound(new InboundUnitSendEvent(theEvent, this));
        } else {
            this.processEvent(theEvent);
        }
    }

    @Override
    public void sendEvent(Node document) throws EPException {
        if (document == null) {
            log.fatal((Object)".sendEvent Null object supplied");
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".sendEvent Processing DOM node event " + document));
        }
        if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isInboundThreading()) {
            this.services.getThreadingService().submitInbound(new InboundUnitSendDOM(document, this.services, this));
        } else {
            EventBean eventBean = this.wrapEvent(document);
            this.processEvent(eventBean);
        }
    }

    @Override
    public EventBean wrapEvent(Node node) {
        return this.services.getEventAdapterService().adapterForDOM(node);
    }

    @Override
    public void route(Node document) throws EPException {
        if (document == null) {
            log.fatal((Object)".sendEvent Null object supplied");
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".sendEvent Processing DOM node event " + document));
        }
        EventBean eventBean = this.services.getEventAdapterService().adapterForDOM(document);
        this.threadWorkQueue.addBack(eventBean);
    }

    @Override
    public void sendEvent(Map map, String mapEventTypeName) throws EPException {
        if (map == null) {
            throw new IllegalArgumentException("Invalid null event object");
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".sendMap Processing event " + map));
        }
        if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isInboundThreading()) {
            this.services.getThreadingService().submitInbound(new InboundUnitSendMap(map, mapEventTypeName, this.services, this));
        } else {
            EventBean eventBean = this.wrapEvent(map, mapEventTypeName);
            this.processWrappedEvent(eventBean);
        }
    }

    @Override
    public void sendEvent(Object[] propertyValues, String objectArrayEventTypeName) throws EPException {
        if (propertyValues == null) {
            throw new IllegalArgumentException("Invalid null event object");
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".sendMap Processing event " + Arrays.toString(propertyValues)));
        }
        if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isInboundThreading()) {
            this.services.getThreadingService().submitInbound(new InboundUnitSendObjectArray(propertyValues, objectArrayEventTypeName, this.services, this));
        } else {
            EventBean eventBean = this.wrapEvent(propertyValues, objectArrayEventTypeName);
            this.processWrappedEvent(eventBean);
        }
    }

    @Override
    public EventBean wrapEvent(Map map, String eventTypeName) {
        return this.services.getEventAdapterService().adapterForMap(map, eventTypeName);
    }

    public EventBean wrapEvent(Object[] objectArray, String eventTypeName) {
        return this.services.getEventAdapterService().adapterForObjectArray(objectArray, eventTypeName);
    }

    @Override
    public void route(Map map, String eventTypeName) throws EPException {
        if (map == null) {
            throw new IllegalArgumentException("Invalid null event object");
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".route Processing event " + map));
        }
        EventBean theEvent = this.services.getEventAdapterService().adapterForMap(map, eventTypeName);
        if (this.internalEventRouter.isHasPreprocessing() && (theEvent = this.internalEventRouter.preprocess(theEvent, this.engineFilterAndDispatchTimeContext)) == null) {
            return;
        }
        this.threadWorkQueue.addBack(theEvent);
    }

    @Override
    public void route(Object[] objectArray, String eventTypeName) throws EPException {
        if (objectArray == null) {
            throw new IllegalArgumentException("Invalid null event object");
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".route Processing event " + Arrays.toString(objectArray)));
        }
        EventBean theEvent = this.services.getEventAdapterService().adapterForObjectArray(objectArray, eventTypeName);
        if (this.internalEventRouter.isHasPreprocessing() && (theEvent = this.internalEventRouter.preprocess(theEvent, this.engineFilterAndDispatchTimeContext)) == null) {
            return;
        }
        this.threadWorkQueue.addBack(theEvent);
    }

    @Override
    public long getNumEventsEvaluated() {
        return this.services.getFilterService().getNumEventsEvaluated();
    }

    @Override
    public void resetStats() {
        this.services.getFilterService().resetStats();
        this.routedInternal.set(0L);
        this.routedExternal.set(0L);
    }

    @Override
    public void routeEventBean(EventBean theEvent) {
        this.threadWorkQueue.addBack(theEvent);
    }

    @Override
    public void route(Object theEvent) {
        EventBean eventBean;
        this.routedExternal.incrementAndGet();
        if (this.internalEventRouter.isHasPreprocessing() && (theEvent = this.internalEventRouter.preprocess(eventBean = this.services.getEventAdapterService().adapterForBean(theEvent), this.engineFilterAndDispatchTimeContext)) == null) {
            return;
        }
        this.threadWorkQueue.addBack(theEvent);
    }

    @Override
    public void route(EventBean theEvent, EPStatementHandle epStatementHandle, boolean addToFront) {
        this.routedInternal.incrementAndGet();
        if (this.isLatchStatementInsertStream) {
            if (addToFront) {
                Object latch = epStatementHandle.getInsertIntoFrontLatchFactory().newLatch(theEvent);
                this.threadWorkQueue.addFront(latch);
            } else {
                Object latch = epStatementHandle.getInsertIntoBackLatchFactory().newLatch(theEvent);
                this.threadWorkQueue.addBack(latch);
            }
        } else if (addToFront) {
            this.threadWorkQueue.addFront(theEvent);
        } else {
            this.threadWorkQueue.addBack(theEvent);
        }
    }

    public void processEvent(Object theEvent) {
        if (theEvent instanceof TimerEvent) {
            this.processTimeEvent((TimerEvent)theEvent);
            return;
        }
        EventBean eventBean = theEvent instanceof EventBean ? (EventBean)theEvent : this.wrapEvent(theEvent);
        this.processWrappedEvent(eventBean);
    }

    @Override
    public EventBean wrapEvent(Object theEvent) {
        return this.services.getEventAdapterService().adapterForBean(theEvent);
    }

    @Override
    public void processWrappedEvent(EventBean eventBean) {
        if (this.internalEventRouter.isHasPreprocessing() && (eventBean = this.internalEventRouter.preprocess(eventBean, this.engineFilterAndDispatchTimeContext)) == null) {
            return;
        }
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            this.matchesArrayThreadLocal.get().clear();
            throw new EPException(ex);
        }
        finally {
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
        this.processThreadWorkQueue();
    }

    private void processTimeEvent(TimerEvent theEvent) {
        if (theEvent instanceof TimerControlEvent) {
            TimerControlEvent timerControlEvent = (TimerControlEvent)theEvent;
            if (timerControlEvent.getClockType() == TimerControlEvent.ClockType.CLOCK_INTERNAL) {
                this.services.getTimerService().startInternalClock();
                this.isUsingExternalClocking = false;
            } else {
                this.services.getTimerService().stopInternalClock(true);
                this.isUsingExternalClocking = true;
            }
            return;
        }
        if (theEvent instanceof CurrentTimeEvent) {
            CurrentTimeEvent current = (CurrentTimeEvent)theEvent;
            long currentTime = current.getTimeInMillis();
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && ExecutionPathDebugLog.isTimerDebugEnabled) {
                log.debug((Object)(".processTimeEvent Setting time and evaluating schedules for time " + currentTime));
            }
            if (this.isUsingExternalClocking && currentTime == this.services.getSchedulingService().getTime() && log.isWarnEnabled()) {
                log.warn((Object)("Duplicate time event received for currentTime " + currentTime));
            }
            this.services.getSchedulingService().setTime(currentTime);
            if (MetricReportingPath.isMetricsEnabled) {
                this.services.getMetricsReportingService().processTimeEvent(currentTime);
            }
            this.processSchedule(currentTime);
            this.dispatch();
            this.processThreadWorkQueue();
            return;
        }
        CurrentTimeSpanEvent span = (CurrentTimeSpanEvent)theEvent;
        long targetTime = span.getTargetTimeInMillis();
        long currentTime = this.services.getSchedulingService().getTime();
        Long optionalResolution = span.getOptionalResolution();
        if (this.isUsingExternalClocking && targetTime < currentTime && log.isWarnEnabled()) {
            log.warn((Object)("Past or current time event received for currentTime " + targetTime));
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && ExecutionPathDebugLog.isTimerDebugEnabled) {
            log.debug((Object)(".processTimeEvent Setting time span and evaluating schedules for time " + targetTime + " optional resolution " + span.getOptionalResolution()));
        }
        while (currentTime < targetTime) {
            Long nearest;
            currentTime = optionalResolution != null && optionalResolution > 0L ? (currentTime += optionalResolution.longValue()) : ((nearest = this.services.getSchedulingService().getNearestTimeHandle()) == null ? targetTime : nearest);
            if (currentTime > targetTime) {
                currentTime = targetTime;
            }
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && ExecutionPathDebugLog.isTimerDebugEnabled) {
                log.debug((Object)(".processTimeEvent Setting time and evaluating schedules for time " + currentTime));
            }
            this.services.getSchedulingService().setTime(currentTime);
            if (MetricReportingPath.isMetricsEnabled) {
                this.services.getMetricsReportingService().processTimeEvent(currentTime);
            }
            this.processSchedule(currentTime);
            this.dispatch();
            this.processThreadWorkQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSchedule(long time) {
        ArrayBackedCollection<ScheduleHandle> handles = this.scheduleArrayThreadLocal.get();
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.services.getSchedulingService().evaluate(handles);
        }
        finally {
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processScheduleHandles(handles);
        }
        catch (RuntimeException ex) {
            handles.clear();
            throw ex;
        }
        finally {
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
    }

    public void processScheduleHandles(ArrayBackedCollection<ScheduleHandle> handles) {
        EPStatementAgentInstanceHandle handle;
        if (handles.size() == 0) {
            return;
        }
        if (handles.size() == 1) {
            Object[] handleArray = handles.getArray();
            EPStatementHandleCallback handle2 = (EPStatementHandleCallback)handleArray[0];
            if (MetricReportingPath.isMetricsEnabled && handle2.getAgentInstanceHandle().getStatementHandle().getMetricsHandle().isEnabled()) {
                long cpuTimeBefore = MetricUtil.getCPUCurrentThread();
                long wallTimeBefore = MetricUtil.getWall();
                EPRuntimeImpl.processStatementScheduleSingle(handle2, this.services);
                long wallTimeAfter = MetricUtil.getWall();
                long cpuTimeAfter = MetricUtil.getCPUCurrentThread();
                long deltaCPU = cpuTimeAfter - cpuTimeBefore;
                long deltaWall = wallTimeAfter - wallTimeBefore;
                this.services.getMetricsReportingService().accountTime(handle2.getAgentInstanceHandle().getStatementHandle().getMetricsHandle(), deltaCPU, deltaWall, 1);
            } else if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isTimerThreading()) {
                this.services.getThreadingService().submitTimerWork(new TimerUnitSingle(this.services, this, handle2));
            } else {
                EPRuntimeImpl.processStatementScheduleSingle(handle2, this.services);
            }
            handles.clear();
            return;
        }
        Object[] matchArray = handles.getArray();
        int entryCount = handles.size();
        Map<EPStatementAgentInstanceHandle, Object> stmtCallbacks = this.schedulePerStmtThreadLocal.get();
        stmtCallbacks.clear();
        for (int i = 0; i < entryCount; ++i) {
            EPStatementHandleCallback handleCallback = (EPStatementHandleCallback)matchArray[i];
            handle = handleCallback.getAgentInstanceHandle();
            ScheduleHandleCallback callback = handleCallback.getScheduleCallback();
            Object entry = stmtCallbacks.get(handle);
            if (entry == null) {
                stmtCallbacks.put(handle, callback);
                continue;
            }
            if (entry instanceof ScheduleHandleCallback) {
                ScheduleHandleCallback existingCallback = (ScheduleHandleCallback)entry;
                ArrayDeque<ScheduleHandleCallback> entries = new ArrayDeque<ScheduleHandleCallback>();
                entries.add(existingCallback);
                entries.add(callback);
                stmtCallbacks.put(handle, entries);
                continue;
            }
            ArrayDeque entries = (ArrayDeque)entry;
            entries.add(callback);
        }
        handles.clear();
        for (Map.Entry<EPStatementAgentInstanceHandle, Object> entry : stmtCallbacks.entrySet()) {
            handle = entry.getKey();
            Object callbackObject = entry.getValue();
            if (MetricReportingPath.isMetricsEnabled && handle.getStatementHandle().getMetricsHandle().isEnabled()) {
                long cpuTimeBefore = MetricUtil.getCPUCurrentThread();
                long wallTimeBefore = MetricUtil.getWall();
                EPRuntimeImpl.processStatementScheduleMultiple(handle, callbackObject, this.services);
                long wallTimeAfter = MetricUtil.getWall();
                long cpuTimeAfter = MetricUtil.getCPUCurrentThread();
                long deltaCPU = cpuTimeAfter - cpuTimeBefore;
                long deltaWall = wallTimeAfter - wallTimeBefore;
                int numInput = callbackObject instanceof Collection ? ((Collection)callbackObject).size() : 1;
                this.services.getMetricsReportingService().accountTime(handle.getStatementHandle().getMetricsHandle(), deltaCPU, deltaWall, numInput);
            } else if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isTimerThreading()) {
                this.services.getThreadingService().submitTimerWork(new TimerUnitMultiple(this.services, this, handle, callbackObject));
            } else {
                EPRuntimeImpl.processStatementScheduleMultiple(handle, callbackObject, this.services);
            }
            if (!this.isPrioritized || !handle.isPreemptive()) continue;
            break;
        }
    }

    @Override
    public void processThreadWorkQueue() {
        Object item;
        DualWorkQueue queues = this.threadWorkQueue.getThreadQueue();
        if (queues.getFrontQueue().isEmpty()) {
            boolean haveDispatched = this.services.getNamedWindowDispatchService().dispatch();
            if (haveDispatched) {
                this.dispatch();
                if (!queues.getFrontQueue().isEmpty()) {
                    this.processThreadWorkQueueFront(queues);
                }
            }
        } else {
            this.processThreadWorkQueueFront(queues);
        }
        while ((item = queues.getBackQueue().poll()) != null) {
            if (item instanceof InsertIntoLatchSpin) {
                this.processThreadWorkQueueLatchedSpin((InsertIntoLatchSpin)item);
            } else if (item instanceof InsertIntoLatchWait) {
                this.processThreadWorkQueueLatchedWait((InsertIntoLatchWait)item);
            } else {
                this.processThreadWorkQueueUnlatched(item);
            }
            boolean haveDispatched = this.services.getNamedWindowDispatchService().dispatch();
            if (haveDispatched) {
                this.dispatch();
            }
            if (queues.getFrontQueue().isEmpty()) continue;
            this.processThreadWorkQueueFront(queues);
        }
    }

    private void processThreadWorkQueueFront(DualWorkQueue queues) {
        Object item;
        while ((item = queues.getFrontQueue().poll()) != null) {
            boolean haveDispatched;
            if (item instanceof InsertIntoLatchSpin) {
                this.processThreadWorkQueueLatchedSpin((InsertIntoLatchSpin)item);
            } else if (item instanceof InsertIntoLatchWait) {
                this.processThreadWorkQueueLatchedWait((InsertIntoLatchWait)item);
            } else {
                this.processThreadWorkQueueUnlatched(item);
            }
            if (!(haveDispatched = this.services.getNamedWindowDispatchService().dispatch())) continue;
            this.dispatch();
        }
    }

    private void processThreadWorkQueueLatchedWait(InsertIntoLatchWait insertIntoLatch) {
        EventBean eventBean = insertIntoLatch.await();
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            this.matchesArrayThreadLocal.get().clear();
            throw ex;
        }
        finally {
            insertIntoLatch.done();
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
    }

    private void processThreadWorkQueueLatchedSpin(InsertIntoLatchSpin insertIntoLatch) {
        EventBean eventBean = insertIntoLatch.await();
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            this.matchesArrayThreadLocal.get().clear();
            throw ex;
        }
        finally {
            insertIntoLatch.done();
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
    }

    private void processThreadWorkQueueUnlatched(Object item) {
        EventBean eventBean = item instanceof EventBean ? (EventBean)item : this.services.getEventAdapterService().adapterForBean(item);
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            this.matchesArrayThreadLocal.get().clear();
            throw ex;
        }
        finally {
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMatches(EventBean theEvent) {
        EPStatementAgentInstanceHandle handle;
        ArrayBackedCollection<FilterHandle> matches = this.matchesArrayThreadLocal.get();
        long version = this.services.getFilterService().evaluate(theEvent, matches);
        if (matches.size() == 0) {
            if (this.unmatchedListener != null) {
                this.services.getEventProcessingRWLock().releaseReadLock();
                try {
                    this.unmatchedListener.update(theEvent);
                }
                catch (Throwable t) {
                    log.error((Object)("Exception thrown by unmatched listener: " + t.getMessage()), t);
                }
                finally {
                    this.services.getEventProcessingRWLock().acquireReadLock();
                }
            }
            return;
        }
        Map<EPStatementAgentInstanceHandle, Object> stmtCallbacks = this.matchesPerStmtThreadLocal.get();
        Object[] matchArray = matches.getArray();
        int entryCount = matches.size();
        for (int i = 0; i < entryCount; ++i) {
            EPStatementHandleCallback handleCallback = (EPStatementHandleCallback)matchArray[i];
            handle = handleCallback.getAgentInstanceHandle();
            if (handle.isCanSelfJoin() || this.isPrioritized) {
                ArrayDeque<FilterHandleCallback> q;
                Object callbacks = stmtCallbacks.get(handle);
                if (callbacks == null) {
                    stmtCallbacks.put(handle, handleCallback.getFilterCallback());
                    continue;
                }
                if (callbacks instanceof ArrayDeque) {
                    q = (ArrayDeque<FilterHandleCallback>)callbacks;
                    q.add(handleCallback.getFilterCallback());
                    continue;
                }
                q = new ArrayDeque<FilterHandleCallback>(4);
                q.add((FilterHandleCallback)callbacks);
                q.add(handleCallback.getFilterCallback());
                stmtCallbacks.put(handle, q);
                continue;
            }
            if (MetricReportingPath.isMetricsEnabled && handle.getStatementHandle().getMetricsHandle().isEnabled()) {
                long cpuTimeBefore = MetricUtil.getCPUCurrentThread();
                long wallTimeBefore = MetricUtil.getWall();
                this.processStatementFilterSingle(handle, handleCallback, theEvent, version);
                long wallTimeAfter = MetricUtil.getWall();
                long cpuTimeAfter = MetricUtil.getCPUCurrentThread();
                long deltaCPU = cpuTimeAfter - cpuTimeBefore;
                long deltaWall = wallTimeAfter - wallTimeBefore;
                this.services.getMetricsReportingService().accountTime(handle.getStatementHandle().getMetricsHandle(), deltaCPU, deltaWall, 1);
                continue;
            }
            if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isRouteThreading()) {
                this.services.getThreadingService().submitRoute(new RouteUnitSingle(this, handleCallback, theEvent, version));
                continue;
            }
            this.processStatementFilterSingle(handle, handleCallback, theEvent, version);
        }
        matches.clear();
        if (stmtCallbacks.isEmpty()) {
            return;
        }
        for (Map.Entry<EPStatementAgentInstanceHandle, Object> entry : stmtCallbacks.entrySet()) {
            handle = entry.getKey();
            Object callbackList = entry.getValue();
            if (MetricReportingPath.isMetricsEnabled && handle.getStatementHandle().getMetricsHandle().isEnabled()) {
                long cpuTimeBefore = MetricUtil.getCPUCurrentThread();
                long wallTimeBefore = MetricUtil.getWall();
                this.processStatementFilterMultiple(handle, callbackList, theEvent, version);
                long wallTimeAfter = MetricUtil.getWall();
                long cpuTimeAfter = MetricUtil.getCPUCurrentThread();
                long deltaCPU = cpuTimeAfter - cpuTimeBefore;
                long deltaWall = wallTimeAfter - wallTimeBefore;
                int size = 1;
                if (callbackList instanceof Collection) {
                    size = ((Collection)callbackList).size();
                }
                this.services.getMetricsReportingService().accountTime(handle.getStatementHandle().getMetricsHandle(), deltaCPU, deltaWall, size);
            } else if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isRouteThreading()) {
                this.services.getThreadingService().submitRoute(new RouteUnitMultiple(this, callbackList, theEvent, handle, version));
            } else {
                this.processStatementFilterMultiple(handle, callbackList, theEvent, version);
            }
            if (!this.isPrioritized || !handle.isPreemptive()) continue;
            break;
        }
        stmtCallbacks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processStatementScheduleMultiple(EPStatementAgentInstanceHandle handle, Object callbackObject, EPServicesContext services) {
        handle.getStatementAgentInstanceLock().acquireWriteLock();
        try {
            if (!handle.isDestroyed()) {
                if (handle.isHasVariables()) {
                    services.getVariableService().setLocalVersion();
                }
                if (callbackObject instanceof ArrayDeque) {
                    ArrayDeque callbackList = (ArrayDeque)callbackObject;
                    for (ScheduleHandleCallback callback : callbackList) {
                        callback.scheduledTrigger(services.getEngineLevelExtensionServicesContext());
                    }
                } else {
                    ScheduleHandleCallback callback = (ScheduleHandleCallback)callbackObject;
                    callback.scheduledTrigger(services.getEngineLevelExtensionServicesContext());
                }
                handle.internalDispatch();
            }
        }
        catch (RuntimeException ex) {
            services.getExceptionHandlingService().handleException(ex, handle, ExceptionHandlerExceptionType.PROCESS);
        }
        finally {
            if (handle.isHasTableAccess()) {
                services.getTableService().getTableExprEvaluatorContext().releaseAcquiredLocks();
            }
            handle.getStatementAgentInstanceLock().releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processStatementScheduleSingle(EPStatementHandleCallback handle, EPServicesContext services) {
        StatementAgentInstanceLock statementLock = handle.getAgentInstanceHandle().getStatementAgentInstanceLock();
        statementLock.acquireWriteLock();
        try {
            if (!handle.getAgentInstanceHandle().isDestroyed()) {
                if (handle.getAgentInstanceHandle().isHasVariables()) {
                    services.getVariableService().setLocalVersion();
                }
                handle.getScheduleCallback().scheduledTrigger(services.getEngineLevelExtensionServicesContext());
                handle.getAgentInstanceHandle().internalDispatch();
            }
        }
        catch (RuntimeException ex) {
            services.getExceptionHandlingService().handleException(ex, handle.getAgentInstanceHandle(), ExceptionHandlerExceptionType.PROCESS);
        }
        finally {
            if (handle.getAgentInstanceHandle().isHasTableAccess()) {
                services.getTableService().getTableExprEvaluatorContext().releaseAcquiredLocks();
            }
            handle.getAgentInstanceHandle().getStatementAgentInstanceLock().releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStatementFilterMultiple(EPStatementAgentInstanceHandle handle, Object callbackList, EventBean theEvent, long version) {
        handle.getStatementAgentInstanceLock().acquireWriteLock();
        try {
            if (handle.isHasVariables()) {
                this.services.getVariableService().setLocalVersion();
            }
            if (!handle.isCurrentFilter(version)) {
                boolean handled = false;
                if (handle.getFilterFaultHandler() != null) {
                    handled = handle.getFilterFaultHandler().handleFilterFault(theEvent, version);
                }
                if (!handled) {
                    this.handleFilterFault(handle, theEvent);
                }
            } else {
                if (callbackList instanceof Collection) {
                    Collection callbacks = (Collection)callbackList;
                    handle.getMultiMatchHandler().handle(callbacks, theEvent);
                } else {
                    FilterHandleCallback single = (FilterHandleCallback)callbackList;
                    single.matchFound(theEvent, null);
                }
                handle.internalDispatch();
            }
        }
        catch (RuntimeException ex) {
            this.services.getExceptionHandlingService().handleException(ex, handle, ExceptionHandlerExceptionType.PROCESS);
        }
        finally {
            if (handle.isHasTableAccess()) {
                this.services.getTableService().getTableExprEvaluatorContext().releaseAcquiredLocks();
            }
            handle.getStatementAgentInstanceLock().releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStatementFilterSingle(EPStatementAgentInstanceHandle handle, EPStatementHandleCallback handleCallback, EventBean theEvent, long version) {
        handle.getStatementAgentInstanceLock().acquireWriteLock();
        try {
            if (handle.isHasVariables()) {
                this.services.getVariableService().setLocalVersion();
            }
            if (!handle.isCurrentFilter(version)) {
                boolean handled = false;
                if (handle.getFilterFaultHandler() != null) {
                    handled = handle.getFilterFaultHandler().handleFilterFault(theEvent, version);
                }
                if (!handled) {
                    this.handleFilterFault(handle, theEvent);
                }
            } else {
                handleCallback.getFilterCallback().matchFound(theEvent, null);
            }
            handle.internalDispatch();
        }
        catch (RuntimeException ex) {
            this.services.getExceptionHandlingService().handleException(ex, handle, ExceptionHandlerExceptionType.PROCESS);
        }
        finally {
            if (handle.isHasTableAccess()) {
                this.services.getTableService().getTableExprEvaluatorContext().releaseAcquiredLocks();
            }
            handleCallback.getAgentInstanceHandle().getStatementAgentInstanceLock().releaseWriteLock();
        }
    }

    protected void handleFilterFault(EPStatementAgentInstanceHandle faultingHandle, EventBean theEvent) {
        ArrayDeque<FilterHandle> callbacksForStatement = new ArrayDeque<FilterHandle>();
        long version = this.services.getFilterService().evaluate(theEvent, callbacksForStatement, faultingHandle.getStatementId());
        if (callbacksForStatement.size() == 1) {
            EPStatementHandleCallback handleCallback = (EPStatementHandleCallback)callbacksForStatement.getFirst();
            this.processStatementFilterSingle(handleCallback.getAgentInstanceHandle(), handleCallback, theEvent, version);
            return;
        }
        if (callbacksForStatement.isEmpty()) {
            return;
        }
        AbstractMap stmtCallbacks = this.isPrioritized ? new TreeMap(EPStatementAgentInstanceHandleComparator.INSTANCE) : new HashMap();
        for (FilterHandle filterHandle : callbacksForStatement) {
            EPStatementHandleCallback handleCallback = (EPStatementHandleCallback)filterHandle;
            EPStatementAgentInstanceHandle handle = handleCallback.getAgentInstanceHandle();
            if (handle.isCanSelfJoin() || this.isPrioritized) {
                ArrayDeque<FilterHandleCallback> q;
                Object callbacks = stmtCallbacks.get(handle);
                if (callbacks == null) {
                    stmtCallbacks.put(handle, handleCallback.getFilterCallback());
                    continue;
                }
                if (callbacks instanceof ArrayDeque) {
                    q = (ArrayDeque<FilterHandleCallback>)callbacks;
                    q.add(handleCallback.getFilterCallback());
                    continue;
                }
                q = new ArrayDeque<FilterHandleCallback>(4);
                q.add((FilterHandleCallback)callbacks);
                q.add(handleCallback.getFilterCallback());
                stmtCallbacks.put(handle, q);
                continue;
            }
            this.processStatementFilterSingle(handle, handleCallback, theEvent, version);
        }
        if (stmtCallbacks.isEmpty()) {
            return;
        }
        for (Map.Entry entry : stmtCallbacks.entrySet()) {
            EPStatementAgentInstanceHandle handle = (EPStatementAgentInstanceHandle)entry.getKey();
            Object callbackList = entry.getValue();
            this.processStatementFilterMultiple(handle, callbackList, theEvent, version);
            if (!this.isPrioritized || !handle.isPreemptive()) continue;
            break;
        }
    }

    @Override
    public void dispatch() {
        try {
            this.services.getDispatchService().dispatch();
        }
        catch (RuntimeException ex) {
            throw new EPException(ex);
        }
    }

    @Override
    public boolean isExternalClockingEnabled() {
        return this.isUsingExternalClocking;
    }

    @Override
    public void destroy() {
        this.services = null;
        this.removeFromThreadLocals();
        this.matchesArrayThreadLocal = null;
        this.matchesPerStmtThreadLocal = null;
        this.scheduleArrayThreadLocal = null;
        this.schedulePerStmtThreadLocal = null;
    }

    @Override
    public void initialize() {
        this.initThreadLocals();
        this.threadWorkQueue = new ThreadWorkQueue();
    }

    @Override
    public void clearCaches() {
        this.initThreadLocals();
    }

    @Override
    public void setUnmatchedListener(UnmatchedListener listener) {
        this.unmatchedListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVariableValue(String variableName, Object variableValue) throws EPException {
        VariableMetaData metaData = this.services.getVariableService().getVariableMetaData(variableName);
        this.checkVariable(variableName, metaData, true, false);
        this.services.getVariableService().getReadWriteLock().writeLock().lock();
        try {
            this.services.getVariableService().checkAndWrite(variableName, -1, variableValue);
            this.services.getVariableService().commit();
        }
        finally {
            this.services.getVariableService().getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void setVariableValue(Map<String, Object> variableValues) throws EPException {
        this.setVariableValueInternal(variableValues, -1, false);
    }

    @Override
    public void setVariableValue(Map<String, Object> variableValues, int agentInstanceId) throws VariableValueException, VariableNotFoundException {
        this.setVariableValueInternal(variableValues, agentInstanceId, true);
    }

    @Override
    public Object getVariableValue(String variableName) throws EPException {
        this.services.getVariableService().setLocalVersion();
        VariableMetaData metaData = this.services.getVariableService().getVariableMetaData(variableName);
        if (metaData == null) {
            throw new VariableNotFoundException("Variable by name '" + variableName + "' has not been declared");
        }
        if (metaData.getContextPartitionName() != null) {
            throw new VariableNotFoundException("Variable by name '" + variableName + "' has been declared for context '" + metaData.getContextPartitionName() + "' and cannot be read without context partition selector");
        }
        VariableReader reader = this.services.getVariableService().getReader(variableName, -1);
        Object value = reader.getValue();
        if (value == null || reader.getVariableMetaData().getEventType() == null) {
            return value;
        }
        return ((EventBean)value).getUnderlying();
    }

    @Override
    public Map<String, List<ContextPartitionVariableState>> getVariableValue(Set<String> variableNames, ContextPartitionSelector contextPartitionSelector) throws VariableNotFoundException {
        this.services.getVariableService().setLocalVersion();
        String contextPartitionName = null;
        for (String variableName : variableNames) {
            VariableMetaData metaData = this.services.getVariableService().getVariableMetaData(variableName);
            if (metaData == null) {
                throw new VariableNotFoundException("Variable by name '" + variableName + "' has not been declared");
            }
            if (metaData.getContextPartitionName() == null) {
                throw new VariableNotFoundException("Variable by name '" + variableName + "' is a global variable and not context-partitioned");
            }
            if (contextPartitionName == null) {
                contextPartitionName = metaData.getContextPartitionName();
                continue;
            }
            if (contextPartitionName.equals(metaData.getContextPartitionName())) continue;
            throw new VariableNotFoundException("Variable by name '" + variableName + "' is a declared for context '" + metaData.getContextPartitionName() + "' however the expected context is '" + contextPartitionName + "'");
        }
        ContextManager contextManager = this.services.getContextManagementService().getContextManager(contextPartitionName);
        if (contextManager == null) {
            throw new VariableNotFoundException("Context by name '" + contextPartitionName + "' cannot be found");
        }
        Map<Integer, ContextPartitionDescriptor> contextPartitions = contextManager.extractPaths(contextPartitionSelector).getContextPartitionInformation();
        if (contextPartitions.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<ContextPartitionVariableState>> statesMap = new HashMap<String, List<ContextPartitionVariableState>>();
        for (String variableName : variableNames) {
            ArrayList<ContextPartitionVariableState> states = new ArrayList<ContextPartitionVariableState>();
            statesMap.put(variableName, states);
            for (Map.Entry<Integer, ContextPartitionDescriptor> entry : contextPartitions.entrySet()) {
                VariableReader reader = this.services.getVariableService().getReader(variableName, entry.getKey());
                Object value = reader.getValue();
                if (value != null && reader.getVariableMetaData().getEventType() != null) {
                    value = ((EventBean)value).getUnderlying();
                }
                states.add(new ContextPartitionVariableState(entry.getKey(), entry.getValue().getIdentifier(), value));
            }
        }
        return statesMap;
    }

    @Override
    public Map<String, Object> getVariableValue(Set<String> variableNames) throws EPException {
        this.services.getVariableService().setLocalVersion();
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (String variableName : variableNames) {
            VariableMetaData metaData = this.services.getVariableService().getVariableMetaData(variableName);
            this.checkVariable(variableName, metaData, false, false);
            VariableReader reader = this.services.getVariableService().getReader(variableName, -1);
            if (reader == null) {
                throw new VariableNotFoundException("Variable by name '" + variableName + "' has not been declared");
            }
            Object value = reader.getValue();
            if (value != null && reader.getVariableMetaData().getEventType() != null) {
                value = ((EventBean)value).getUnderlying();
            }
            values.put(variableName, value);
        }
        return values;
    }

    @Override
    public Map<String, Object> getVariableValueAll() throws EPException {
        this.services.getVariableService().setLocalVersion();
        Map<String, VariableReader> variables = this.services.getVariableService().getVariableReadersNonCP();
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<String, VariableReader> entry : variables.entrySet()) {
            Object value = entry.getValue().getValue();
            values.put(entry.getValue().getVariableMetaData().getVariableName(), value);
        }
        return values;
    }

    @Override
    public Map<String, Class> getVariableTypeAll() {
        Map<String, VariableReader> variables = this.services.getVariableService().getVariableReadersNonCP();
        HashMap<String, Class> values = new HashMap<String, Class>();
        for (Map.Entry<String, VariableReader> entry : variables.entrySet()) {
            Class type = entry.getValue().getVariableMetaData().getType();
            values.put(entry.getValue().getVariableMetaData().getVariableName(), type);
        }
        return values;
    }

    @Override
    public Class getVariableType(String variableName) {
        VariableMetaData metaData = this.services.getVariableService().getVariableMetaData(variableName);
        if (metaData == null) {
            return null;
        }
        return metaData.getType();
    }

    @Override
    public EPOnDemandQueryResult executeQuery(String epl, ContextPartitionSelector[] contextPartitionSelectors) {
        if (contextPartitionSelectors == null) {
            throw new IllegalArgumentException("No context partition selectors provided");
        }
        return this.executeQueryInternal(epl, null, null, contextPartitionSelectors);
    }

    @Override
    public EPOnDemandQueryResult executeQuery(String epl) {
        return this.executeQueryInternal(epl, null, null, null);
    }

    @Override
    public EPOnDemandQueryResult executeQuery(EPStatementObjectModel model) {
        return this.executeQueryInternal(null, model, null, null);
    }

    @Override
    public EPOnDemandQueryResult executeQuery(EPStatementObjectModel model, ContextPartitionSelector[] contextPartitionSelectors) {
        if (contextPartitionSelectors == null) {
            throw new IllegalArgumentException("No context partition selectors provided");
        }
        return this.executeQueryInternal(null, model, null, contextPartitionSelectors);
    }

    @Override
    public EPOnDemandQueryResult executeQuery(EPOnDemandPreparedQueryParameterized parameterizedQuery) {
        return this.executeQueryInternal(null, null, parameterizedQuery, null);
    }

    @Override
    public EPOnDemandQueryResult executeQuery(EPOnDemandPreparedQueryParameterized parameterizedQuery, ContextPartitionSelector[] contextPartitionSelectors) {
        return this.executeQueryInternal(null, null, parameterizedQuery, contextPartitionSelectors);
    }

    private EPOnDemandQueryResult executeQueryInternal(String epl, EPStatementObjectModel model, EPOnDemandPreparedQueryParameterized parameterizedQuery, ContextPartitionSelector[] contextPartitionSelectors) {
        try {
            EPPreparedExecuteMethod executeMethod = this.getExecuteMethod(epl, model, parameterizedQuery);
            EPPreparedQueryResult result = executeMethod.execute(contextPartitionSelectors);
            return new EPQueryResultImpl(result);
        }
        catch (EPStatementException ex) {
            throw ex;
        }
        catch (Throwable t) {
            String message = "Error executing statement: " + t.getMessage();
            log.info((Object)message, t);
            throw new EPStatementException(message, t, epl);
        }
    }

    @Override
    public EPOnDemandPreparedQuery prepareQuery(String epl) {
        return this.prepareQueryInternal(epl, null);
    }

    @Override
    public EPOnDemandPreparedQuery prepareQuery(EPStatementObjectModel model) {
        return this.prepareQueryInternal(null, model);
    }

    @Override
    public EPOnDemandPreparedQueryParameterized prepareQueryWithParameters(String epl) {
        String stmtName = UuidGenerator.generate();
        StatementSpecRaw statementSpec = EPAdministratorHelper.compileEPL(epl, epl, true, stmtName, this.services, SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
        StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap(statementSpec);
        return new EPPreparedStatementImpl(unmapped.getObjectModel(), unmapped.getSubstitutionParams(), epl);
    }

    private EPOnDemandPreparedQuery prepareQueryInternal(String epl, EPStatementObjectModel model) {
        try {
            EPPreparedExecuteMethod startMethod = this.getExecuteMethod(epl, model, null);
            return new EPPreparedQueryImpl(startMethod, epl);
        }
        catch (EPStatementException ex) {
            throw ex;
        }
        catch (Throwable t) {
            String message = "Error executing statement: " + t.getMessage();
            log.debug((Object)message, t);
            throw new EPStatementException(message, epl);
        }
    }

    private EPPreparedExecuteMethod getExecuteMethod(String epl, EPStatementObjectModel model, EPOnDemandPreparedQueryParameterized parameterizedQuery) {
        String stmtName = UuidGenerator.generate();
        int stmtId = -1;
        try {
            ExprNodeSubselectDeclaredDotVisitor visitor;
            StatementSpecRaw spec;
            if (epl != null) {
                spec = EPAdministratorHelper.compileEPL(epl, epl, true, stmtName, this.services, SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
            } else if (model != null) {
                spec = StatementSpecMapper.map(model, this.services.getEngineImportService(), this.services.getVariableService(), this.services.getConfigSnapshot(), this.services.getSchedulingService(), this.services.getEngineURI(), this.services.getPatternNodeFactory(), this.services.getNamedWindowMgmtService(), this.services.getContextManagementService(), this.services.getExprDeclaredService(), this.services.getTableService());
                epl = model.toEPL();
            } else {
                EPPreparedStatementImpl prepared = (EPPreparedStatementImpl)parameterizedQuery;
                spec = StatementSpecMapper.map(prepared.getModel(), this.services.getEngineImportService(), this.services.getVariableService(), this.services.getConfigSnapshot(), this.services.getSchedulingService(), this.services.getEngineURI(), this.services.getPatternNodeFactory(), this.services.getNamedWindowMgmtService(), this.services.getContextManagementService(), this.services.getExprDeclaredService(), this.services.getTableService());
                epl = prepared.getOptionalEPL();
                if (epl == null) {
                    epl = prepared.getModel().toEPL();
                }
            }
            Annotation[] annotations = AnnotationUtil.compileAnnotations(spec.getAnnotations(), this.services.getEngineImportService(), epl);
            boolean writesToTables = StatementLifecycleSvcUtil.isWritesToTables(spec, this.services.getTableService());
            StatementContext statementContext = this.services.getStatementContextFactory().makeContext(stmtId, stmtName, epl, StatementType.SELECT, this.services, null, true, annotations, null, true, spec, Collections.<ExprSubselectNode>emptyList(), writesToTables, null);
            try {
                visitor = StatementSpecRawAnalyzer.walkSubselectAndDeclaredDotExpr(spec);
            }
            catch (ExprValidationException ex) {
                throw new EPStatementException(ex.getMessage(), epl);
            }
            StatementSpecCompiled compiledSpec = StatementLifecycleSvcImpl.compile(spec, epl, statementContext, false, true, annotations, visitor.getSubselects(), Collections.<ExprDeclaredNode>emptyList(), spec.getTableExpressions(), this.services);
            if (compiledSpec.getInsertIntoDesc() != null) {
                return new EPPreparedExecuteIUDInsertInto(compiledSpec, this.services, statementContext);
            }
            if (compiledSpec.getFireAndForgetSpec() == null) {
                if (compiledSpec.getUpdateSpec() != null) {
                    throw new EPStatementException("Provided EPL expression is a continuous query expression (not an on-demand query), please use the administrator createEPL API instead", epl);
                }
                return new EPPreparedExecuteMethodQuery(compiledSpec, this.services, statementContext);
            }
            if (compiledSpec.getFireAndForgetSpec() instanceof FireAndForgetSpecDelete) {
                return new EPPreparedExecuteIUDSingleStreamDelete(compiledSpec, this.services, statementContext);
            }
            if (compiledSpec.getFireAndForgetSpec() instanceof FireAndForgetSpecUpdate) {
                return new EPPreparedExecuteIUDSingleStreamUpdate(compiledSpec, this.services, statementContext);
            }
            throw new IllegalStateException("Unrecognized FAF code " + compiledSpec.getFireAndForgetSpec());
        }
        catch (EPStatementException ex) {
            throw ex;
        }
        catch (Throwable t) {
            String message = "Error executing statement: " + t.getMessage();
            log.debug((Object)message, t);
            throw new EPStatementException(message, t, epl);
        }
    }

    @Override
    public EventSender getEventSender(String eventTypeName) {
        return this.services.getEventAdapterService().getStaticTypeEventSender(this, eventTypeName, this.services.getThreadingService());
    }

    @Override
    public EventSender getEventSender(URI[] uri) throws EventTypeException {
        return this.services.getEventAdapterService().getDynamicTypeEventSender(this, uri, this.services.getThreadingService());
    }

    @Override
    public EventRenderer getEventRenderer() {
        if (this.eventRenderer == null) {
            this.eventRenderer = new EventRendererImpl();
        }
        return this.eventRenderer;
    }

    @Override
    public long getCurrentTime() {
        return this.services.getSchedulingService().getTime();
    }

    @Override
    public Long getNextScheduledTime() {
        return this.services.getSchedulingService().getNearestTimeHandle();
    }

    @Override
    public Map<String, Long> getStatementNearestSchedules() {
        return EPRuntimeImpl.getStatementNearestSchedulesInternal(this.services.getSchedulingService(), this.services.getStatementLifecycleSvc());
    }

    protected static Map<String, Long> getStatementNearestSchedulesInternal(SchedulingServiceSPI schedulingService, StatementLifecycleSvc statementLifecycleSvc) {
        final HashMap schedulePerStatementId = new HashMap();
        schedulingService.visitSchedules(new ScheduleVisitor(){

            @Override
            public void visit(ScheduleVisit visit) {
                if (schedulePerStatementId.containsKey(visit.getStatementId())) {
                    return;
                }
                schedulePerStatementId.put(visit.getStatementId(), visit.getTimestamp());
            }
        });
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (Map.Entry schedule : schedulePerStatementId.entrySet()) {
            String stmtName = statementLifecycleSvc.getStatementNameById((Integer)schedule.getKey());
            if (stmtName == null) continue;
            result.put(stmtName, (Long)schedule.getValue());
        }
        return result;
    }

    @Override
    public String getEngineURI() {
        return this.services.getEngineURI();
    }

    @Override
    public EPDataFlowRuntime getDataFlowRuntime() {
        return this.services.getDataFlowService();
    }

    private void removeFromThreadLocals() {
        if (this.matchesArrayThreadLocal != null) {
            this.matchesArrayThreadLocal.remove();
        }
        if (this.matchesPerStmtThreadLocal != null) {
            this.matchesPerStmtThreadLocal.remove();
        }
        if (this.scheduleArrayThreadLocal != null) {
            this.scheduleArrayThreadLocal.remove();
        }
        if (this.schedulePerStmtThreadLocal != null) {
            this.schedulePerStmtThreadLocal.remove();
        }
    }

    private void initThreadLocals() {
        this.removeFromThreadLocals();
        this.matchesArrayThreadLocal = new ThreadLocal<ArrayBackedCollection<FilterHandle>>(){

            @Override
            protected synchronized ArrayBackedCollection<FilterHandle> initialValue() {
                return new ArrayBackedCollection<FilterHandle>(100);
            }
        };
        this.scheduleArrayThreadLocal = new ThreadLocal<ArrayBackedCollection<ScheduleHandle>>(){

            @Override
            protected synchronized ArrayBackedCollection<ScheduleHandle> initialValue() {
                return new ArrayBackedCollection<ScheduleHandle>(100);
            }
        };
        this.matchesPerStmtThreadLocal = new ThreadLocal<Map<EPStatementAgentInstanceHandle, Object>>(){

            @Override
            protected synchronized Map<EPStatementAgentInstanceHandle, Object> initialValue() {
                if (EPRuntimeImpl.this.isPrioritized) {
                    return new TreeMap<EPStatementAgentInstanceHandle, Object>(EPStatementAgentInstanceHandleComparator.INSTANCE);
                }
                return new HashMap<EPStatementAgentInstanceHandle, Object>();
            }
        };
        this.schedulePerStmtThreadLocal = new ThreadLocal<Map<EPStatementAgentInstanceHandle, Object>>(){

            @Override
            protected synchronized Map<EPStatementAgentInstanceHandle, Object> initialValue() {
                if (EPRuntimeImpl.this.isPrioritized) {
                    return new TreeMap<EPStatementAgentInstanceHandle, Object>(EPStatementAgentInstanceHandleComparator.INSTANCE);
                }
                return new HashMap<EPStatementAgentInstanceHandle, Object>();
            }
        };
    }

    private void checkVariable(String variableName, VariableMetaData metaData, boolean settable, boolean requireContextPartitioned) {
        if (metaData == null) {
            throw new VariableNotFoundException("Variable by name '" + variableName + "' has not been declared");
        }
        if (!requireContextPartitioned) {
            if (metaData.getContextPartitionName() != null) {
                throw new VariableNotFoundException("Variable by name '" + variableName + "' has been declared for context '" + metaData.getContextPartitionName() + "' and cannot be set without context partition selectors");
            }
        } else if (metaData.getContextPartitionName() == null) {
            throw new VariableNotFoundException("Variable by name '" + variableName + "' is a global variable and not context-partitioned");
        }
        if (settable && metaData.isConstant()) {
            throw new VariableConstantValueException("Variable by name '" + variableName + "' is declared as constant and may not be assigned a new value");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVariableValueInternal(Map<String, Object> variableValues, int agentInstanceId, boolean requireContextPartitioned) throws EPException {
        String variableName;
        for (Map.Entry<String, Object> entry : variableValues.entrySet()) {
            variableName = entry.getKey();
            VariableMetaData metaData = this.services.getVariableService().getVariableMetaData(variableName);
            this.checkVariable(variableName, metaData, true, requireContextPartitioned);
        }
        this.services.getVariableService().getReadWriteLock().writeLock().lock();
        try {
            for (Map.Entry<String, Object> entry : variableValues.entrySet()) {
                variableName = entry.getKey();
                try {
                    this.services.getVariableService().checkAndWrite(variableName, agentInstanceId, entry.getValue());
                }
                catch (RuntimeException ex) {
                    this.services.getVariableService().rollback();
                    throw ex;
                }
            }
            this.services.getVariableService().commit();
        }
        finally {
            this.services.getVariableService().getReadWriteLock().writeLock().unlock();
        }
    }
}

