/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.hook.BaseCondition;
import com.espertech.esper.client.hook.ConditionHandler;
import com.espertech.esper.client.hook.ConditionHandlerContext;
import com.espertech.esper.client.hook.ExceptionHandler;
import com.espertech.esper.client.hook.ExceptionHandlerContext;
import com.espertech.esper.client.hook.ExceptionHandlerExceptionType;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.EPStatementHandle;
import java.io.StringWriter;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExceptionHandlingService {
    private static final Log log = LogFactory.getLog(ExceptionHandlingService.class);
    private final String engineURI;
    private final List<ExceptionHandler> exceptionHandlers;
    private final List<ConditionHandler> conditionHandlers;

    public ExceptionHandlingService(String engineURI, List<ExceptionHandler> exceptionHandlers, List<ConditionHandler> conditionHandlers) {
        this.engineURI = engineURI;
        this.exceptionHandlers = exceptionHandlers;
        this.conditionHandlers = conditionHandlers;
    }

    public void handleCondition(BaseCondition condition, EPStatementHandle handle) {
        if (this.conditionHandlers.isEmpty()) {
            log.info((Object)("Condition encountered processing statement '" + handle.getStatementName() + "' statement text '" + handle.getEPL() + "' : " + condition.toString()));
            return;
        }
        ConditionHandlerContext context = new ConditionHandlerContext(this.engineURI, handle.getStatementName(), handle.getEPL(), condition);
        for (ConditionHandler handler : this.conditionHandlers) {
            handler.handle(context);
        }
    }

    public void handleException(RuntimeException ex, EPStatementAgentInstanceHandle handle, ExceptionHandlerExceptionType type) {
        this.handleException(ex, handle.getStatementHandle().getStatementName(), handle.getStatementHandle().getEPL(), type);
    }

    public String getEngineURI() {
        return this.engineURI;
    }

    public void handleException(RuntimeException ex, String statementName, String epl, ExceptionHandlerExceptionType type) {
        if (this.exceptionHandlers.isEmpty()) {
            StringWriter writer = new StringWriter();
            if (type == ExceptionHandlerExceptionType.PROCESS) {
                writer.append("Exception encountered processing ");
            } else {
                writer.append("Exception encountered performing instance stop for ");
            }
            writer.append("statement '");
            writer.append(statementName);
            writer.append("' expression '");
            writer.append(epl);
            writer.append("' : ");
            writer.append(ex.getMessage());
            String message = writer.toString();
            if (type == ExceptionHandlerExceptionType.PROCESS) {
                log.error((Object)message, (Throwable)ex);
            } else {
                log.warn((Object)message, (Throwable)ex);
            }
            return;
        }
        ExceptionHandlerContext context = new ExceptionHandlerContext(this.engineURI, ex, statementName, epl, type);
        for (ExceptionHandler handler : this.exceptionHandlers) {
            handler.handle(context);
        }
    }
}

