/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.RollingTwoValueBuffer;
import com.espertech.esper.core.service.ExpressionResultCacheEntry;
import com.espertech.esper.core.service.ExpressionResultCacheForDeclaredExprLastValue;
import com.espertech.esper.event.EventBeanUtility;
import java.lang.ref.SoftReference;
import java.util.IdentityHashMap;

public class ExpressionResultCacheForDeclaredExprLastValueMulti
implements ExpressionResultCacheForDeclaredExprLastValue {
    private final int cacheSize;
    private final ExpressionResultCacheEntry<EventBean[], Object> resultCacheEntry = new ExpressionResultCacheEntry<Object, Object>(null, null);
    private final IdentityHashMap<Object, SoftReference<RollingTwoValueBuffer<EventBean[], Object>>> cache = new IdentityHashMap();

    public ExpressionResultCacheForDeclaredExprLastValueMulti(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    @Override
    public boolean cacheEnabled() {
        return true;
    }

    @Override
    public ExpressionResultCacheEntry<EventBean[], Object> getDeclaredExpressionLastValue(Object node, EventBean[] eventsPerStream) {
        SoftReference<RollingTwoValueBuffer<EventBean[], Object>> cacheRef = this.cache.get(node);
        if (cacheRef == null) {
            return null;
        }
        RollingTwoValueBuffer<EventBean[], Object> entry = cacheRef.get();
        if (entry == null) {
            return null;
        }
        for (int i = 0; i < ((EventBean[][])entry.getBufferA()).length; ++i) {
            EventBean[] key = ((EventBean[][])entry.getBufferA())[i];
            if (key == null || !EventBeanUtility.compareEventReferences(key, eventsPerStream)) continue;
            this.resultCacheEntry.setReference(key);
            this.resultCacheEntry.setResult(entry.getBufferB()[i]);
            return this.resultCacheEntry;
        }
        return null;
    }

    @Override
    public void saveDeclaredExpressionLastValue(Object node, EventBean[] eventsPerStream, Object result) {
        RollingTwoValueBuffer<Object, Object> buf;
        SoftReference<RollingTwoValueBuffer<EventBean[], Object>> cacheRef = this.cache.get(node);
        if (cacheRef == null) {
            buf = new RollingTwoValueBuffer((A[])new EventBean[this.cacheSize][], (B[])new Object[this.cacheSize]);
            this.cache.put(node, new SoftReference<RollingTwoValueBuffer<EventBean[], Object>>(buf));
        } else {
            buf = cacheRef.get();
            if (buf == null) {
                buf = new RollingTwoValueBuffer((A[])new EventBean[this.cacheSize][], (B[])new Object[this.cacheSize]);
                this.cache.put(node, new SoftReference<RollingTwoValueBuffer<Object, Object>>(buf));
            }
        }
        EventBean[] copy = new EventBean[eventsPerStream.length];
        System.arraycopy(eventsPerStream, 0, copy, 0, copy.length);
        buf.add(copy, result);
    }
}

