/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.service.InsertIntoLatchFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InsertIntoLatchSpin {
    private static final Log log = LogFactory.getLog(InsertIntoLatchSpin.class);
    private InsertIntoLatchFactory factory;
    private InsertIntoLatchSpin earlier;
    private long msecTimeout;
    private EventBean payload;
    private volatile boolean isCompleted;

    public InsertIntoLatchSpin(InsertIntoLatchFactory factory, InsertIntoLatchSpin earlier, long msecTimeout, EventBean payload) {
        this.factory = factory;
        this.earlier = earlier;
        this.msecTimeout = msecTimeout;
        this.payload = payload;
    }

    public InsertIntoLatchSpin(InsertIntoLatchFactory factory) {
        this.factory = factory;
        this.isCompleted = true;
        this.earlier = null;
        this.msecTimeout = 0L;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public EventBean await() {
        if (!this.earlier.isCompleted) {
            long spinStartTime = this.factory.getTimeSourceService().getTimeMillis();
            while (!this.earlier.isCompleted) {
                Thread.yield();
                long spinDelta = this.factory.getTimeSourceService().getTimeMillis() - spinStartTime;
                if (spinDelta <= this.msecTimeout) continue;
                log.info((Object)("Spin wait timeout exceeded in insert-into dispatch at " + this.msecTimeout + "ms for " + this.factory.getName() + ", consider disabling insert-into between-statement latching for better performance"));
                break;
            }
        }
        return this.payload;
    }

    public void done() {
        this.isCompleted = true;
        this.earlier = null;
    }
}

