/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.service.ResultDeliveryStrategy;
import com.espertech.esper.core.service.ResultDeliveryStrategyImpl;
import com.espertech.esper.event.NaturalEventBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultDeliveryStrategyMap
implements ResultDeliveryStrategy {
    private static Log log = LogFactory.getLog(ResultDeliveryStrategyMap.class);
    protected final EPStatement statement;
    protected final Object subscriber;
    protected final FastMethod fastMethod;
    protected final String[] columnNames;

    public ResultDeliveryStrategyMap(EPStatement statement, Object subscriber, Method method, String[] columnNames) {
        this.statement = statement;
        this.subscriber = subscriber;
        FastClass fastClass = FastClass.create((ClassLoader)Thread.currentThread().getContextClassLoader(), subscriber.getClass());
        this.fastMethod = fastClass.getMethod(method);
        this.columnNames = columnNames;
    }

    @Override
    public void execute(UniformPair<EventBean[]> result) {
        Map[] oldData;
        Map[] newData;
        if (result == null) {
            newData = null;
            oldData = null;
        } else {
            newData = this.convert(result.getFirst());
            oldData = this.convert(result.getSecond());
        }
        Object[] parameters = new Object[]{newData, oldData};
        try {
            this.fastMethod.invoke(this.subscriber, parameters);
        }
        catch (InvocationTargetException e) {
            ResultDeliveryStrategyImpl.handle(this.statement.getName(), log, e, parameters, this.subscriber, this.fastMethod);
        }
    }

    protected Map[] convert(EventBean[] events) {
        if (events == null || events.length == 0) {
            return null;
        }
        Map[] result = new Map[events.length];
        int length = 0;
        for (int i = 0; i < result.length; ++i) {
            if (!(events[i] instanceof NaturalEventBean)) continue;
            NaturalEventBean natural = (NaturalEventBean)events[i];
            result[length] = this.convert(natural);
            ++length;
        }
        if (length == 0) {
            return null;
        }
        if (length != events.length) {
            Map[] reduced = new Map[length];
            System.arraycopy(result, 0, reduced, 0, length);
            result = reduced;
        }
        return result;
    }

    private Map convert(NaturalEventBean natural) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object[] columns = natural.getNatural();
        for (int i = 0; i < columns.length; ++i) {
            map.put(this.columnNames[i], columns[i]);
        }
        return map;
    }
}

