/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service.multimatch;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.service.multimatch.MultiMatchHandler;
import com.espertech.esper.filter.FilterHandleCallback;
import java.util.Collection;
import java.util.LinkedHashSet;

public class MultiMatchHandlerNoSubqueryWDedup
implements MultiMatchHandler {
    protected static final MultiMatchHandlerNoSubqueryWDedup INSTANCE = new MultiMatchHandlerNoSubqueryWDedup();
    protected static final ThreadLocal<LinkedHashSet<FilterHandleCallback>> dedups = new ThreadLocal<LinkedHashSet<FilterHandleCallback>>(){

        @Override
        protected synchronized LinkedHashSet<FilterHandleCallback> initialValue() {
            return new LinkedHashSet<FilterHandleCallback>();
        }
    };

    private MultiMatchHandlerNoSubqueryWDedup() {
    }

    @Override
    public void handle(Collection<FilterHandleCallback> callbacks, EventBean theEvent) {
        if (callbacks.size() >= 8) {
            LinkedHashSet<FilterHandleCallback> dedup = dedups.get();
            dedup.clear();
            dedup.addAll(callbacks);
            for (FilterHandleCallback callback : dedup) {
                callback.matchFound(theEvent, callbacks);
            }
            dedup.clear();
        } else {
            int count = 0;
            for (FilterHandleCallback callback : callbacks) {
                boolean haveInvoked = this.checkDup(callback, callbacks, count);
                if (!haveInvoked) {
                    callback.matchFound(theEvent, callbacks);
                }
                ++count;
            }
        }
    }

    private boolean checkDup(FilterHandleCallback callback, Collection<FilterHandleCallback> callbacks, int count) {
        if (count < 1) {
            return false;
        }
        int index = 0;
        for (FilterHandleCallback candidate : callbacks) {
            if (candidate == callback) {
                return true;
            }
            if (++index != count) continue;
            break;
        }
        return false;
    }
}

