/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementAgentInstanceFilterVersion;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementStartMethod;
import com.espertech.esper.core.start.EPStatementStartResult;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.view.ViewProcessingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class EPStatementStartMethodBase
implements EPStatementStartMethod {
    private static final Log log = LogFactory.getLog(EPStatementStartMethodBase.class);
    private static final Log queryPlanLog = LogFactory.getLog((String)"com.espertech.esper.queryplan");
    protected final StatementSpecCompiled statementSpec;

    protected EPStatementStartMethodBase(StatementSpecCompiled statementSpec) {
        this.statementSpec = statementSpec;
    }

    @Override
    public StatementSpecCompiled getStatementSpec() {
        return this.statementSpec;
    }

    public abstract EPStatementStartResult startInternal(EPServicesContext var1, StatementContext var2, boolean var3, boolean var4, boolean var5) throws ExprValidationException, ViewProcessingException;

    @Override
    public EPStatementStartResult start(EPServicesContext services, StatementContext statementContext, boolean isNewStatement, boolean isRecoveringStatement, boolean isRecoveringResilient) throws ExprValidationException, ViewProcessingException {
        statementContext.getVariableService().setLocalVersion();
        boolean queryPlanLogging = services.getConfigSnapshot().getEngineDefaults().getLogging().isEnableQueryPlan();
        if (queryPlanLogging && queryPlanLog.isInfoEnabled()) {
            queryPlanLog.info((Object)("Query plans for statement '" + statementContext.getStatementName() + "' expression '" + statementContext.getExpression() + "'"));
        }
        if (this.statementSpec.getOptionalContextName() != null && statementContext.getContextDescriptor() == null) {
            throw new ExprValidationException("Context by name '" + this.statementSpec.getOptionalContextName() + "' has not been declared");
        }
        return this.startInternal(services, statementContext, isNewStatement, isRecoveringStatement, isRecoveringResilient);
    }

    protected EPStatementAgentInstanceHandle getDefaultAgentInstanceHandle(StatementContext statementContext) throws ExprValidationException {
        return new EPStatementAgentInstanceHandle(statementContext.getEpStatementHandle(), statementContext.getDefaultAgentInstanceLock(), -1, new StatementAgentInstanceFilterVersion(), statementContext.getFilterFaultHandlerFactory());
    }

    protected AgentInstanceContext getDefaultAgentInstanceContext(StatementContext statementContext) throws ExprValidationException {
        EPStatementAgentInstanceHandle handle = this.getDefaultAgentInstanceHandle(statementContext);
        return new AgentInstanceContext(statementContext, handle, -1, null, null, statementContext.getDefaultAgentInstanceScriptContext());
    }

    protected boolean isQueryPlanLogging(EPServicesContext services) {
        return services.getConfigSnapshot().getEngineDefaults().getLogging().isEnableQueryPlan();
    }
}

