/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.dataflow.core;

import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.client.dataflow.EPDataFlowExceptionContext;
import com.espertech.esper.client.dataflow.EPDataFlowExceptionHandler;
import com.espertech.esper.util.AuditPath;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPDataFlowEmitterExceptionHandler {
    private static final Log log = LogFactory.getLog(EPDataFlowEmitterExceptionHandler.class);
    private final String engineURI;
    private final String statementName;
    private final boolean audit;
    private final String dataFlowName;
    private final String operatorName;
    private final int operatorNumber;
    private final String operatorPrettyPrint;
    private final EPDataFlowExceptionHandler optionalExceptionHandler;

    public EPDataFlowEmitterExceptionHandler(String engineURI, String statementName, boolean audit, String dataFlowName, String operatorName, int operatorNumber, String operatorPrettyPrint, EPDataFlowExceptionHandler optionalExceptionHandler) {
        this.engineURI = engineURI;
        this.statementName = statementName;
        this.audit = audit;
        this.dataFlowName = dataFlowName;
        this.operatorName = operatorName;
        this.operatorNumber = operatorNumber;
        this.operatorPrettyPrint = operatorPrettyPrint;
        this.optionalExceptionHandler = optionalExceptionHandler;
    }

    public void handleException(Object targetObject, FastMethod fastMethod, InvocationTargetException ex, Object[] parameters) {
        log.error((Object)("Exception encountered: " + ex.getTargetException().getMessage()), ex.getTargetException());
        if (this.optionalExceptionHandler != null) {
            this.optionalExceptionHandler.handle(new EPDataFlowExceptionContext(this.dataFlowName, this.operatorName, this.operatorNumber, this.operatorPrettyPrint, ex.getTargetException()));
        }
    }

    public String getEngineURI() {
        return this.engineURI;
    }

    public String getStatementName() {
        return this.statementName;
    }

    public String getDataFlowName() {
        return this.dataFlowName;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public int getOperatorNumber() {
        return this.operatorNumber;
    }

    public String getOperatorPrettyPrint() {
        return this.operatorPrettyPrint;
    }

    public EPDataFlowExceptionHandler getOptionalExceptionHandler() {
        return this.optionalExceptionHandler;
    }

    public void handleAudit(Object targetObject, Object[] parameters) {
        if (this.audit) {
            AuditPath.auditLog(this.engineURI, this.statementName, AuditEnum.DATAFLOW_OP, "dataflow " + this.dataFlowName + " operator " + this.operatorName + "(" + this.operatorNumber + ") parameters " + Arrays.toString(parameters));
        }
    }
}

