/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.dataflow.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.dataflow.EPDataFlowSignalFinalMarker;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.dataflow.annotations.DataFlowContext;
import com.espertech.esper.dataflow.annotations.DataFlowOpParameter;
import com.espertech.esper.dataflow.annotations.DataFlowOperator;
import com.espertech.esper.dataflow.interfaces.DataFlowOpCloseContext;
import com.espertech.esper.dataflow.interfaces.DataFlowOpInitializateContext;
import com.espertech.esper.dataflow.interfaces.DataFlowOpInitializeResult;
import com.espertech.esper.dataflow.interfaces.DataFlowOpOpenContext;
import com.espertech.esper.dataflow.interfaces.DataFlowOpOutputPort;
import com.espertech.esper.dataflow.interfaces.DataFlowSourceOperator;
import com.espertech.esper.dataflow.interfaces.EPDataFlowEmitter;
import com.espertech.esper.dataflow.util.GraphTypeDesc;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.event.EventBeanManufacturer;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.util.TypeWidener;
import com.espertech.esper.util.TypeWidenerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@DataFlowOperator
public class BeaconSource
implements DataFlowSourceOperator {
    private static final Log log = LogFactory.getLog(BeaconSource.class);
    private static final List<String> PARAMETER_PROPERTIES = Arrays.asList("interval", "iterations", "initialDelay");
    @DataFlowContext
    private EPDataFlowEmitter graphContext;
    @DataFlowOpParameter
    private long iterations;
    @DataFlowOpParameter
    private double initialDelay;
    @DataFlowOpParameter
    private double interval;
    private Map<String, Object> allProperties = new LinkedHashMap<String, Object>();
    private long initialDelayMSec;
    private long periodDelayMSec;
    private long lastSendTime;
    private long iterationNumber;
    private boolean produceEventBean;
    private ExprEvaluator[] evaluators;
    private EventBeanManufacturer manufacturer;

    @DataFlowOpParameter(all=true)
    public void setProperty(String name, Object value) {
        this.allProperties.put(name, value);
    }

    @Override
    public DataFlowOpInitializeResult initialize(DataFlowOpInitializateContext context) throws Exception {
        this.initialDelayMSec = (long)(this.initialDelay * 1000.0);
        this.periodDelayMSec = (long)(this.interval * 1000.0);
        if (context.getOutputPorts().size() != 1) {
            throw new IllegalArgumentException("BeaconSource operator requires one output stream but produces " + context.getOutputPorts().size() + " streams");
        }
        DataFlowOpOutputPort port = context.getOutputPorts().get(0);
        if (port.getOptionalDeclaredType() != null && port.getOptionalDeclaredType().getEventType() != null) {
            EventType outputEventType = port.getOptionalDeclaredType().getEventType();
            this.produceEventBean = port.getOptionalDeclaredType() != null && !port.getOptionalDeclaredType().isUnderlying();
            Set<String> props = this.allProperties.keySet();
            props.removeAll(PARAMETER_PROPERTIES);
            WriteablePropertyDescriptor[] writables = BeaconSource.setupProperties(props.toArray(new String[props.size()]), outputEventType, context.getStatementContext());
            this.manufacturer = context.getServicesContext().getEventAdapterService().getManufacturer(outputEventType, writables, context.getServicesContext().getEngineImportService(), false);
            int index = 0;
            this.evaluators = new ExprEvaluator[writables.length];
            for (WriteablePropertyDescriptor writeable : writables) {
                final Object providedProperty = this.allProperties.get(writeable.getPropertyName());
                if (providedProperty instanceof ExprNode) {
                    ExprNode exprNode = (ExprNode)providedProperty;
                    ExprNode validated = ExprNodeUtility.validateSimpleGetSubtree(ExprNodeOrigin.DATAFLOWBEACON, exprNode, context.getStatementContext(), null, false);
                    final ExprEvaluator exprEvaluator = validated.getExprEvaluator();
                    final TypeWidener widener = TypeWidenerFactory.getCheckPropertyAssignType(ExprNodeUtility.toExpressionStringMinPrecedenceSafe(validated), exprEvaluator.getType(), writeable.getType(), writeable.getPropertyName());
                    this.evaluators[index] = widener != null ? new ExprEvaluator(){

                        @Override
                        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                            Object value = exprEvaluator.evaluate(eventsPerStream, isNewData, context);
                            return widener.widen(value);
                        }

                        @Override
                        public Class getType() {
                            return null;
                        }
                    } : exprEvaluator;
                } else {
                    this.evaluators[index] = providedProperty == null ? new ExprEvaluator(){

                        @Override
                        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                            return null;
                        }

                        @Override
                        public Class getType() {
                            return null;
                        }
                    } : new ExprEvaluator(){

                        @Override
                        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                            return providedProperty;
                        }

                        @Override
                        public Class getType() {
                            return providedProperty.getClass();
                        }
                    };
                }
                ++index;
            }
            return null;
        }
        String anonymousTypeName = context.getDataflowName() + "-beacon";
        LinkedHashMap<String, Object> types = new LinkedHashMap<String, Object>();
        Set<String> props = this.allProperties.keySet();
        props.removeAll(PARAMETER_PROPERTIES);
        int count = 0;
        this.evaluators = new ExprEvaluator[props.size()];
        for (String propertyName : props) {
            ExprNode exprNode = (ExprNode)this.allProperties.get(propertyName);
            ExprNode validated = ExprNodeUtility.validateSimpleGetSubtree(ExprNodeOrigin.DATAFLOWBEACON, exprNode, context.getStatementContext(), null, false);
            final Object value = validated.getExprEvaluator().evaluate(null, true, context.getAgentInstanceContext());
            if (value == null) {
                types.put(propertyName, null);
            } else {
                types.put(propertyName, value.getClass());
            }
            this.evaluators[count] = new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                    return value;
                }

                @Override
                public Class getType() {
                    return null;
                }
            };
            ++count;
        }
        EventType type = context.getServicesContext().getEventAdapterService().createAnonymousObjectArrayType(anonymousTypeName, types);
        return new DataFlowOpInitializeResult(new GraphTypeDesc[]{new GraphTypeDesc(false, true, type)});
    }

    @Override
    public void next() {
        long nsecDelta;
        long sleepTime;
        if (this.iterationNumber == 0L && this.initialDelayMSec > 0L) {
            try {
                Thread.sleep(this.initialDelayMSec, 0);
            }
            catch (InterruptedException e) {
                this.graphContext.submitSignal(new EPDataFlowSignalFinalMarker(){});
            }
        }
        if (this.iterationNumber > 0L && this.periodDelayMSec > 0L && (sleepTime = this.periodDelayMSec - (nsecDelta = this.lastSendTime - System.nanoTime()) / 1000000L) > 0L) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                this.graphContext.submitSignal(new EPDataFlowSignalFinalMarker(){});
            }
        }
        if (this.iterations > 0L && this.iterationNumber >= this.iterations) {
            this.graphContext.submitSignal(new EPDataFlowSignalFinalMarker(){});
        } else {
            ++this.iterationNumber;
            if (this.evaluators != null) {
                Object[] row = new Object[this.evaluators.length];
                for (int i = 0; i < row.length; ++i) {
                    if (this.evaluators[i] == null) continue;
                    row[i] = this.evaluators[i].evaluate(null, true, null);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("BeaconSource submitting row " + Arrays.toString(row)));
                }
                Object outputEvent = row;
                if (this.manufacturer != null) {
                    outputEvent = !this.produceEventBean ? this.manufacturer.makeUnderlying(row) : this.manufacturer.make(row);
                }
                this.graphContext.submit(outputEvent);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"BeaconSource submitting empty row");
                }
                this.graphContext.submit(new Object[0]);
            }
            if (this.interval > 0.0) {
                this.lastSendTime = System.nanoTime();
            }
        }
    }

    @Override
    public void open(DataFlowOpOpenContext openContext) {
    }

    @Override
    public void close(DataFlowOpCloseContext openContext) {
    }

    private static WriteablePropertyDescriptor[] setupProperties(String[] propertyNamesOffered, EventType outputEventType, StatementContext statementContext) throws ExprValidationException {
        Set<WriteablePropertyDescriptor> writeables = statementContext.getEventAdapterService().getWriteableProperties(outputEventType, false);
        ArrayList<WriteablePropertyDescriptor> writablesList = new ArrayList<WriteablePropertyDescriptor>();
        for (int i = 0; i < propertyNamesOffered.length; ++i) {
            String propertyName = propertyNamesOffered[i];
            WriteablePropertyDescriptor writable = EventTypeUtility.findWritable(propertyName, writeables);
            if (writable == null) {
                throw new ExprValidationException("Failed to find writable property '" + propertyName + "' for event type '" + outputEventType.getName() + "'");
            }
            writablesList.add(writable);
        }
        return writablesList.toArray(new WriteablePropertyDescriptor[writablesList.size()]);
    }
}

