/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.access;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.access.AggregationStateSorted;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public class AggregationAccessorSortedTable
implements AggregationAccessor {
    private final boolean max;
    private final Class componentType;
    private final TableMetadata tableMetadata;

    public AggregationAccessorSortedTable(boolean max, Class componentType, TableMetadata tableMetadata) {
        this.max = max;
        this.componentType = componentType;
        this.tableMetadata = tableMetadata;
    }

    @Override
    public Object getValue(AggregationState state, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationStateSorted sorted = (AggregationStateSorted)((Object)state);
        if (sorted.size() == 0) {
            return null;
        }
        Object array = Array.newInstance(this.componentType, sorted.size());
        Iterator<EventBean> it = this.max ? sorted.getReverseIterator() : sorted.iterator();
        int count = 0;
        while (it.hasNext()) {
            EventBean bean = it.next();
            Object[] und = this.tableMetadata.getEventToPublic().convertToUnd(bean, eventsPerStream, isNewData, exprEvaluatorContext);
            Array.set(array, count++, und);
        }
        return array;
    }

    @Override
    public Collection<EventBean> getEnumerableEvents(AggregationState state, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return ((AggregationStateSorted)((Object)state)).collectionReadOnly();
    }

    @Override
    public Collection<Object> getEnumerableScalar(AggregationState state, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return null;
    }

    @Override
    public EventBean getEnumerableEvent(AggregationState state, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return null;
    }
}

