/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.factory;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationAgent;
import com.espertech.esper.epl.agg.access.AggregationStateKey;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.aggregator.AggregatorAvg;
import com.espertech.esper.epl.agg.aggregator.AggregatorAvgBigDecimal;
import com.espertech.esper.epl.agg.aggregator.AggregatorAvgBigDecimalFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorAvgFilter;
import com.espertech.esper.epl.agg.factory.AggregationMethodFactoryUtil;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.methodagg.ExprAvgNode;
import com.espertech.esper.epl.expression.methodagg.ExprMethodAggUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class AggregationMethodFactoryAvg
implements AggregationMethodFactory {
    protected final ExprAvgNode parent;
    protected final Class childType;
    protected final Class resultType;
    protected final MathContext optionalMathContext;

    public AggregationMethodFactoryAvg(ExprAvgNode parent, Class childType, MathContext optionalMathContext) {
        this.parent = parent;
        this.childType = childType;
        this.resultType = this.getAvgAggregatorType(childType);
        this.optionalMathContext = optionalMathContext;
    }

    @Override
    public boolean isAccessAggregation() {
        return false;
    }

    @Override
    public Class getResultType() {
        return this.resultType;
    }

    @Override
    public AggregationStateKey getAggregationStateKey(boolean isMatchRecognize) {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationStateFactory getAggregationStateFactory(boolean isMatchRecognize) {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationAccessor getAccessor() {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationMethod make() {
        AggregationMethod method = this.makeAvgAggregator(this.childType, this.parent.isHasFilter(), this.optionalMathContext);
        if (!this.parent.isDistinct()) {
            return method;
        }
        return AggregationMethodFactoryUtil.makeDistinctAggregator(method, this.parent.isHasFilter());
    }

    @Override
    public ExprAggregateNodeBase getAggregationExpression() {
        return this.parent;
    }

    @Override
    public void validateIntoTableCompatible(AggregationMethodFactory intoTableAgg) throws ExprValidationException {
        com.espertech.esper.epl.agg.service.AggregationMethodFactoryUtil.validateAggregationType(this, intoTableAgg);
        AggregationMethodFactoryAvg that = (AggregationMethodFactoryAvg)intoTableAgg;
        com.espertech.esper.epl.agg.service.AggregationMethodFactoryUtil.validateAggregationInputType(this.childType, that.childType);
        com.espertech.esper.epl.agg.service.AggregationMethodFactoryUtil.validateAggregationFilter(this.parent.isHasFilter(), that.parent.isHasFilter());
    }

    @Override
    public AggregationAgent getAggregationStateAgent() {
        return null;
    }

    @Override
    public ExprEvaluator getMethodAggregationEvaluator(boolean join, EventType[] typesPerStream) throws ExprValidationException {
        return ExprMethodAggUtil.getDefaultEvaluator(this.parent.getPositionalParams(), join, typesPerStream);
    }

    private Class getAvgAggregatorType(Class type) {
        if (type == BigDecimal.class || type == BigInteger.class) {
            return BigDecimal.class;
        }
        return Double.class;
    }

    private AggregationMethod makeAvgAggregator(Class type, boolean hasFilter, MathContext optionalMathContext) {
        if (hasFilter) {
            if (type == BigDecimal.class || type == BigInteger.class) {
                return new AggregatorAvgBigDecimalFilter(optionalMathContext);
            }
            return new AggregatorAvgFilter();
        }
        if (type == BigDecimal.class || type == BigInteger.class) {
            return new AggregatorAvgBigDecimal(optionalMathContext);
        }
        return new AggregatorAvg();
    }
}

