/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.factory;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationAgent;
import com.espertech.esper.epl.agg.access.AggregationStateKey;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.aggregator.AggregatorRate;
import com.espertech.esper.epl.agg.aggregator.AggregatorRateEver;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationMethodFactoryUtil;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.methodagg.ExprMethodAggUtil;
import com.espertech.esper.epl.expression.methodagg.ExprRateAggNode;
import com.espertech.esper.schedule.TimeProvider;

public class AggregationMethodFactoryRate
implements AggregationMethodFactory {
    protected final ExprRateAggNode parent;
    protected final boolean isEver;
    protected final long intervalMSec;
    protected final TimeProvider timeProvider;

    public AggregationMethodFactoryRate(ExprRateAggNode parent, boolean isEver, long intervalMSec, TimeProvider timeProvider) {
        this.parent = parent;
        this.isEver = isEver;
        this.intervalMSec = intervalMSec;
        this.timeProvider = timeProvider;
    }

    @Override
    public boolean isAccessAggregation() {
        return false;
    }

    @Override
    public Class getResultType() {
        return Double.class;
    }

    @Override
    public AggregationStateKey getAggregationStateKey(boolean isMatchRecognize) {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationStateFactory getAggregationStateFactory(boolean isMatchRecognize) {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationAccessor getAccessor() {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationMethod make() {
        if (this.isEver) {
            return new AggregatorRateEver(this.intervalMSec, this.timeProvider);
        }
        return new AggregatorRate();
    }

    @Override
    public ExprAggregateNodeBase getAggregationExpression() {
        return this.parent;
    }

    @Override
    public void validateIntoTableCompatible(AggregationMethodFactory intoTableAgg) throws ExprValidationException {
        AggregationMethodFactoryUtil.validateAggregationType(this, intoTableAgg);
        AggregationMethodFactoryRate that = (AggregationMethodFactoryRate)intoTableAgg;
        if (this.intervalMSec != that.intervalMSec) {
            throw new ExprValidationException("The size is " + this.intervalMSec + " and provided is " + that.intervalMSec);
        }
        AggregationMethodFactoryUtil.validateAggregationUnbound(!this.isEver, !that.isEver);
    }

    @Override
    public AggregationAgent getAggregationStateAgent() {
        return null;
    }

    @Override
    public ExprEvaluator getMethodAggregationEvaluator(boolean join, EventType[] typesPerStream) throws ExprValidationException {
        return ExprMethodAggUtil.getDefaultEvaluator(this.parent.getPositionalParams(), join, typesPerStream);
    }
}

