/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.factory;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationAgent;
import com.espertech.esper.epl.agg.access.AggregationStateKey;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumBigDecimal;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumBigDecimalFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumBigInteger;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumBigIntegerFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumDouble;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumDoubleFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumFloat;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumFloatFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumInteger;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumIntegerFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumLong;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumLongFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumNumInteger;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumNumIntegerFilter;
import com.espertech.esper.epl.agg.factory.AggregationMethodFactoryUtil;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.methodagg.ExprMethodAggUtil;
import com.espertech.esper.epl.expression.methodagg.ExprSumNode;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AggregationMethodFactorySum
implements AggregationMethodFactory {
    protected final ExprSumNode parent;
    protected final Class resultType;
    protected final Class inputValueType;

    public AggregationMethodFactorySum(ExprSumNode parent, Class inputValueType) {
        this.parent = parent;
        this.inputValueType = inputValueType;
        this.resultType = this.getSumAggregatorType(inputValueType);
    }

    @Override
    public boolean isAccessAggregation() {
        return false;
    }

    @Override
    public AggregationStateKey getAggregationStateKey(boolean isMatchRecognize) {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationStateFactory getAggregationStateFactory(boolean isMatchRecognize) {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationAccessor getAccessor() {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public Class getResultType() {
        return this.resultType;
    }

    @Override
    public AggregationMethod make() {
        AggregationMethod method = this.makeSumAggregator(this.inputValueType, this.parent.isHasFilter());
        if (!this.parent.isDistinct()) {
            return method;
        }
        return AggregationMethodFactoryUtil.makeDistinctAggregator(method, this.parent.isHasFilter());
    }

    @Override
    public ExprAggregateNodeBase getAggregationExpression() {
        return this.parent;
    }

    @Override
    public void validateIntoTableCompatible(AggregationMethodFactory intoTableAgg) throws ExprValidationException {
        com.espertech.esper.epl.agg.service.AggregationMethodFactoryUtil.validateAggregationType(this, intoTableAgg);
        AggregationMethodFactorySum that = (AggregationMethodFactorySum)intoTableAgg;
        com.espertech.esper.epl.agg.service.AggregationMethodFactoryUtil.validateAggregationInputType(this.inputValueType, that.inputValueType);
        com.espertech.esper.epl.agg.service.AggregationMethodFactoryUtil.validateAggregationFilter(this.parent.isHasFilter(), that.parent.isHasFilter());
    }

    @Override
    public AggregationAgent getAggregationStateAgent() {
        return null;
    }

    @Override
    public ExprEvaluator getMethodAggregationEvaluator(boolean join, EventType[] typesPerStream) throws ExprValidationException {
        return ExprMethodAggUtil.getDefaultEvaluator(this.parent.getPositionalParams(), join, typesPerStream);
    }

    private Class getSumAggregatorType(Class type) {
        if (type == BigInteger.class) {
            return BigInteger.class;
        }
        if (type == BigDecimal.class) {
            return BigDecimal.class;
        }
        if (type == Long.class || type == Long.TYPE) {
            return Long.class;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.class;
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.class;
        }
        return Integer.class;
    }

    private AggregationMethod makeSumAggregator(Class type, boolean hasFilter) {
        if (!hasFilter) {
            if (type == BigInteger.class) {
                return new AggregatorSumBigInteger();
            }
            if (type == BigDecimal.class) {
                return new AggregatorSumBigDecimal();
            }
            if (type == Long.class || type == Long.TYPE) {
                return new AggregatorSumLong();
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return new AggregatorSumInteger();
            }
            if (type == Double.class || type == Double.TYPE) {
                return new AggregatorSumDouble();
            }
            if (type == Float.class || type == Float.TYPE) {
                return new AggregatorSumFloat();
            }
            return new AggregatorSumNumInteger();
        }
        if (type == BigInteger.class) {
            return new AggregatorSumBigIntegerFilter();
        }
        if (type == BigDecimal.class) {
            return new AggregatorSumBigDecimalFilter();
        }
        if (type == Long.class || type == Long.TYPE) {
            return new AggregatorSumLongFilter();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new AggregatorSumIntegerFilter();
        }
        if (type == Double.class || type == Double.TYPE) {
            return new AggregatorSumDoubleFilter();
        }
        if (type == Float.class || type == Float.TYPE) {
            return new AggregatorSumFloatFilter();
        }
        return new AggregatorSumNumIntegerFilter();
    }
}

