/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.BindProcessorEvaluatorStream;
import com.espertech.esper.epl.core.BindProcessorEvaluatorStreamTable;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.SelectClauseElementCompiled;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableService;
import java.util.ArrayList;

public class BindProcessor {
    private ExprEvaluator[] expressionNodes;
    private Class[] expressionTypes;
    private String[] columnNamesAssigned;

    public BindProcessor(SelectClauseElementCompiled[] selectionList, EventType[] typesPerStream, String[] streamNames, TableService tableService) throws ExprValidationException {
        ArrayList<ExprEvaluator> expressions = new ArrayList<ExprEvaluator>();
        ArrayList<Class> types = new ArrayList<Class>();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (SelectClauseElementCompiled element : selectionList) {
            if (element instanceof SelectClauseElementWildcard) {
                for (int i = 0; i < typesPerStream.length; ++i) {
                    Class returnType = typesPerStream[i].getUnderlyingType();
                    TableMetadata tableMetadata = tableService.getTableMetadataFromEventType(typesPerStream[i]);
                    ExprEvaluator evaluator = tableMetadata != null ? new BindProcessorEvaluatorStreamTable(i, returnType, tableMetadata) : new BindProcessorEvaluatorStream(i, returnType);
                    expressions.add(evaluator);
                    types.add(returnType);
                    columnNames.add(streamNames[i]);
                }
                continue;
            }
            if (element instanceof SelectClauseStreamCompiledSpec) {
                SelectClauseStreamCompiledSpec streamSpec = (SelectClauseStreamCompiledSpec)element;
                EventType type = typesPerStream[streamSpec.getStreamNumber()];
                Class returnType = type.getUnderlyingType();
                TableMetadata tableMetadata = tableService.getTableMetadataFromEventType(type);
                ExprEvaluator evaluator = tableMetadata != null ? new BindProcessorEvaluatorStreamTable(streamSpec.getStreamNumber(), returnType, tableMetadata) : new BindProcessorEvaluatorStream(streamSpec.getStreamNumber(), returnType);
                expressions.add(evaluator);
                types.add(returnType);
                columnNames.add(streamNames[streamSpec.getStreamNumber()]);
                continue;
            }
            if (element instanceof SelectClauseExprCompiledSpec) {
                SelectClauseExprCompiledSpec expr = (SelectClauseExprCompiledSpec)element;
                ExprEvaluator evaluator = expr.getSelectExpression().getExprEvaluator();
                expressions.add(evaluator);
                types.add(evaluator.getType());
                if (expr.getAssignedName() != null) {
                    columnNames.add(expr.getAssignedName());
                    continue;
                }
                columnNames.add(ExprNodeUtility.toExpressionStringMinPrecedenceSafe(expr.getSelectExpression()));
                continue;
            }
            throw new IllegalStateException("Unrecognized select expression element of type " + element.getClass());
        }
        this.expressionNodes = expressions.toArray(new ExprEvaluator[expressions.size()]);
        this.expressionTypes = types.toArray(new Class[types.size()]);
        this.columnNamesAssigned = columnNames.toArray(new String[columnNames.size()]);
    }

    public Object[] process(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] parameters = new Object[this.expressionNodes.length];
        for (int i = 0; i < parameters.length; ++i) {
            Object result;
            parameters[i] = result = this.expressionNodes[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        return parameters;
    }

    public Class[] getExpressionTypes() {
        return this.expressionTypes;
    }

    public String[] getColumnNamesAssigned() {
        return this.columnNamesAssigned;
    }
}

