/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.epl.core.OrderByProcessorFactory;
import com.espertech.esper.epl.core.OrderByProcessorFactoryImpl;
import com.espertech.esper.epl.core.OrderByProcessorOrderedLimitFactory;
import com.espertech.esper.epl.core.OrderByProcessorRowLimitOnlyFactory;
import com.espertech.esper.epl.core.RowLimitProcessorFactory;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeUtil;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.OrderByItem;
import com.espertech.esper.epl.spec.RowLimitSpec;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.variable.VariableService;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderByProcessorFactoryFactory {
    private static final Log log = LogFactory.getLog(OrderByProcessorFactoryFactory.class);

    public static OrderByProcessorFactory getProcessor(List<SelectClauseExprCompiledSpec> selectionList, ExprNode[] groupByNodes, List<OrderByItem> orderByList, RowLimitSpec rowLimitSpec, VariableService variableService, boolean isSortUsingCollator, String optionalContextName) throws ExprValidationException {
        ArrayList<ExprNode> orderByNodes = new ArrayList<ExprNode>();
        for (OrderByItem element : orderByList) {
            orderByNodes.add(element.getExprNode());
        }
        if (orderByList.isEmpty()) {
            log.debug((Object)".getProcessor Using no OrderByProcessor");
            if (rowLimitSpec != null) {
                RowLimitProcessorFactory rowLimitProcessorFactory = new RowLimitProcessorFactory(rowLimitSpec, variableService, optionalContextName);
                return new OrderByProcessorRowLimitOnlyFactory(rowLimitProcessorFactory);
            }
            return null;
        }
        LinkedList<ExprAggregateNode> selectAggNodes = new LinkedList<ExprAggregateNode>();
        for (SelectClauseExprCompiledSpec element : selectionList) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(element.getSelectExpression(), selectAggNodes);
        }
        LinkedList<ExprAggregateNode> orderAggNodes = new LinkedList<ExprAggregateNode>();
        for (ExprNode orderByNode : orderByNodes) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(orderByNode, orderAggNodes);
        }
        OrderByProcessorFactoryFactory.validateOrderByAggregates(selectAggNodes, orderAggNodes);
        boolean needsGroupByKeys = !selectionList.isEmpty() && !orderAggNodes.isEmpty();
        log.debug((Object)".getProcessor Using OrderByProcessorImpl");
        OrderByProcessorFactoryImpl orderByProcessorFactory = new OrderByProcessorFactoryImpl(orderByList, groupByNodes, needsGroupByKeys, isSortUsingCollator);
        if (rowLimitSpec == null) {
            return orderByProcessorFactory;
        }
        RowLimitProcessorFactory rowLimitProcessorFactory = new RowLimitProcessorFactory(rowLimitSpec, variableService, optionalContextName);
        return new OrderByProcessorOrderedLimitFactory(orderByProcessorFactory, rowLimitProcessorFactory);
    }

    private static void validateOrderByAggregates(List<ExprAggregateNode> selectAggNodes, List<ExprAggregateNode> orderAggNodes) throws ExprValidationException {
        for (ExprAggregateNode orderAgg : orderAggNodes) {
            boolean inSelect = false;
            for (ExprAggregateNode selectAgg : selectAggNodes) {
                if (!ExprNodeUtility.deepEquals(selectAgg, orderAgg)) continue;
                inSelect = true;
                break;
            }
            if (inSelect) continue;
            throw new ExprValidationException("Aggregate functions in the order-by clause must also occur in the select expression");
        }
    }
}

