/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.rollup.GroupByRollupKey;
import com.espertech.esper.epl.core.OrderByElement;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.OrderByProcessorImpl;
import com.espertech.esper.epl.core.RowLimitProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.util.List;

public class OrderByProcessorOrderedLimit
implements OrderByProcessor {
    private final OrderByProcessorImpl orderByProcessor;
    private final RowLimitProcessor rowLimitProcessor;

    public OrderByProcessorOrderedLimit(OrderByProcessorImpl orderByProcessor, RowLimitProcessor rowLimitProcessor) {
        this.orderByProcessor = orderByProcessor;
        this.rowLimitProcessor = rowLimitProcessor;
    }

    @Override
    public EventBean[] sort(EventBean[] outgoingEvents, EventBean[][] generatingEvents, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        this.rowLimitProcessor.determineCurrentLimit();
        if (this.rowLimitProcessor.getCurrentRowLimit() == 1 && this.rowLimitProcessor.getCurrentOffset() == 0 && outgoingEvents != null && outgoingEvents.length > 1) {
            EventBean minmax = this.orderByProcessor.determineLocalMinMax(outgoingEvents, generatingEvents, isNewData, exprEvaluatorContext);
            return new EventBean[]{minmax};
        }
        EventBean[] sorted = this.orderByProcessor.sort(outgoingEvents, generatingEvents, isNewData, exprEvaluatorContext);
        return this.rowLimitProcessor.applyLimit(sorted);
    }

    @Override
    public EventBean[] sort(EventBean[] outgoingEvents, List<GroupByRollupKey> currentGenerators, boolean newData, AgentInstanceContext agentInstanceContext, OrderByElement[][] elementsPerLevel) {
        EventBean[] sorted = this.orderByProcessor.sort(outgoingEvents, currentGenerators, newData, agentInstanceContext, elementsPerLevel);
        return this.rowLimitProcessor.determineLimitAndApply(sorted);
    }

    @Override
    public EventBean[] sort(EventBean[] outgoingEvents, EventBean[][] generatingEvents, Object[] groupByKeys, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean[] sorted = this.orderByProcessor.sort(outgoingEvents, generatingEvents, groupByKeys, isNewData, exprEvaluatorContext);
        return this.rowLimitProcessor.determineLimitAndApply(sorted);
    }

    @Override
    public Object getSortKey(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.orderByProcessor.getSortKey(eventsPerStream, isNewData, exprEvaluatorContext);
    }

    @Override
    public Object getSortKey(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext, OrderByElement[] elementsForLevel) {
        return this.orderByProcessor.getSortKey(eventsPerStream, isNewData, exprEvaluatorContext, elementsForLevel);
    }

    @Override
    public Object[] getSortKeyPerRow(EventBean[] generatingEvents, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.orderByProcessor.getSortKeyPerRow(generatingEvents, isNewData, exprEvaluatorContext);
    }

    @Override
    public EventBean[] sort(EventBean[] outgoingEvents, Object[] orderKeys, ExprEvaluatorContext exprEvaluatorContext) {
        this.rowLimitProcessor.determineCurrentLimit();
        if (this.rowLimitProcessor.getCurrentRowLimit() == 1 && this.rowLimitProcessor.getCurrentOffset() == 0 && outgoingEvents != null && outgoingEvents.length > 1) {
            EventBean minmax = this.orderByProcessor.determineLocalMinMax(outgoingEvents, orderKeys);
            return new EventBean[]{minmax};
        }
        EventBean[] sorted = this.orderByProcessor.sort(outgoingEvents, orderKeys, exprEvaluatorContext);
        return this.rowLimitProcessor.applyLimit(sorted);
    }
}

