/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateGrouped;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateGroupedOutputAllHelper;
import com.espertech.esper.event.EventBeanUtility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResultSetProcessorAggregateGroupedOutputAllHelperImpl
implements ResultSetProcessorAggregateGroupedOutputAllHelper {
    private final ResultSetProcessorAggregateGrouped processor;
    private final List<EventBean> eventsOld = new ArrayList<EventBean>(2);
    private final List<EventBean> eventsNew = new ArrayList<EventBean>(2);
    private final Map<Object, EventBean[]> repsPerGroup = new LinkedHashMap<Object, EventBean[]>();
    private final Set<Object> lastSeenKeys = new HashSet<Object>();

    public ResultSetProcessorAggregateGroupedOutputAllHelperImpl(ResultSetProcessorAggregateGrouped processor) {
        this.processor = processor;
    }

    @Override
    public void processView(EventBean[] newData, EventBean[] oldData, boolean isGenerateSynthetic) {
        int count;
        Object[] newDataMultiKey = this.processor.generateGroupKeys(newData, true);
        Object[] oldDataMultiKey = this.processor.generateGroupKeys(oldData, false);
        HashSet<Object> keysSeenRemoved = new HashSet<Object>();
        if (newData != null) {
            count = 0;
            for (EventBean aNewData : newData) {
                EventBean[] eventsPerStream = new EventBean[]{aNewData};
                Object mk = newDataMultiKey[count];
                this.repsPerGroup.put(mk, eventsPerStream);
                this.lastSeenKeys.add(mk);
                this.processor.eventsPerStreamOneStream[0] = aNewData;
                this.processor.aggregationService.applyEnter(eventsPerStream, mk, this.processor.agentInstanceContext);
                ++count;
            }
        }
        if (oldData != null) {
            count = 0;
            for (EventBean anOldData : oldData) {
                Object mk = oldDataMultiKey[count];
                this.lastSeenKeys.add(mk);
                keysSeenRemoved.add(mk);
                this.processor.eventsPerStreamOneStream[0] = anOldData;
                this.processor.aggregationService.applyLeave(this.processor.eventsPerStreamOneStream, oldDataMultiKey[count], this.processor.agentInstanceContext);
                ++count;
            }
        }
        if (this.processor.prototype.isSelectRStream()) {
            this.processor.generateOutputBatchedViewUnkeyed(oldData, oldDataMultiKey, false, isGenerateSynthetic, this.eventsOld, null);
        }
        this.processor.generateOutputBatchedViewUnkeyed(newData, newDataMultiKey, true, isGenerateSynthetic, this.eventsNew, null);
        for (Object e : keysSeenRemoved) {
            EventBean newEvent = this.processor.generateOutputBatchedSingle(e, this.repsPerGroup.get(e), true, isGenerateSynthetic);
            if (newEvent == null) continue;
            this.eventsNew.add(newEvent);
        }
    }

    @Override
    public void processJoin(Set<MultiKey<EventBean>> newData, Set<MultiKey<EventBean>> oldData, boolean isGenerateSynthetic) {
        Object mk;
        int count;
        Object[] newDataMultiKey = this.processor.generateGroupKeys(newData, true);
        Object[] oldDataMultiKey = this.processor.generateGroupKeys(oldData, false);
        HashSet<Object> keysSeenRemoved = new HashSet<Object>();
        if (newData != null) {
            count = 0;
            for (MultiKey<EventBean> aNewData : newData) {
                mk = newDataMultiKey[count];
                this.repsPerGroup.put(mk, aNewData.getArray());
                this.lastSeenKeys.add(mk);
                this.processor.aggregationService.applyEnter(aNewData.getArray(), mk, this.processor.agentInstanceContext);
                ++count;
            }
        }
        if (oldData != null) {
            count = 0;
            for (MultiKey<EventBean> anOldData : oldData) {
                mk = oldDataMultiKey[count];
                this.lastSeenKeys.add(mk);
                keysSeenRemoved.add(mk);
                this.processor.aggregationService.applyLeave(anOldData.getArray(), oldDataMultiKey[count], this.processor.agentInstanceContext);
                ++count;
            }
        }
        if (this.processor.prototype.isSelectRStream()) {
            this.processor.generateOutputBatchedJoinUnkeyed(oldData, oldDataMultiKey, false, isGenerateSynthetic, this.eventsOld, null);
        }
        this.processor.generateOutputBatchedJoinUnkeyed(newData, newDataMultiKey, false, isGenerateSynthetic, this.eventsNew, null);
        for (Object e : keysSeenRemoved) {
            EventBean newEvent = this.processor.generateOutputBatchedSingle(e, this.repsPerGroup.get(e), true, isGenerateSynthetic);
            if (newEvent == null) continue;
            this.eventsNew.add(newEvent);
        }
    }

    @Override
    public UniformPair<EventBean[]> outputView(boolean isSynthesize) {
        return this.output(isSynthesize);
    }

    @Override
    public UniformPair<EventBean[]> outputJoin(boolean isSynthesize) {
        return this.output(isSynthesize);
    }

    @Override
    public void remove(Object key) {
        this.repsPerGroup.remove(key);
    }

    @Override
    public void destroy() {
    }

    private UniformPair<EventBean[]> output(boolean isSynthesize) {
        for (Map.Entry<Object, EventBean[]> entry : this.repsPerGroup.entrySet()) {
            EventBean newEvent;
            if (this.lastSeenKeys.contains(entry.getKey()) || (newEvent = this.processor.generateOutputBatchedSingle(entry.getKey(), entry.getValue(), true, isSynthesize)) == null) continue;
            this.eventsNew.add(newEvent);
        }
        this.lastSeenKeys.clear();
        EventBean[] newEventsArr = EventBeanUtility.toArray(this.eventsNew);
        EventBean[] oldEventsArr = null;
        if (this.processor.prototype.isSelectRStream()) {
            oldEventsArr = EventBeanUtility.toArray(this.eventsOld);
        }
        this.eventsNew.clear();
        this.eventsOld.clear();
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }
}

