/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.client.annotation.HookType;
import com.espertech.esper.client.annotation.IterableUnbound;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.ContextPropertyRegistry;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.agg.rollup.GroupByRollupPerLevelExpression;
import com.espertech.esper.epl.agg.rollup.GroupByRollupPlanDesc;
import com.espertech.esper.epl.agg.rollup.GroupByRollupPlanHook;
import com.espertech.esper.epl.agg.service.AggregationGroupByRollupDesc;
import com.espertech.esper.epl.agg.service.AggregationGroupByRollupLevel;
import com.espertech.esper.epl.agg.service.AggregationServiceFactoryDesc;
import com.espertech.esper.epl.agg.service.AggregationServiceFactoryFactory;
import com.espertech.esper.epl.annotation.AnnotationUtil;
import com.espertech.esper.epl.core.ColumnNamedNodeSwapper;
import com.espertech.esper.epl.core.GroupByRollupInfo;
import com.espertech.esper.epl.core.OrderByElement;
import com.espertech.esper.epl.core.OrderByProcessorFactory;
import com.espertech.esper.epl.core.OrderByProcessorFactoryFactory;
import com.espertech.esper.epl.core.PropertyResolutionDescriptor;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateAllFactory;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateGroupedFactory;
import com.espertech.esper.epl.core.ResultSetProcessorFactory;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryDesc;
import com.espertech.esper.epl.core.ResultSetProcessorHandThroughFactory;
import com.espertech.esper.epl.core.ResultSetProcessorHelperFactory;
import com.espertech.esper.epl.core.ResultSetProcessorRowForAllFactory;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroupFactory;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroupRollupFactory;
import com.espertech.esper.epl.core.ResultSetProcessorSimpleFactory;
import com.espertech.esper.epl.core.SelectExprEventTypeRegistry;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.SelectExprProcessorDeliveryCallback;
import com.espertech.esper.epl.core.SelectExprProcessorFactory;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.core.StreamTypesException;
import com.espertech.esper.epl.core.ViewResourceDelegateUnverified;
import com.espertech.esper.epl.declexpr.ExprDeclaredNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeGroupKey;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeUtil;
import com.espertech.esper.epl.expression.core.ExprConstantNodeImpl;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprGroupingIdNode;
import com.espertech.esper.epl.expression.core.ExprGroupingNode;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodePropOrStreamDesc;
import com.espertech.esper.epl.expression.core.ExprNodePropOrStreamExprDesc;
import com.espertech.esper.epl.expression.core.ExprNodePropOrStreamPropDesc;
import com.espertech.esper.epl.expression.core.ExprNodePropOrStreamSet;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.prev.ExprPreviousNode;
import com.espertech.esper.epl.expression.prior.ExprPriorNode;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.expression.visitor.ExprNodeDeclaredVisitor;
import com.espertech.esper.epl.expression.visitor.ExprNodeGroupingVisitorWParent;
import com.espertech.esper.epl.expression.visitor.ExprNodeIdentifierAndStreamRefVisitor;
import com.espertech.esper.epl.expression.visitor.ExprNodeIdentifierCollectVisitorWContainer;
import com.espertech.esper.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.epl.spec.DBStatementStreamSpec;
import com.espertech.esper.epl.spec.GroupByClauseExpressions;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.epl.spec.MethodStreamSpec;
import com.espertech.esper.epl.spec.OrderByItem;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.spec.SelectClauseElementCompiled;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseSpecCompiled;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.spec.TableQueryStreamSpec;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.view.OutputConditionPolledFactory;
import com.espertech.esper.epl.view.OutputConditionPolledFactoryFactory;
import com.espertech.esper.event.NativeEventType;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetProcessorFactoryFactory {
    private static final Log log = LogFactory.getLog(ResultSetProcessorFactoryFactory.class);

    public static ResultSetProcessorFactoryDesc getProcessorPrototype(StatementSpecCompiled statementSpec, StatementContext stmtContext, StreamTypeService typeService, ViewResourceDelegateUnverified viewResourceDelegate, boolean[] isUnidirectionalStream, boolean allowAggregation, ContextPropertyRegistry contextPropertyRegistry, SelectExprProcessorDeliveryCallback selectExprProcessorCallback, ConfigurationInformation configurationInformation, ResultSetProcessorHelperFactory resultSetProcessorHelperFactory, boolean isFireAndForget, boolean isOnSelect) throws ExprValidationException {
        ExprNodePropOrStreamSet nonAggregatedPropsOrderBy;
        boolean allInSelect;
        String reasonMessage;
        boolean isFirst;
        boolean isSelectRStream;
        boolean hasAggregation;
        GroupByRollupInfo groupByRollupInfo;
        StreamSpecCompiled spec;
        OrderByItem[] orderByListUnexpanded = statementSpec.getOrderByList();
        SelectClauseSpecCompiled selectClauseSpec = statementSpec.getSelectClauseSpec();
        InsertIntoDesc insertIntoDesc = statementSpec.getInsertIntoDesc();
        ExprNode optionalHavingNode = statementSpec.getHavingExprRootNode();
        OutputLimitSpec outputLimitSpec = statementSpec.getOutputLimitSpec();
        ArrayList<ExprDeclaredNode> declaredNodes = new ArrayList<ExprDeclaredNode>();
        ResultSetProcessorFactoryFactory.validateOutputLimit(outputLimitSpec, stmtContext);
        boolean isUnidirectional = false;
        for (int i = 0; i < isUnidirectionalStream.length; ++i) {
            isUnidirectional |= isUnidirectionalStream[i];
        }
        boolean isHistoricalOnly = false;
        if (statementSpec.getStreamSpecs().length == 1 && ((spec = statementSpec.getStreamSpecs()[0]) instanceof DBStatementStreamSpec || spec instanceof MethodStreamSpec || spec instanceof TableQueryStreamSpec)) {
            isHistoricalOnly = true;
        }
        int numStreams = typeService.getEventTypes().length;
        List<OrderByItem> orderByList = ResultSetProcessorFactoryFactory.expandColumnNames(selectClauseSpec.getSelectExprList(), orderByListUnexpanded);
        LinkedList<SelectClauseExprCompiledSpec> namedSelectionList = new LinkedList<SelectClauseExprCompiledSpec>();
        ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(stmtContext, false);
        boolean allowRollup = statementSpec.getGroupByExpressions() != null && statementSpec.getGroupByExpressions().getGroupByRollupLevels() != null;
        boolean resettableAggs = isUnidirectional || statementSpec.getOnTriggerDesc() != null;
        String intoTableName = statementSpec.getIntoTableSpec() == null ? null : statementSpec.getIntoTableSpec().getName();
        ExprValidationContext validationContext = new ExprValidationContext(typeService, stmtContext.getEngineImportService(), stmtContext.getStatementExtensionServicesContext(), viewResourceDelegate, stmtContext.getSchedulingService(), stmtContext.getVariableService(), stmtContext.getTableService(), evaluatorContextStmt, stmtContext.getEventAdapterService(), stmtContext.getStatementName(), stmtContext.getStatementId(), stmtContext.getAnnotations(), stmtContext.getContextDescriptor(), false, allowRollup, true, resettableAggs, intoTableName, false);
        ResultSetProcessorFactoryFactory.validateSelectAssignColNames(selectClauseSpec, namedSelectionList, validationContext);
        if (statementSpec.getGroupByExpressions() != null && statementSpec.getGroupByExpressions().getSelectClausePerLevel() != null) {
            ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.GROUPBY, statementSpec.getGroupByExpressions().getSelectClausePerLevel(), validationContext);
        }
        boolean isUsingWildcard = selectClauseSpec.isUsingWildcard();
        boolean isUsingStreamSelect = false;
        for (SelectClauseElementCompiled compiled : selectClauseSpec.getSelectExprList()) {
            if (!(compiled instanceof SelectClauseStreamCompiledSpec)) continue;
            SelectClauseStreamCompiledSpec streamSelectSpec = (SelectClauseStreamCompiledSpec)compiled;
            int streamNum = Integer.MIN_VALUE;
            boolean isFragmentEvent = false;
            boolean isProperty = false;
            Class propertyType = null;
            isUsingStreamSelect = true;
            for (int i = 0; i < typeService.getStreamNames().length; ++i) {
                String streamName = streamSelectSpec.getStreamName();
                if (typeService.getStreamNames()[i].equals(streamName)) {
                    streamNum = i;
                    break;
                }
                EventType candidateProviderOfFragments = typeService.getEventTypes()[i];
                if (candidateProviderOfFragments instanceof NativeEventType || candidateProviderOfFragments.getFragmentType(streamName) == null) continue;
                streamNum = i;
                isFragmentEvent = true;
                break;
            }
            if (streamNum == Integer.MIN_VALUE) {
                PropertyResolutionDescriptor desc = null;
                try {
                    desc = typeService.resolveByPropertyName(streamSelectSpec.getStreamName(), false);
                }
                catch (StreamTypesException e) {
                    // empty catch block
                }
                if (desc == null) {
                    throw new ExprValidationException("Stream selector '" + streamSelectSpec.getStreamName() + ".*' does not match any stream name in the from clause");
                }
                isProperty = true;
                propertyType = desc.getPropertyType();
                streamNum = desc.getStreamNum();
            }
            streamSelectSpec.setStreamNumber(streamNum);
            streamSelectSpec.setFragmentEvent(isFragmentEvent);
            streamSelectSpec.setProperty(isProperty, propertyType);
            if (streamNum < 0) continue;
            TableMetadata tableMetadata = stmtContext.getTableService().getTableMetadataFromEventType(typeService.getEventTypes()[streamNum]);
            streamSelectSpec.setTableMetadata(tableMetadata);
        }
        if (optionalHavingNode != null) {
            optionalHavingNode = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.HAVING, optionalHavingNode, validationContext);
            if (statementSpec.getGroupByExpressions() != null) {
                ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.GROUPBY, statementSpec.getGroupByExpressions().getOptHavingNodePerLevel(), validationContext);
            }
        }
        for (int i = 0; i < orderByList.size(); ++i) {
            ExprNode orderByNode = orderByList.get(i).getExprNode();
            ExprNodeSubselectDeclaredDotVisitor visitor = new ExprNodeSubselectDeclaredDotVisitor();
            orderByNode.accept(visitor);
            if (visitor.getSubselects().size() > 0) {
                throw new ExprValidationException("Subselects not allowed within order-by clause");
            }
            Boolean isDescending = orderByList.get(i).isDescending();
            OrderByItem validatedOrderBy = new OrderByItem(ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.ORDERBY, orderByNode, validationContext), isDescending);
            orderByList.set(i, validatedOrderBy);
            if (statementSpec.getGroupByExpressions() == null || statementSpec.getGroupByExpressions().getOptOrderByPerLevel() == null) continue;
            ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.GROUPBY, statementSpec.getGroupByExpressions().getOptOrderByPerLevel(), validationContext);
        }
        ArrayList<ExprNode> selectNodes = new ArrayList<ExprNode>();
        for (SelectClauseExprCompiledSpec element : namedSelectionList) {
            selectNodes.add(element.getSelectExpression());
        }
        ArrayList<ExprNode> orderByNodes = new ArrayList<ExprNode>();
        for (OrderByItem element : orderByList) {
            orderByNodes.add(element.getExprNode());
        }
        LinkedList<ExprAggregateNode> selectAggregateExprNodes = new LinkedList<ExprAggregateNode>();
        HashMap<ExprNode, String> selectAggregationNodesNamed = new HashMap<ExprNode, String>();
        ExprNodeDeclaredVisitor declaredNodeVisitor = new ExprNodeDeclaredVisitor();
        for (SelectClauseExprCompiledSpec element : namedSelectionList) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(element.getSelectExpression(), selectAggregateExprNodes);
            if (element.getProvidedName() != null) {
                selectAggregationNodesNamed.put(element.getSelectExpression(), element.getProvidedName());
            }
            element.getSelectExpression().accept(declaredNodeVisitor);
            declaredNodes.addAll(declaredNodeVisitor.getDeclaredExpressions());
            declaredNodeVisitor.clear();
        }
        if (statementSpec.getGroupByExpressions() != null) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(statementSpec.getGroupByExpressions().getSelectClausePerLevel(), selectAggregateExprNodes);
        }
        if (!allowAggregation && !selectAggregateExprNodes.isEmpty()) {
            throw new ExprValidationException("Aggregation functions are not allowed in this context");
        }
        LinkedList<ExprAggregateNode> havingAggregateExprNodes = new LinkedList<ExprAggregateNode>();
        ExprNodePropOrStreamSet propertiesAggregatedHaving = new ExprNodePropOrStreamSet();
        if (optionalHavingNode != null) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(optionalHavingNode, havingAggregateExprNodes);
            if (statementSpec.getGroupByExpressions() != null) {
                ExprAggregateNodeUtil.getAggregatesBottomUp(statementSpec.getGroupByExpressions().getOptHavingNodePerLevel(), havingAggregateExprNodes);
            }
            propertiesAggregatedHaving = ExprNodeUtility.getAggregatedProperties(havingAggregateExprNodes);
        }
        if (!allowAggregation && !havingAggregateExprNodes.isEmpty()) {
            throw new ExprValidationException("Aggregation functions are not allowed in this context");
        }
        LinkedList<ExprAggregateNode> orderByAggregateExprNodes = new LinkedList<ExprAggregateNode>();
        if (orderByNodes != null && !orderByNodes.isEmpty()) {
            for (ExprNode orderByNode : orderByNodes) {
                ExprAggregateNodeUtil.getAggregatesBottomUp(orderByNode, orderByAggregateExprNodes);
            }
            if (statementSpec.getGroupByExpressions() != null) {
                ExprAggregateNodeUtil.getAggregatesBottomUp(statementSpec.getGroupByExpressions().getOptOrderByPerLevel(), orderByAggregateExprNodes);
            }
            if (!allowAggregation && !orderByAggregateExprNodes.isEmpty()) {
                throw new ExprValidationException("Aggregation functions are not allowed in this context");
            }
        }
        ExprNode[] groupByNodesValidated = (groupByRollupInfo = ResultSetProcessorFactoryFactory.analyzeValidateGroupBy(statementSpec.getGroupByExpressions(), validationContext)) == null ? new ExprNode[]{} : groupByRollupInfo.getExprNodes();
        AggregationGroupByRollupDesc groupByRollupDesc = groupByRollupInfo == null ? null : groupByRollupInfo.getRollupDesc();
        boolean hasGroupBy = groupByNodesValidated.length > 0;
        AggregationServiceFactoryDesc aggregationServiceFactory = AggregationServiceFactoryFactory.getService(selectAggregateExprNodes, selectAggregationNodesNamed, declaredNodes, groupByNodesValidated, havingAggregateExprNodes, orderByAggregateExprNodes, Collections.<ExprAggregateNodeGroupKey>emptyList(), hasGroupBy, statementSpec.getAnnotations(), stmtContext.getVariableService(), typeService.getEventTypes().length > 1, false, statementSpec.getFilterRootNode(), statementSpec.getHavingExprRootNode(), stmtContext.getAggregationServiceFactoryService(), typeService.getEventTypes(), groupByRollupDesc, statementSpec.getOptionalContextName(), statementSpec.getIntoTableSpec(), stmtContext.getTableService(), isUnidirectional, isFireAndForget, isOnSelect);
        boolean localGroupByMatchesGroupBy = ResultSetProcessorFactoryFactory.analyzeLocalGroupBy(groupByNodesValidated, selectAggregateExprNodes, havingAggregateExprNodes, orderByAggregateExprNodes);
        boolean useCollatorSort = false;
        if (stmtContext.getConfigSnapshot() != null) {
            useCollatorSort = stmtContext.getConfigSnapshot().getEngineDefaults().getLanguage().isSortUsingCollator();
        }
        OrderByProcessorFactory orderByProcessorFactory = OrderByProcessorFactoryFactory.getProcessor(namedSelectionList, groupByNodesValidated, orderByList, statementSpec.getRowLimitSpec(), stmtContext.getVariableService(), useCollatorSort, statementSpec.getOptionalContextName());
        SelectExprEventTypeRegistry selectExprEventTypeRegistry = new SelectExprEventTypeRegistry(stmtContext.getStatementName(), stmtContext.getStatementEventTypeRef());
        SelectExprProcessor selectExprProcessor = SelectExprProcessorFactory.getProcessor(Collections.<Integer>emptyList(), selectClauseSpec.getSelectExprList(), isUsingWildcard, insertIntoDesc, null, statementSpec.getForClauseSpec(), typeService, stmtContext.getEventAdapterService(), stmtContext.getStatementResultService(), stmtContext.getValueAddEventService(), selectExprEventTypeRegistry, stmtContext.getEngineImportService(), evaluatorContextStmt, stmtContext.getVariableService(), stmtContext.getTableService(), stmtContext.getTimeProvider(), stmtContext.getEngineURI(), stmtContext.getStatementId(), stmtContext.getStatementName(), stmtContext.getAnnotations(), stmtContext.getContextDescriptor(), stmtContext.getConfigSnapshot(), selectExprProcessorCallback, stmtContext.getNamedWindowMgmtService(), statementSpec.getIntoTableSpec(), groupByRollupInfo, stmtContext.getStatementExtensionServicesContext());
        ExprNodePropOrStreamSet propertiesGroupBy = ExprNodeUtility.getGroupByPropertiesValidateHasOne(groupByNodesValidated);
        ExprNodePropOrStreamSet nonAggregatedPropsSelect = ExprNodeUtility.getNonAggregatedProps(typeService.getEventTypes(), selectNodes, contextPropertyRegistry);
        if (optionalHavingNode != null) {
            ExprNodeUtility.addNonAggregatedProps(optionalHavingNode, nonAggregatedPropsSelect, typeService.getEventTypes(), contextPropertyRegistry);
        }
        boolean bl = hasAggregation = !selectAggregateExprNodes.isEmpty() || !havingAggregateExprNodes.isEmpty() || !orderByAggregateExprNodes.isEmpty() || !propertiesAggregatedHaving.isEmpty();
        if (optionalHavingNode != null && hasAggregation) {
            ResultSetProcessorFactoryFactory.validateHaving(propertiesGroupBy, optionalHavingNode);
        }
        boolean bl2 = isSelectRStream = statementSpec.getSelectStreamSelectorEnum() == SelectClauseStreamSelectorEnum.RSTREAM_ISTREAM_BOTH || statementSpec.getSelectStreamSelectorEnum() == SelectClauseStreamSelectorEnum.RSTREAM_ONLY;
        if (statementSpec.getInsertIntoDesc() != null && statementSpec.getInsertIntoDesc().getStreamSelector().isSelectsRStream()) {
            isSelectRStream = true;
        }
        ExprEvaluator optionHavingEval = optionalHavingNode == null ? null : optionalHavingNode.getExprEvaluator();
        boolean hasOutputLimitOptHint = HintEnum.ENABLE_OUTPUTLIMIT_OPT.getHint(statementSpec.getAnnotations()) != null;
        OutputConditionPolledFactory optionalOutputFirstConditionFactory = null;
        if (outputLimitSpec != null && outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.FIRST) {
            optionalOutputFirstConditionFactory = OutputConditionPolledFactoryFactory.createConditionFactory(outputLimitSpec, stmtContext);
        }
        if (groupByNodesValidated.length == 0 && selectAggregateExprNodes.isEmpty() && havingAggregateExprNodes.isEmpty()) {
            boolean isOutputLimitingNoSnapshot;
            boolean bl3 = isOutputLimitingNoSnapshot = outputLimitSpec != null && outputLimitSpec.getDisplayLimit() != OutputLimitLimitType.SNAPSHOT;
            if (orderByNodes.isEmpty() && optionalHavingNode == null && !isOutputLimitingNoSnapshot && statementSpec.getRowLimitSpec() == null) {
                log.debug((Object)".getProcessor Using no result processor");
                ResultSetProcessorHandThroughFactory factory = new ResultSetProcessorHandThroughFactory(selectExprProcessor, isSelectRStream);
                return new ResultSetProcessorFactoryDesc(factory, orderByProcessorFactory, aggregationServiceFactory);
            }
            log.debug((Object)".getProcessor Using ResultSetProcessorSimple");
            ResultSetProcessorSimpleFactory factory = new ResultSetProcessorSimpleFactory(selectExprProcessor, optionHavingEval, isSelectRStream, outputLimitSpec, hasOutputLimitOptHint, resultSetProcessorHelperFactory, numStreams);
            return new ResultSetProcessorFactoryDesc(factory, orderByProcessorFactory, aggregationServiceFactory);
        }
        boolean isLast = statementSpec.getOutputLimitSpec() != null && statementSpec.getOutputLimitSpec().getDisplayLimit() == OutputLimitLimitType.LAST;
        boolean bl4 = isFirst = statementSpec.getOutputLimitSpec() != null && statementSpec.getOutputLimitSpec().getDisplayLimit() == OutputLimitLimitType.FIRST;
        if (namedSelectionList.isEmpty() && propertiesAggregatedHaving.isEmpty() && havingAggregateExprNodes.isEmpty() && !isLast && !isFirst) {
            log.debug((Object)".getProcessor Using ResultSetProcessorSimple");
            ResultSetProcessorSimpleFactory factory = new ResultSetProcessorSimpleFactory(selectExprProcessor, optionHavingEval, isSelectRStream, outputLimitSpec, hasOutputLimitOptHint, resultSetProcessorHelperFactory, numStreams);
            return new ResultSetProcessorFactoryDesc(factory, orderByProcessorFactory, aggregationServiceFactory);
        }
        if (groupByNodesValidated.length == 0 && hasAggregation) {
            boolean hasStreamSelect = ExprNodeUtility.hasStreamSelect(selectNodes);
            if (nonAggregatedPropsSelect.isEmpty() && !hasStreamSelect && !isUsingWildcard && !isUsingStreamSelect && localGroupByMatchesGroupBy && (viewResourceDelegate == null || viewResourceDelegate.getPreviousRequests().isEmpty())) {
                log.debug((Object)".getProcessor Using ResultSetProcessorRowForAll");
                ResultSetProcessorRowForAllFactory factory = new ResultSetProcessorRowForAllFactory(selectExprProcessor, optionHavingEval, isSelectRStream, isUnidirectional, isHistoricalOnly, outputLimitSpec, resultSetProcessorHelperFactory);
                return new ResultSetProcessorFactoryDesc(factory, orderByProcessorFactory, aggregationServiceFactory);
            }
            log.debug((Object)".getProcessor Using ResultSetProcessorAggregateAll");
            ResultSetProcessorAggregateAllFactory factory = new ResultSetProcessorAggregateAllFactory(selectExprProcessor, optionHavingEval, isSelectRStream, isUnidirectional, isHistoricalOnly, outputLimitSpec, hasOutputLimitOptHint, resultSetProcessorHelperFactory);
            return new ResultSetProcessorFactoryDesc(factory, orderByProcessorFactory, aggregationServiceFactory);
        }
        if (groupByNodesValidated.length == 0) {
            throw new IllegalStateException("Unexpected empty group-by expression list");
        }
        boolean allInGroupBy = true;
        String notInGroupByReason = null;
        if (isUsingStreamSelect) {
            allInGroupBy = false;
            notInGroupByReason = "stream select";
        }
        if ((reasonMessage = propertiesGroupBy.notContainsAll(nonAggregatedPropsSelect)) != null) {
            notInGroupByReason = reasonMessage;
            allInGroupBy = false;
        }
        if (isUsingWildcard) {
            allInGroupBy = false;
            notInGroupByReason = "wildcard select";
        }
        boolean bl5 = allInSelect = (reasonMessage = nonAggregatedPropsSelect.notContainsAll(nonAggregatedPropsOrderBy = ExprNodeUtility.getNonAggregatedProps(typeService.getEventTypes(), orderByNodes, contextPropertyRegistry))) == null;
        if (isUsingWildcard) {
            allInSelect = true;
        }
        ExprEvaluator[] groupByEval = ExprNodeUtility.getEvaluators(groupByNodesValidated);
        if (allInGroupBy && allInSelect && localGroupByMatchesGroupBy) {
            ResultSetProcessorFactory factory;
            boolean noDataWindowSingleStream = typeService.getIStreamOnly()[0] && typeService.getEventTypes().length < 2;
            boolean iterableUnboundConfig = configurationInformation.getEngineDefaults().getViewResources().isIterableUnbound();
            boolean iterateUnbounded = noDataWindowSingleStream && (iterableUnboundConfig || AnnotationUtil.findAnnotation(statementSpec.getAnnotations(), IterableUnbound.class) != null);
            log.debug((Object)".getProcessor Using ResultSetProcessorRowPerGroup");
            if (groupByRollupDesc != null) {
                GroupByRollupPerLevelExpression perLevelExpression = ResultSetProcessorFactoryFactory.getRollUpPerLevelExpressions(statementSpec, groupByNodesValidated, groupByRollupDesc, stmtContext, selectExprEventTypeRegistry, evaluatorContextStmt, insertIntoDesc, typeService, validationContext, groupByRollupInfo);
                factory = new ResultSetProcessorRowPerGroupRollupFactory(perLevelExpression, groupByNodesValidated, groupByEval, isSelectRStream, isUnidirectional, outputLimitSpec, orderByProcessorFactory != null, noDataWindowSingleStream, groupByRollupDesc, typeService.getEventTypes().length > 1, isHistoricalOnly, iterateUnbounded, optionalOutputFirstConditionFactory, resultSetProcessorHelperFactory, hasOutputLimitOptHint, numStreams);
            } else {
                factory = new ResultSetProcessorRowPerGroupFactory(selectExprProcessor, groupByNodesValidated, groupByEval, optionHavingEval, isSelectRStream, isUnidirectional, outputLimitSpec, orderByProcessorFactory != null, noDataWindowSingleStream, isHistoricalOnly, iterateUnbounded, resultSetProcessorHelperFactory, hasOutputLimitOptHint, numStreams, optionalOutputFirstConditionFactory);
            }
            return new ResultSetProcessorFactoryDesc(factory, orderByProcessorFactory, aggregationServiceFactory);
        }
        if (groupByRollupDesc != null) {
            throw new ExprValidationException("Group-by with rollup requires a fully-aggregated query, the query is not full-aggregated because of " + notInGroupByReason);
        }
        log.debug((Object)".getProcessor Using ResultSetProcessorAggregateGrouped");
        ResultSetProcessorAggregateGroupedFactory factory = new ResultSetProcessorAggregateGroupedFactory(selectExprProcessor, groupByNodesValidated, groupByEval, optionHavingEval, isSelectRStream, isUnidirectional, outputLimitSpec, orderByProcessorFactory != null, isHistoricalOnly, resultSetProcessorHelperFactory, optionalOutputFirstConditionFactory, hasOutputLimitOptHint, numStreams);
        return new ResultSetProcessorFactoryDesc(factory, orderByProcessorFactory, aggregationServiceFactory);
    }

    private static void validateOutputLimit(OutputLimitSpec outputLimitSpec, StatementContext statementContext) throws ExprValidationException {
        ExprTimePeriod timePeriodExpr;
        if (outputLimitSpec == null) {
            return;
        }
        ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(statementContext, false);
        ExprValidationContext validationContext = new ExprValidationContext(new StreamTypeServiceImpl(statementContext.getEngineURI(), false), statementContext.getEngineImportService(), statementContext.getStatementExtensionServicesContext(), null, statementContext.getTimeProvider(), statementContext.getVariableService(), statementContext.getTableService(), evaluatorContextStmt, statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor(), false, false, false, false, null, false);
        if (outputLimitSpec.getAfterTimePeriodExpr() != null) {
            timePeriodExpr = (ExprTimePeriod)ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.OUTPUTLIMIT, outputLimitSpec.getAfterTimePeriodExpr(), validationContext);
            outputLimitSpec.setAfterTimePeriodExpr(timePeriodExpr);
        }
        if (outputLimitSpec.getTimePeriodExpr() != null) {
            timePeriodExpr = (ExprTimePeriod)ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.OUTPUTLIMIT, outputLimitSpec.getTimePeriodExpr(), validationContext);
            outputLimitSpec.setTimePeriodExpr(timePeriodExpr);
            if (timePeriodExpr.isConstantResult()) {
                ExprEvaluatorContextStatement exprEvaluatorContextStatement = new ExprEvaluatorContextStatement(statementContext, false);
                if (timePeriodExpr.evaluateAsSeconds(null, true, exprEvaluatorContextStatement) <= 0.0) {
                    throw new ExprValidationException("Invalid time period expression returns a zero or negative time interval");
                }
            }
        }
    }

    private static boolean analyzeLocalGroupBy(ExprNode[] groupByNodesValidated, List<ExprAggregateNode> selectAggregateExprNodes, List<ExprAggregateNode> havingAggregateExprNodes, List<ExprAggregateNode> orderByAggregateExprNodes) {
        boolean localGroupByMatchesGroupBy = ResultSetProcessorFactoryFactory.analyzeLocalGroupBy(groupByNodesValidated, selectAggregateExprNodes);
        localGroupByMatchesGroupBy = localGroupByMatchesGroupBy && ResultSetProcessorFactoryFactory.analyzeLocalGroupBy(groupByNodesValidated, havingAggregateExprNodes);
        localGroupByMatchesGroupBy = localGroupByMatchesGroupBy && ResultSetProcessorFactoryFactory.analyzeLocalGroupBy(groupByNodesValidated, orderByAggregateExprNodes);
        return localGroupByMatchesGroupBy;
    }

    private static boolean analyzeLocalGroupBy(ExprNode[] groupByNodesValidated, List<ExprAggregateNode> aggNodes) {
        for (ExprAggregateNode agg : aggNodes) {
            if (agg.getOptionalLocalGroupBy() == null || ExprNodeUtility.deepEqualsIsSubset(agg.getOptionalLocalGroupBy().getPartitionExpressions(), groupByNodesValidated)) continue;
            return false;
        }
        return true;
    }

    private static GroupByRollupInfo analyzeValidateGroupBy(GroupByClauseExpressions groupBy, ExprValidationContext validationContext) throws ExprValidationException {
        if (groupBy == null) {
            return null;
        }
        ExprNodeUtility.validateNoSpecialsGroupByExpressions(groupBy.getGroupByNodes());
        ExprNode[] validated = new ExprNode[groupBy.getGroupByNodes().length];
        for (int i = 0; i < validated.length; ++i) {
            validated[i] = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.GROUPBY, groupBy.getGroupByNodes()[i], validationContext);
        }
        if (groupBy.getGroupByRollupLevels() == null) {
            return new GroupByRollupInfo(validated, null);
        }
        AggregationGroupByRollupDesc rollup = AggregationGroupByRollupDesc.make(groupBy.getGroupByRollupLevels());
        try {
            GroupByRollupPlanHook hook = (GroupByRollupPlanHook)JavaClassHelper.getAnnotationHook(validationContext.getAnnotations(), HookType.INTERNAL_GROUPROLLUP_PLAN, GroupByRollupPlanHook.class, null);
            if (hook != null) {
                hook.query(new GroupByRollupPlanDesc(validated, rollup));
            }
        }
        catch (ExprValidationException e) {
            throw new EPException("Failed to obtain hook for " + (Object)((Object)HookType.INTERNAL_QUERY_PLAN));
        }
        return new GroupByRollupInfo(validated, rollup);
    }

    private static GroupByRollupPerLevelExpression getRollUpPerLevelExpressions(StatementSpecCompiled statementSpec, ExprNode[] groupByNodesValidated, AggregationGroupByRollupDesc groupByRollupDesc, StatementContext stmtContext, SelectExprEventTypeRegistry selectExprEventTypeRegistry, ExprEvaluatorContextStatement evaluatorContextStmt, InsertIntoDesc insertIntoDesc, StreamTypeService typeService, ExprValidationContext validationContext, GroupByRollupInfo groupByRollupInfo) throws ExprValidationException {
        int i;
        int numLevels = groupByRollupDesc.getLevels().length;
        GroupByClauseExpressions groupByExpressions = statementSpec.getGroupByExpressions();
        SelectExprProcessor[] processors = new SelectExprProcessor[numLevels];
        ExprEvaluator[] havingClauses = null;
        if (groupByExpressions.getOptHavingNodePerLevel() != null) {
            havingClauses = new ExprEvaluator[numLevels];
        }
        OrderByElement[][] orderByElements = null;
        if (groupByExpressions.getOptOrderByPerLevel() != null) {
            orderByElements = new OrderByElement[numLevels][];
        }
        ExprNodePropOrStreamSet[] propsPerGroupByExpr = new ExprNodePropOrStreamSet[groupByNodesValidated.length];
        for (i = 0; i < groupByNodesValidated.length; ++i) {
            propsPerGroupByExpr[i] = ExprNodeUtility.getGroupByPropertiesValidateHasOne(new ExprNode[]{groupByNodesValidated[i]});
        }
        for (i = 0; i < numLevels; ++i) {
            AggregationGroupByRollupLevel level = groupByRollupDesc.getLevels()[i];
            ExprNodePropOrStreamSet rolledupProps = ResultSetProcessorFactoryFactory.getRollupProperties(level, propsPerGroupByExpr);
            ExprNode[] selectClauseLevel = groupByExpressions.getSelectClausePerLevel()[i];
            SelectClauseElementCompiled[] selectClause = ResultSetProcessorFactoryFactory.getRollUpSelectClause(statementSpec.getSelectClauseSpec(), selectClauseLevel, level, rolledupProps, groupByNodesValidated, validationContext);
            processors[i] = SelectExprProcessorFactory.getProcessor(Collections.<Integer>emptyList(), selectClause, false, insertIntoDesc, null, statementSpec.getForClauseSpec(), typeService, stmtContext.getEventAdapterService(), stmtContext.getStatementResultService(), stmtContext.getValueAddEventService(), selectExprEventTypeRegistry, stmtContext.getEngineImportService(), evaluatorContextStmt, stmtContext.getVariableService(), stmtContext.getTableService(), stmtContext.getTimeProvider(), stmtContext.getEngineURI(), stmtContext.getStatementId(), stmtContext.getStatementName(), stmtContext.getAnnotations(), stmtContext.getContextDescriptor(), stmtContext.getConfigSnapshot(), null, stmtContext.getNamedWindowMgmtService(), statementSpec.getIntoTableSpec(), groupByRollupInfo, stmtContext.getStatementExtensionServicesContext());
            if (havingClauses != null) {
                havingClauses[i] = ResultSetProcessorFactoryFactory.rewriteRollupValidateExpression(ExprNodeOrigin.HAVING, groupByExpressions.getOptHavingNodePerLevel()[i], validationContext, rolledupProps, groupByNodesValidated, level).getExprEvaluator();
            }
            if (orderByElements == null) continue;
            orderByElements[i] = ResultSetProcessorFactoryFactory.rewriteRollupOrderBy(statementSpec.getOrderByList(), groupByExpressions.getOptOrderByPerLevel()[i], validationContext, rolledupProps, groupByNodesValidated, level);
        }
        return new GroupByRollupPerLevelExpression(processors, havingClauses, orderByElements);
    }

    private static OrderByElement[] rewriteRollupOrderBy(OrderByItem[] items, ExprNode[] orderByList, ExprValidationContext validationContext, ExprNodePropOrStreamSet rolledupProps, ExprNode[] groupByNodes, AggregationGroupByRollupLevel level) throws ExprValidationException {
        OrderByElement[] elements = new OrderByElement[orderByList.length];
        for (int i = 0; i < orderByList.length; ++i) {
            ExprNode validated = ResultSetProcessorFactoryFactory.rewriteRollupValidateExpression(ExprNodeOrigin.ORDERBY, orderByList[i], validationContext, rolledupProps, groupByNodes, level);
            elements[i] = new OrderByElement(validated, validated.getExprEvaluator(), items[i].isDescending());
        }
        return elements;
    }

    private static ExprNodePropOrStreamSet getRollupProperties(AggregationGroupByRollupLevel level, ExprNodePropOrStreamSet[] propsPerGroupByExpr) {
        ExprNodePropOrStreamSet rolledupProps = new ExprNodePropOrStreamSet();
        for (int i = 0; i < propsPerGroupByExpr.length; ++i) {
            if (level.isAggregationTop()) {
                rolledupProps.addAll(propsPerGroupByExpr[i]);
                continue;
            }
            boolean rollupContainsGroupExpr = false;
            for (int num : level.getRollupKeys()) {
                if (num != i) continue;
                rollupContainsGroupExpr = true;
                break;
            }
            if (rollupContainsGroupExpr) continue;
            rolledupProps.addAll(propsPerGroupByExpr[i]);
        }
        return rolledupProps;
    }

    private static SelectClauseElementCompiled[] getRollUpSelectClause(SelectClauseSpecCompiled selectClauseSpec, ExprNode[] selectClauseLevel, AggregationGroupByRollupLevel level, ExprNodePropOrStreamSet rolledupProps, ExprNode[] groupByNodesValidated, ExprValidationContext validationContext) throws ExprValidationException {
        SelectClauseElementCompiled[] rewritten = new SelectClauseElementCompiled[selectClauseSpec.getSelectExprList().length];
        for (int i = 0; i < rewritten.length; ++i) {
            SelectClauseElementCompiled spec = selectClauseSpec.getSelectExprList()[i];
            if (!(spec instanceof SelectClauseExprCompiledSpec)) {
                throw new ExprValidationException("Group-by clause with roll-up does not allow wildcard");
            }
            SelectClauseExprCompiledSpec exprSpec = (SelectClauseExprCompiledSpec)spec;
            ExprNode validated = ResultSetProcessorFactoryFactory.rewriteRollupValidateExpression(ExprNodeOrigin.SELECT, selectClauseLevel[i], validationContext, rolledupProps, groupByNodesValidated, level);
            rewritten[i] = new SelectClauseExprCompiledSpec(validated, exprSpec.getAssignedName(), exprSpec.getProvidedName(), exprSpec.isEvents());
        }
        return rewritten;
    }

    private static ExprNode rewriteRollupValidateExpression(ExprNodeOrigin exprNodeOrigin, ExprNode exprNode, ExprValidationContext validationContext, ExprNodePropOrStreamSet rolledupProps, ExprNode[] groupByNodes, AggregationGroupByRollupLevel level) throws ExprValidationException {
        int[] combination;
        ExprNodeGroupingVisitorWParent groupingVisitor = new ExprNodeGroupingVisitorWParent();
        exprNode.accept(groupingVisitor);
        for (Pair<ExprNode, ExprGroupingNode> pair : groupingVisitor.getGroupingNodes()) {
            int[] rollupIndexes;
            combination = ResultSetProcessorFactoryFactory.getGroupExprCombination(groupByNodes, pair.getSecond().getChildNodes());
            boolean found = false;
            for (int index : rollupIndexes = level.isAggregationTop() ? new int[]{} : level.getRollupKeys()) {
                if (index != combination[0]) continue;
                found = true;
                break;
            }
            int result = found ? 0 : 1;
            ExprConstantNodeImpl constant = new ExprConstantNodeImpl(result, Integer.class);
            if (pair.getFirst() != null) {
                ExprNodeUtility.replaceChildNode(pair.getFirst(), pair.getSecond(), constant);
                continue;
            }
            exprNode = constant;
        }
        for (Pair<ExprNode, ExprNodeBase> pair : groupingVisitor.getGroupingIdNodes()) {
            combination = ResultSetProcessorFactoryFactory.getGroupExprCombination(groupByNodes, ((ExprGroupingIdNode)pair.getSecond()).getChildNodes());
            int result = 0;
            for (int i = 0; i < combination.length; ++i) {
                int[] rollupIndexes;
                int index = combination[i];
                boolean found = false;
                for (int rollupIndex : rollupIndexes = level.isAggregationTop() ? new int[]{} : level.getRollupKeys()) {
                    if (index != rollupIndex) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                result += ResultSetProcessorFactoryFactory.pow2(combination.length - i - 1);
            }
            ExprConstantNodeImpl constant = new ExprConstantNodeImpl(result, Integer.class);
            if (pair.getFirst() != null) {
                ExprNodeUtility.replaceChildNode(pair.getFirst(), pair.getSecond(), constant);
                continue;
            }
            exprNode = constant;
        }
        ExprNodeIdentifierCollectVisitorWContainer identVisitor = new ExprNodeIdentifierCollectVisitorWContainer();
        exprNode.accept(identVisitor);
        for (Pair<ExprNode, ExprIdentNode> node : identVisitor.getExprProperties()) {
            boolean rewrite = false;
            ExprNodePropOrStreamExprDesc firstRollupNonPropExpr = rolledupProps.getFirstExpression();
            if (firstRollupNonPropExpr != null) {
                throw new ExprValidationException("Invalid rollup expression " + firstRollupNonPropExpr.getTextual());
            }
            Iterator<ExprNodePropOrStreamPropDesc> i$ = rolledupProps.getProperties().iterator();
            while (i$.hasNext()) {
                ExprNodePropOrStreamPropDesc rolledupProp;
                ExprNodePropOrStreamPropDesc prop = rolledupProp = i$.next();
                if (rolledupProp.getStreamNum() != node.getSecond().getStreamId() || !prop.getPropertyName().equals(node.getSecond().getResolvedPropertyName())) continue;
                rewrite = true;
                break;
            }
            if (node.getFirst() != null && (node.getFirst() instanceof ExprPreviousNode || node.getFirst() instanceof ExprPriorNode)) {
                rewrite = false;
            }
            if (!rewrite) continue;
            ExprConstantNodeImpl constant = new ExprConstantNodeImpl(null, node.getSecond().getExprEvaluator().getType());
            if (node.getFirst() != null) {
                ExprNodeUtility.replaceChildNode(node.getFirst(), node.getSecond(), constant);
                continue;
            }
            exprNode = constant;
        }
        return ExprNodeUtility.getValidatedSubtree(exprNodeOrigin, exprNode, validationContext);
    }

    private static int[] getGroupExprCombination(ExprNode[] groupByNodes, ExprNode[] childNodes) throws ExprValidationException {
        TreeSet<Integer> indexes = new TreeSet<Integer>();
        for (ExprNode child : childNodes) {
            boolean found = false;
            for (int i = 0; i < groupByNodes.length; ++i) {
                if (!ExprNodeUtility.deepEquals(child, groupByNodes[i])) continue;
                if (indexes.contains(i)) {
                    throw new ExprValidationException("Duplicate expression '" + ExprNodeUtility.toExpressionStringMinPrecedenceSafe(child) + "' among grouping function parameters");
                }
                indexes.add(i);
                found = true;
            }
            if (found) continue;
            throw new ExprValidationException("Failed to find expression '" + ExprNodeUtility.toExpressionStringMinPrecedenceSafe(child) + "' among group-by expressions");
        }
        return CollectionUtil.intArray(indexes);
    }

    private static void validateSelectAssignColNames(SelectClauseSpecCompiled selectClauseSpec, List<SelectClauseExprCompiledSpec> namedSelectionList, ExprValidationContext validationContext) throws ExprValidationException {
        for (int i = 0; i < selectClauseSpec.getSelectExprList().length; ++i) {
            SelectClauseElementCompiled element = selectClauseSpec.getSelectExprList()[i];
            if (!(element instanceof SelectClauseExprCompiledSpec)) continue;
            SelectClauseExprCompiledSpec expr = (SelectClauseExprCompiledSpec)element;
            ExprNode validatedExpression = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.SELECT, expr.getSelectExpression(), validationContext);
            String asName = expr.getAssignedName();
            if (asName == null) {
                asName = ExprNodeUtility.toExpressionStringMinPrecedenceSafe(validatedExpression);
            }
            expr.setAssignedName(asName);
            expr.setSelectExpression(validatedExpression);
            namedSelectionList.add(expr);
        }
    }

    private static void validateHaving(ExprNodePropOrStreamSet propertiesGroupedBy, ExprNode havingNode) throws ExprValidationException {
        LinkedList<ExprAggregateNode> aggregateNodesHaving = new LinkedList<ExprAggregateNode>();
        ExprAggregateNodeUtil.getAggregatesBottomUp(havingNode, aggregateNodesHaving);
        if (!propertiesGroupedBy.isEmpty()) {
            ExprNodeIdentifierAndStreamRefVisitor visitor = new ExprNodeIdentifierAndStreamRefVisitor(true);
            havingNode.accept(visitor);
            List<ExprNodePropOrStreamDesc> allPropertiesHaving = visitor.getRefs();
            ExprNodePropOrStreamSet aggPropertiesHaving = ExprNodeUtility.getAggregatedProperties(aggregateNodesHaving);
            aggPropertiesHaving.removeFromList(allPropertiesHaving);
            propertiesGroupedBy.removeFromList(allPropertiesHaving);
            if (!allPropertiesHaving.isEmpty()) {
                ExprNodePropOrStreamDesc desc = allPropertiesHaving.iterator().next();
                throw new ExprValidationException("Non-aggregated " + desc.getTextual() + " in the HAVING clause must occur in the group-by clause");
            }
        }
    }

    private static List<OrderByItem> expandColumnNames(SelectClauseElementCompiled[] selectionList, OrderByItem[] orderByUnexpanded) {
        if (orderByUnexpanded.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<OrderByItem> expanded = new ArrayList<OrderByItem>();
        for (OrderByItem item : orderByUnexpanded) {
            expanded.add(item.copy());
        }
        for (SelectClauseElementCompiled selectElement : selectionList) {
            SelectClauseExprCompiledSpec selectExpr;
            String name;
            if (!(selectElement instanceof SelectClauseExprCompiledSpec) || (name = (selectExpr = (SelectClauseExprCompiledSpec)selectElement).getAssignedName()) == null) continue;
            ExprNode fullExpr = selectExpr.getSelectExpression();
            ListIterator<OrderByItem> iterator = expanded.listIterator();
            while (iterator.hasNext()) {
                OrderByItem orderByElement = (OrderByItem)iterator.next();
                ExprNode swapped = ColumnNamedNodeSwapper.swap(orderByElement.getExprNode(), name, fullExpr);
                OrderByItem newOrderByElement = new OrderByItem(swapped, orderByElement.isDescending());
                iterator.set(newOrderByElement);
            }
        }
        return expanded;
    }

    private static int pow2(int exponent) {
        if (exponent == 0) {
            return 1;
        }
        int result = 2;
        for (int i = 0; i < exponent - 1; ++i) {
            result = 2 * result;
        }
        return result;
    }
}

