/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorOutputHelperVisitor;
import com.espertech.esper.epl.core.ResultSetProcessorRowForAllFactory;
import com.espertech.esper.epl.core.ResultSetProcessorRowForAllOutputAllHelper;
import com.espertech.esper.epl.core.ResultSetProcessorRowForAllOutputLastHelper;
import com.espertech.esper.epl.core.ResultSetProcessorUtil;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.view.Viewable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ResultSetProcessorRowForAll
implements ResultSetProcessor {
    protected final ResultSetProcessorRowForAllFactory prototype;
    private final SelectExprProcessor selectExprProcessor;
    private final OrderByProcessor orderByProcessor;
    protected final AggregationService aggregationService;
    protected ExprEvaluatorContext exprEvaluatorContext;
    private ResultSetProcessorRowForAllOutputLastHelper outputLastHelper;
    private ResultSetProcessorRowForAllOutputAllHelper outputAllHelper;

    public ResultSetProcessorRowForAll(ResultSetProcessorRowForAllFactory prototype, SelectExprProcessor selectExprProcessor, OrderByProcessor orderByProcessor, AggregationService aggregationService, AgentInstanceContext agentInstanceContext) {
        this.prototype = prototype;
        this.selectExprProcessor = selectExprProcessor;
        this.orderByProcessor = orderByProcessor;
        this.aggregationService = aggregationService;
        this.exprEvaluatorContext = agentInstanceContext;
        if (prototype.isOutputLast()) {
            this.outputLastHelper = prototype.getResultSetProcessorHelperFactory().makeRSRowForAllOutputLast(this, prototype, agentInstanceContext);
        } else if (prototype.isOutputAll()) {
            this.outputAllHelper = prototype.getResultSetProcessorHelperFactory().makeRSRowForAllOutputAll(this, prototype, agentInstanceContext);
        }
    }

    @Override
    public void setAgentInstanceContext(AgentInstanceContext context) {
        this.exprEvaluatorContext = context;
    }

    @Override
    public EventType getResultEventType() {
        return this.prototype.getResultEventType();
    }

    @Override
    public UniformPair<EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isSynthesize) {
        EventBean[] selectOldEvents = null;
        if (this.prototype.isUnidirectional()) {
            this.clear();
        }
        if (this.prototype.isSelectRStream()) {
            selectOldEvents = this.getSelectListEvents(false, isSynthesize, true);
        }
        ResultSetProcessorUtil.applyAggJoinResult(this.aggregationService, this.exprEvaluatorContext, newEvents, oldEvents);
        EventBean[] selectNewEvents = this.getSelectListEvents(true, isSynthesize, true);
        if (selectNewEvents == null && selectOldEvents == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
    }

    @Override
    public UniformPair<EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData, boolean isSynthesize) {
        EventBean[] selectOldEvents = null;
        if (this.prototype.isSelectRStream()) {
            selectOldEvents = this.getSelectListEvents(false, isSynthesize, false);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        ResultSetProcessorUtil.applyAggViewResult(this.aggregationService, this.exprEvaluatorContext, newData, oldData, eventsPerStream);
        EventBean[] selectNewEvents = this.getSelectListEvents(true, isSynthesize, false);
        if (selectNewEvents == null && selectOldEvents == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
    }

    public EventBean[] getSelectListEvents(boolean isNewData, boolean isSynthesize, boolean join) {
        Boolean result;
        if (!(this.prototype.getOptionalHavingNode() == null || (result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(null, isNewData, this.exprEvaluatorContext)) != null && result.booleanValue())) {
            return null;
        }
        EventBean theEvent = this.selectExprProcessor.process(CollectionUtil.EVENTBEANARRAY_EMPTY, isNewData, isSynthesize, this.exprEvaluatorContext);
        return new EventBean[]{theEvent};
    }

    private EventBean getSelectListEvent(boolean isNewData, boolean isSynthesize, boolean join) {
        Boolean result;
        if (!(this.prototype.getOptionalHavingNode() == null || (result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(null, isNewData, this.exprEvaluatorContext)) != null && result.booleanValue())) {
            return null;
        }
        EventBean theEvent = this.selectExprProcessor.process(CollectionUtil.EVENTBEANARRAY_EMPTY, isNewData, isSynthesize, this.exprEvaluatorContext);
        return theEvent;
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        if (!this.prototype.isHistoricalOnly()) {
            return this.obtainIterator();
        }
        ResultSetProcessorUtil.clearAndAggregateUngrouped(this.exprEvaluatorContext, this.aggregationService, parent);
        Iterator<EventBean> iterator = this.obtainIterator();
        this.aggregationService.clearResults(this.exprEvaluatorContext);
        return iterator;
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        EventBean[] result = this.getSelectListEvents(true, true, true);
        return new ArrayEventIterator(result);
    }

    @Override
    public void clear() {
        this.aggregationService.clearResults(this.exprEvaluatorContext);
    }

    @Override
    public UniformPair<EventBean[]> processOutputLimitedJoin(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        if (outputLimitLimitType == OutputLimitLimitType.LAST) {
            return this.processOutputLimitedJoinLast(joinEventsSet, generateSynthetic);
        }
        return this.processOutputLimitedJoinDefault(joinEventsSet, generateSynthetic);
    }

    @Override
    public UniformPair<EventBean[]> processOutputLimitedView(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        if (outputLimitLimitType == OutputLimitLimitType.LAST) {
            return this.processOutputLimitedViewLast(viewEventsList, generateSynthetic);
        }
        return this.processOutputLimitedViewDefault(viewEventsList, generateSynthetic);
    }

    @Override
    public boolean hasAggregation() {
        return true;
    }

    @Override
    public void applyViewResult(EventBean[] newData, EventBean[] oldData) {
        EventBean[] events = new EventBean[1];
        ResultSetProcessorUtil.applyAggViewResult(this.aggregationService, this.exprEvaluatorContext, newData, oldData, events);
    }

    @Override
    public void applyJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents) {
        ResultSetProcessorUtil.applyAggJoinResult(this.aggregationService, this.exprEvaluatorContext, newEvents, oldEvents);
    }

    public AggregationService getAggregationService() {
        return this.aggregationService;
    }

    @Override
    public void stop() {
        if (this.outputLastHelper != null) {
            this.outputLastHelper.destroy();
        }
        if (this.outputAllHelper != null) {
            this.outputAllHelper.destroy();
        }
    }

    @Override
    public void processOutputLimitedLastAllNonBufferedView(EventBean[] newData, EventBean[] oldData, boolean isGenerateSynthetic, boolean isAll) {
        if (isAll) {
            this.outputAllHelper.processView(newData, oldData, isGenerateSynthetic);
        } else {
            this.outputLastHelper.processView(newData, oldData, isGenerateSynthetic);
        }
    }

    @Override
    public void processOutputLimitedLastAllNonBufferedJoin(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isGenerateSynthetic, boolean isAll) {
        if (isAll) {
            this.outputAllHelper.processJoin(newEvents, oldEvents, isGenerateSynthetic);
        } else {
            this.outputLastHelper.processJoin(newEvents, oldEvents, isGenerateSynthetic);
        }
    }

    @Override
    public UniformPair<EventBean[]> continueOutputLimitedLastAllNonBufferedView(boolean isSynthesize, boolean isAll) {
        if (isAll) {
            return this.outputAllHelper.outputView(isSynthesize);
        }
        return this.outputLastHelper.outputView(isSynthesize);
    }

    @Override
    public UniformPair<EventBean[]> continueOutputLimitedLastAllNonBufferedJoin(boolean isSynthesize, boolean isAll) {
        if (isAll) {
            return this.outputAllHelper.outputJoin(isSynthesize);
        }
        return this.outputLastHelper.outputJoin(isSynthesize);
    }

    @Override
    public void acceptHelperVisitor(ResultSetProcessorOutputHelperVisitor visitor) {
        if (this.outputLastHelper != null) {
            visitor.visit(this.outputLastHelper);
        }
        if (this.outputAllHelper != null) {
            visitor.visit(this.outputAllHelper);
        }
    }

    private void getSelectListEvent(boolean isNewData, boolean isSynthesize, List<EventBean> resultEvents, boolean join) {
        Boolean result;
        if (!(this.prototype.getOptionalHavingNode() == null || (result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(null, isNewData, this.exprEvaluatorContext)) != null && result.booleanValue())) {
            return;
        }
        EventBean theEvent = this.selectExprProcessor.process(CollectionUtil.EVENTBEANARRAY_EMPTY, isNewData, isSynthesize, this.exprEvaluatorContext);
        resultEvents.add(theEvent);
    }

    private UniformPair<EventBean[]> processOutputLimitedJoinDefault(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic) {
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList newEventsSortKey = null;
        LinkedList oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedList();
            }
        }
        for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
            if (this.prototype.isUnidirectional()) {
                this.clear();
            }
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            if (this.prototype.isSelectRStream()) {
                this.getSelectListEvent(false, generateSynthetic, oldEvents, true);
            }
            if (newData != null) {
                for (MultiKey<EventBean> row : newData) {
                    this.aggregationService.applyEnter(row.getArray(), null, this.exprEvaluatorContext);
                }
            }
            if (oldData != null) {
                for (MultiKey<EventBean> row : oldData) {
                    this.aggregationService.applyLeave(row.getArray(), null, this.exprEvaluatorContext);
                }
            }
            this.getSelectListEvent(false, generateSynthetic, newEvents, true);
        }
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.exprEvaluatorContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.exprEvaluatorContext);
            }
        }
        if (joinEventsSet.isEmpty()) {
            if (this.prototype.isSelectRStream()) {
                oldEventsArr = this.getSelectListEvents(false, generateSynthetic, true);
            }
            newEventsArr = this.getSelectListEvents(true, generateSynthetic, true);
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private UniformPair<EventBean[]> processOutputLimitedJoinLast(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic) {
        EventBean[] lastOld;
        EventBean[] eventBeanArray;
        EventBean[] lastNew;
        EventBean[] eventBeanArray2;
        EventBean lastOldEvent = null;
        EventBean lastNewEvent = null;
        if (joinEventsSet.isEmpty()) {
            lastNewEvent = this.prototype.isSelectRStream() ? (lastOldEvent = this.getSelectListEvent(false, generateSynthetic, true)) : this.getSelectListEvent(false, generateSynthetic, true);
        }
        for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
            if (this.prototype.isUnidirectional()) {
                this.clear();
            }
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            if (lastOldEvent == null && this.prototype.isSelectRStream()) {
                lastOldEvent = this.getSelectListEvent(false, generateSynthetic, true);
            }
            if (newData != null) {
                for (MultiKey<EventBean> eventsPerStream : newData) {
                    this.aggregationService.applyEnter(eventsPerStream.getArray(), null, this.exprEvaluatorContext);
                }
            }
            if (oldData != null) {
                for (MultiKey<EventBean> eventsPerStream : oldData) {
                    this.aggregationService.applyLeave(eventsPerStream.getArray(), null, this.exprEvaluatorContext);
                }
            }
            lastNewEvent = this.getSelectListEvent(true, generateSynthetic, true);
        }
        if (lastNewEvent != null) {
            EventBean[] eventBeanArray3 = new EventBean[1];
            eventBeanArray2 = eventBeanArray3;
            eventBeanArray3[0] = lastNewEvent;
        } else {
            eventBeanArray2 = lastNew = null;
        }
        if (lastOldEvent != null) {
            EventBean[] eventBeanArray4 = new EventBean[1];
            eventBeanArray = eventBeanArray4;
            eventBeanArray4[0] = lastOldEvent;
        } else {
            eventBeanArray = lastOld = null;
        }
        if (lastNew == null && lastOld == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(lastNew, lastOld);
    }

    private UniformPair<EventBean[]> processOutputLimitedViewDefault(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic) {
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList newEventsSortKey = null;
        LinkedList oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedList();
            }
        }
        for (UniformPair<EventBean[]> pair : viewEventsList) {
            int i$;
            int len$;
            EventBean[] arr$;
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            if (this.prototype.isSelectRStream()) {
                this.getSelectListEvent(false, generateSynthetic, oldEvents, false);
            }
            EventBean[] eventsPerStream = new EventBean[1];
            if (newData != null) {
                arr$ = newData;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    EventBean aNewData;
                    eventsPerStream[0] = aNewData = arr$[i$];
                    this.aggregationService.applyEnter(eventsPerStream, null, this.exprEvaluatorContext);
                }
            }
            if (oldData != null) {
                arr$ = oldData;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    EventBean anOldData;
                    eventsPerStream[0] = anOldData = arr$[i$];
                    this.aggregationService.applyLeave(eventsPerStream, null, this.exprEvaluatorContext);
                }
            }
            this.getSelectListEvent(true, generateSynthetic, newEvents, false);
        }
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.exprEvaluatorContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.exprEvaluatorContext);
            }
        }
        if (viewEventsList.isEmpty()) {
            if (this.prototype.isSelectRStream()) {
                oldEventsArr = this.getSelectListEvents(false, generateSynthetic, false);
            }
            newEventsArr = this.getSelectListEvents(true, generateSynthetic, false);
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private UniformPair<EventBean[]> processOutputLimitedViewLast(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic) {
        EventBean[] lastOld;
        EventBean[] eventBeanArray;
        EventBean[] lastNew;
        EventBean[] eventBeanArray2;
        EventBean lastOldEvent = null;
        EventBean lastNewEvent = null;
        EventBean[] eventsPerStream = new EventBean[1];
        if (viewEventsList.isEmpty()) {
            lastNewEvent = this.prototype.isSelectRStream() ? (lastOldEvent = this.getSelectListEvent(false, generateSynthetic, false)) : this.getSelectListEvent(false, generateSynthetic, false);
        }
        for (UniformPair<EventBean[]> pair : viewEventsList) {
            int i$;
            int len$;
            EventBean[] arr$;
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            if (lastOldEvent == null && this.prototype.isSelectRStream()) {
                lastOldEvent = this.getSelectListEvent(false, generateSynthetic, false);
            }
            if (newData != null) {
                arr$ = newData;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    EventBean aNewData;
                    eventsPerStream[0] = aNewData = arr$[i$];
                    this.aggregationService.applyEnter(eventsPerStream, null, this.exprEvaluatorContext);
                }
            }
            if (oldData != null) {
                arr$ = oldData;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    EventBean anOldData;
                    eventsPerStream[0] = anOldData = arr$[i$];
                    this.aggregationService.applyLeave(eventsPerStream, null, this.exprEvaluatorContext);
                }
            }
            lastNewEvent = this.getSelectListEvent(false, generateSynthetic, false);
        }
        if (lastNewEvent != null) {
            EventBean[] eventBeanArray3 = new EventBean[1];
            eventBeanArray2 = eventBeanArray3;
            eventBeanArray3[0] = lastNewEvent;
        } else {
            eventBeanArray2 = lastNew = null;
        }
        if (lastOldEvent != null) {
            EventBean[] eventBeanArray4 = new EventBean[1];
            eventBeanArray = eventBeanArray4;
            eventBeanArray4[0] = lastOldEvent;
        } else {
            eventBeanArray = lastOld = null;
        }
        if (lastNew == null && lastOld == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(lastNew, lastOld);
    }

    private Iterator<EventBean> obtainIterator() {
        EventBean[] selectNewEvents = this.getSelectListEvents(true, true, false);
        if (selectNewEvents == null) {
            return CollectionUtil.NULL_EVENT_ITERATOR;
        }
        return new SingleEventIterator(selectNewEvents[0]);
    }
}

