/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.core.RowLimitProcessor;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.RowLimitSpec;
import com.espertech.esper.epl.variable.VariableMetaData;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.epl.variable.VariableServiceUtil;
import com.espertech.esper.util.JavaClassHelper;

public class RowLimitProcessorFactory {
    private final VariableMetaData numRowsVariableMetaData;
    private final VariableMetaData offsetVariableMetaData;
    private int currentRowLimit;
    private int currentOffset;

    public RowLimitProcessorFactory(RowLimitSpec rowLimitSpec, VariableService variableService, String optionalContextName) throws ExprValidationException {
        String message;
        if (rowLimitSpec.getNumRowsVariable() != null) {
            this.numRowsVariableMetaData = variableService.getVariableMetaData(rowLimitSpec.getNumRowsVariable());
            if (this.numRowsVariableMetaData == null) {
                throw new ExprValidationException("Limit clause variable by name '" + rowLimitSpec.getNumRowsVariable() + "' has not been declared");
            }
            message = VariableServiceUtil.checkVariableContextName(optionalContextName, this.numRowsVariableMetaData);
            if (message != null) {
                throw new ExprValidationException(message);
            }
            if (!JavaClassHelper.isNumeric(this.numRowsVariableMetaData.getType())) {
                throw new ExprValidationException("Limit clause requires a variable of numeric type");
            }
        } else {
            this.numRowsVariableMetaData = null;
            this.currentRowLimit = rowLimitSpec.getNumRows();
            if (this.currentRowLimit < 0) {
                this.currentRowLimit = Integer.MAX_VALUE;
            }
        }
        if (rowLimitSpec.getOptionalOffsetVariable() != null) {
            this.offsetVariableMetaData = variableService.getVariableMetaData(rowLimitSpec.getOptionalOffsetVariable());
            if (this.offsetVariableMetaData == null) {
                throw new ExprValidationException("Limit clause variable by name '" + rowLimitSpec.getOptionalOffsetVariable() + "' has not been declared");
            }
            message = VariableServiceUtil.checkVariableContextName(optionalContextName, this.offsetVariableMetaData);
            if (message != null) {
                throw new ExprValidationException(message);
            }
            if (!JavaClassHelper.isNumeric(this.offsetVariableMetaData.getType())) {
                throw new ExprValidationException("Limit clause requires a variable of numeric type");
            }
        } else {
            this.offsetVariableMetaData = null;
            if (rowLimitSpec.getOptionalOffset() != null) {
                this.currentOffset = rowLimitSpec.getOptionalOffset();
                if (this.currentOffset <= 0) {
                    throw new ExprValidationException("Limit clause requires a positive offset");
                }
            } else {
                this.currentOffset = 0;
            }
        }
    }

    public RowLimitProcessor instantiate(AgentInstanceContext agentInstanceContext) {
        VariableReader numRowsVariableReader = null;
        if (this.numRowsVariableMetaData != null) {
            numRowsVariableReader = agentInstanceContext.getStatementContext().getVariableService().getReader(this.numRowsVariableMetaData.getVariableName(), agentInstanceContext.getAgentInstanceId());
        }
        VariableReader offsetVariableReader = null;
        if (this.offsetVariableMetaData != null) {
            offsetVariableReader = agentInstanceContext.getStatementContext().getVariableService().getReader(this.offsetVariableMetaData.getVariableName(), agentInstanceContext.getAgentInstanceId());
        }
        return new RowLimitProcessor(numRowsVariableReader, offsetVariableReader, this.currentRowLimit, this.currentOffset);
    }
}

