/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.eval;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.eval.SelectExprContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.event.BaseNestableEventType;
import com.espertech.esper.event.BaseNestableEventUtil;
import com.espertech.esper.event.EventBeanManufactureException;
import com.espertech.esper.event.EventBeanManufacturer;
import com.espertech.esper.event.MappedEventBean;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.event.map.MapEventType;
import com.espertech.esper.util.TypeWidener;
import com.espertech.esper.util.TypeWidenerFactory;
import java.util.ArrayList;
import java.util.Set;

public class EvalSelectStreamWUndRecastMapFactory {
    public static SelectExprProcessor make(EventType[] eventTypes, SelectExprContext selectExprContext, int streamNumber, EventType targetType, ExprNode[] exprNodes, EngineImportService engineImportService) throws ExprValidationException {
        EventBeanManufacturer manufacturer;
        MapEventType mapResultType = (MapEventType)targetType;
        MapEventType mapStreamType = (MapEventType)eventTypes[streamNumber];
        String typeSameMssage = BaseNestableEventType.isDeepEqualsProperties(mapResultType.getName(), mapResultType.getTypes(), mapStreamType.getTypes());
        if (typeSameMssage == null && selectExprContext.getExpressionNodes().length == 0) {
            return new MapInsertProcessorSimpleRepackage(selectExprContext, streamNumber, targetType);
        }
        Set<WriteablePropertyDescriptor> writables = selectExprContext.getEventAdapterService().getWriteableProperties(mapResultType, true);
        ArrayList<Item> items = new ArrayList<Item>();
        ArrayList<WriteablePropertyDescriptor> written = new ArrayList<WriteablePropertyDescriptor>();
        int count = 0;
        for (WriteablePropertyDescriptor writeable : writables) {
            boolean setTwoTypeFound;
            Object setTwoType;
            String propertyName = writeable.getPropertyName();
            if (!mapStreamType.getTypes().containsKey(propertyName)) continue;
            Object setOneType = mapStreamType.getTypes().get(propertyName);
            String message = BaseNestableEventUtil.comparePropType(propertyName, setOneType, setTwoType = mapResultType.getTypes().get(propertyName), setTwoTypeFound = mapResultType.getTypes().containsKey(propertyName), mapResultType.getName());
            if (message != null) {
                throw new ExprValidationException(message);
            }
            items.add(new Item(count, propertyName, null, null));
            written.add(writeable);
            ++count;
        }
        for (int i = 0; i < selectExprContext.getExpressionNodes().length; ++i) {
            String columnName = selectExprContext.getColumnNames()[i];
            ExprEvaluator evaluator = selectExprContext.getExpressionNodes()[i];
            ExprNode exprNode = exprNodes[i];
            WriteablePropertyDescriptor writable = EvalSelectStreamWUndRecastMapFactory.findWritable(columnName, writables);
            if (writable == null) {
                throw new ExprValidationException("Failed to find column '" + columnName + "' in target type '" + mapResultType.getName() + "'");
            }
            TypeWidener widener = TypeWidenerFactory.getCheckPropertyAssignType(ExprNodeUtility.toExpressionStringMinPrecedenceSafe(exprNode), exprNode.getExprEvaluator().getType(), writable.getType(), columnName);
            items.add(new Item(count, null, evaluator, widener));
            written.add(writable);
            ++count;
        }
        Item[] itemsArr = items.toArray(new Item[items.size()]);
        try {
            manufacturer = selectExprContext.getEventAdapterService().getManufacturer(mapResultType, written.toArray(new WriteablePropertyDescriptor[written.size()]), engineImportService, true);
        }
        catch (EventBeanManufactureException e) {
            throw new ExprValidationException("Failed to write to type: " + e.getMessage(), e);
        }
        return new MapInsertProcessorAllocate(streamNumber, itemsArr, manufacturer, targetType);
    }

    private static WriteablePropertyDescriptor findWritable(String columnName, Set<WriteablePropertyDescriptor> writables) {
        for (WriteablePropertyDescriptor writable : writables) {
            if (!writable.getPropertyName().equals(columnName)) continue;
            return writable;
        }
        return null;
    }

    private static class Item {
        private final int toIndex;
        private final String optionalPropertyName;
        private final ExprEvaluator evaluator;
        private final TypeWidener optionalWidener;

        private Item(int toIndex, String optionalPropertyName, ExprEvaluator evaluator, TypeWidener optionalWidener) {
            this.toIndex = toIndex;
            this.optionalPropertyName = optionalPropertyName;
            this.evaluator = evaluator;
            this.optionalWidener = optionalWidener;
        }

        public int getToIndex() {
            return this.toIndex;
        }

        public String getOptionalPropertyName() {
            return this.optionalPropertyName;
        }

        public ExprEvaluator getEvaluator() {
            return this.evaluator;
        }

        public TypeWidener getOptionalWidener() {
            return this.optionalWidener;
        }
    }

    private static class MapInsertProcessorAllocate
    implements SelectExprProcessor {
        private final int underlyingStreamNumber;
        private final Item[] items;
        private final EventBeanManufacturer manufacturer;
        private final EventType resultType;

        private MapInsertProcessorAllocate(int underlyingStreamNumber, Item[] items, EventBeanManufacturer manufacturer, EventType resultType) {
            this.underlyingStreamNumber = underlyingStreamNumber;
            this.items = items;
            this.manufacturer = manufacturer;
            this.resultType = resultType;
        }

        @Override
        public EventType getResultEventType() {
            return this.resultType;
        }

        @Override
        public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
            MappedEventBean theEvent = (MappedEventBean)eventsPerStream[this.underlyingStreamNumber];
            Object[] props = new Object[this.items.length];
            for (Item item : this.items) {
                Object value;
                if (item.getOptionalPropertyName() != null) {
                    value = theEvent.getProperties().get(item.getOptionalPropertyName());
                } else {
                    value = item.getEvaluator().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                    if (item.getOptionalWidener() != null) {
                        value = item.getOptionalWidener().widen(value);
                    }
                }
                props[item.getToIndex()] = value;
            }
            return this.manufacturer.make(props);
        }
    }

    private static class MapInsertProcessorSimpleRepackage
    implements SelectExprProcessor {
        private final SelectExprContext selectExprContext;
        private final int underlyingStreamNumber;
        private final EventType resultType;

        private MapInsertProcessorSimpleRepackage(SelectExprContext selectExprContext, int underlyingStreamNumber, EventType resultType) {
            this.selectExprContext = selectExprContext;
            this.underlyingStreamNumber = underlyingStreamNumber;
            this.resultType = resultType;
        }

        @Override
        public EventType getResultEventType() {
            return this.resultType;
        }

        @Override
        public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
            MappedEventBean theEvent = (MappedEventBean)eventsPerStream[this.underlyingStreamNumber];
            return this.selectExprContext.getEventAdapterService().adapterForTypedMap(theEvent.getProperties(), this.resultType);
        }
    }
}

