/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.db;

import com.espertech.esper.client.ConfigurationDataCache;
import com.espertech.esper.client.ConfigurationExpiryTimeCache;
import com.espertech.esper.client.ConfigurationLRUCache;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.db.DataCache;
import com.espertech.esper.epl.db.DataCacheExpiringImpl;
import com.espertech.esper.epl.db.DataCacheLRUImpl;
import com.espertech.esper.epl.db.DataCacheNullImpl;
import com.espertech.esper.schedule.ScheduleBucket;
import com.espertech.esper.schedule.SchedulingService;

public class DataCacheFactory {
    public DataCache getDataCache(ConfigurationDataCache cacheDesc, StatementContext statementContext, EPStatementAgentInstanceHandle epStatementAgentInstanceHandle, SchedulingService schedulingService, ScheduleBucket scheduleBucket, int streamNum) {
        if (cacheDesc == null) {
            return new DataCacheNullImpl();
        }
        if (cacheDesc instanceof ConfigurationLRUCache) {
            ConfigurationLRUCache lruCache = (ConfigurationLRUCache)cacheDesc;
            return new DataCacheLRUImpl(lruCache.getSize());
        }
        if (cacheDesc instanceof ConfigurationExpiryTimeCache) {
            ConfigurationExpiryTimeCache expCache = (ConfigurationExpiryTimeCache)cacheDesc;
            return this.makeTimeCache(expCache, statementContext, epStatementAgentInstanceHandle, schedulingService, scheduleBucket, streamNum);
        }
        throw new IllegalStateException("Cache implementation class not configured");
    }

    protected DataCache makeTimeCache(ConfigurationExpiryTimeCache expCache, StatementContext statementContext, EPStatementAgentInstanceHandle epStatementAgentInstanceHandle, SchedulingService schedulingService, ScheduleBucket scheduleBucket, int streamNum) {
        return new DataCacheExpiringImpl(expCache.getMaxAgeSeconds(), expCache.getPurgeIntervalSeconds(), expCache.getCacheReferenceType(), schedulingService, scheduleBucket.allocateSlot(), epStatementAgentInstanceHandle);
    }
}

