/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import java.io.StringWriter;

public class ExprOrderedExpr
extends ExprNodeBase
implements ExprEvaluator {
    private final boolean isDescending;
    private transient ExprEvaluator evaluator;
    private static final long serialVersionUID = -3140402807682771591L;

    public ExprOrderedExpr(boolean descending) {
        this.isDescending = descending;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
        if (this.isDescending) {
            writer.append(" desc");
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public boolean isConstantResult() {
        return this.getChildNodes()[0].isConstantResult();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprOrderedExpr)) {
            return false;
        }
        ExprOrderedExpr other = (ExprOrderedExpr)node;
        return other.isDescending == this.isDescending;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.evaluator = this.getChildNodes()[0].getExprEvaluator();
        return null;
    }

    @Override
    public Class getType() {
        return this.getChildNodes()[0].getExprEvaluator().getType();
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.evaluator.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
    }

    public boolean isDescending() {
        return this.isDescending;
    }
}

