/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.funcs;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprCoalesceNode
extends ExprNodeBase
implements ExprEvaluator {
    private Class resultType;
    private boolean[] isNumericCoercion;
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = -8276568753875819730L;

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        int i;
        if (this.getChildNodes().length < 2) {
            throw new ExprValidationException("Coalesce node must have at least 2 parameters");
        }
        this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        Class[] childTypes = new Class[this.getChildNodes().length];
        for (i = 0; i < this.evaluators.length; ++i) {
            childTypes[i] = this.evaluators[i].getType();
        }
        try {
            this.resultType = JavaClassHelper.getCommonCoercionType(childTypes);
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
        this.isNumericCoercion = new boolean[this.getChildNodes().length];
        for (i = 0; i < this.evaluators.length; ++i) {
            if (JavaClassHelper.getBoxedType(this.evaluators[i].getType()) == this.resultType || this.evaluators[i].getType() == null || this.resultType == null) continue;
            if (!JavaClassHelper.isNumeric(this.resultType)) {
                throw new ExprValidationException("Implicit conversion from datatype '" + this.resultType.getSimpleName() + "' to " + this.evaluators[i].getType() + " is not allowed");
            }
            this.isNumericCoercion[i] = true;
        }
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Class getType() {
        return this.resultType;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        for (int i = 0; i < this.evaluators.length; ++i) {
            Object value = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (value == null) continue;
            if (this.isNumericCoercion[i]) {
                value = JavaClassHelper.coerceBoxed((Number)value, this.resultType);
            }
            return value;
        }
        return null;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        ExprNodeUtility.toExpressionStringWFunctionName("coalesce", this.getChildNodes(), writer);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprCoalesceNode;
    }
}

