/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprEvaluatorTypableReturn;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExprNewStructNode
extends ExprNodeBase
implements ExprEvaluatorTypableReturn {
    private static final long serialVersionUID = -210293632565665600L;
    private final String[] columnNames;
    private transient LinkedHashMap<String, Object> eventType;
    private transient ExprEvaluator[] evaluators;
    private boolean isAllConstants;

    public ExprNewStructNode(String[] columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.eventType = new LinkedHashMap();
        this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        for (int i = 0; i < this.columnNames.length; ++i) {
            boolean bl = this.isAllConstants = this.isAllConstants && this.getChildNodes()[i].isConstantResult();
            if (this.eventType.containsKey(this.columnNames[i])) {
                throw new ExprValidationException("Failed to validate new-keyword property names, property '" + this.columnNames[i] + "' has already been declared");
            }
            LinkedHashMap<String, Object> eventTypeResult = null;
            if (this.evaluators[i] instanceof ExprEvaluatorTypableReturn) {
                eventTypeResult = ((ExprEvaluatorTypableReturn)this.evaluators[i]).getRowProperties();
            }
            if (eventTypeResult != null) {
                this.eventType.put(this.columnNames[i], eventTypeResult);
                continue;
            }
            Class classResult = JavaClassHelper.getBoxedType(this.evaluators[i].getType());
            this.eventType.put(this.columnNames[i], classResult);
        }
        return null;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public boolean isConstantResult() {
        return this.isAllConstants;
    }

    @Override
    public Class getType() {
        return Map.class;
    }

    @Override
    public LinkedHashMap<String, Object> getRowProperties() throws ExprValidationException {
        return this.eventType;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (int i = 0; i < this.evaluators.length; ++i) {
            props.put(this.columnNames[i], this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext));
        }
        return props;
    }

    @Override
    public Boolean isMultirow() {
        return false;
    }

    @Override
    public Object[] evaluateTypableSingle(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Object[] rows = new Object[this.columnNames.length];
        for (int i = 0; i < this.columnNames.length; ++i) {
            rows[i] = this.evaluators[i].evaluate(eventsPerStream, isNewData, context);
        }
        return rows;
    }

    @Override
    public Object[][] evaluateTypableMulti(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprNewStructNode)) {
            return false;
        }
        ExprNewStructNode other = (ExprNewStructNode)node;
        return Arrays.deepEquals(other.columnNames, this.columnNames);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.write("new{");
        String delimiter = "";
        for (int i = 0; i < this.getChildNodes().length; ++i) {
            ExprIdentNode prop;
            writer.append(delimiter);
            writer.append(this.columnNames[i]);
            ExprNode expr = this.getChildNodes()[i];
            boolean outputexpr = true;
            if (expr instanceof ExprIdentNode && (prop = (ExprIdentNode)expr).getResolvedPropertyName().equals(this.columnNames[i])) {
                outputexpr = false;
            }
            if (outputexpr) {
                writer.append("=");
                expr.toEPL(writer, ExprPrecedenceEnum.MINIMUM);
            }
            delimiter = ",";
        }
        writer.write("}");
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }
}

