/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprEvaluatorTypableReturn;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.table.ExprTableAccessEvalStrategy;
import com.espertech.esper.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumn;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnAggregation;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnPlain;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExprTableAccessNodeTopLevel
extends ExprTableAccessNode
implements ExprEvaluatorTypableReturn {
    private static final long serialVersionUID = -5475434962878200767L;
    private transient LinkedHashMap<String, Object> eventType;

    public ExprTableAccessNodeTopLevel(String tableName) {
        super(tableName);
    }

    @Override
    public void setStrategy(ExprTableAccessEvalStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    protected void validateBindingInternal(ExprValidationContext validationContext, TableMetadata tableMetadata) throws ExprValidationException {
        this.validateGroupKeys(tableMetadata);
        this.eventType = new LinkedHashMap();
        for (Map.Entry<String, TableMetadataColumn> entry : tableMetadata.getTableColumns().entrySet()) {
            Class classResult;
            if (entry.getValue() instanceof TableMetadataColumnPlain) {
                classResult = tableMetadata.getInternalEventType().getPropertyType(entry.getKey());
            } else {
                TableMetadataColumnAggregation aggcol = (TableMetadataColumnAggregation)entry.getValue();
                classResult = JavaClassHelper.getBoxedType(aggcol.getFactory().getResultType());
            }
            this.eventType.put(entry.getKey(), classResult);
        }
    }

    @Override
    public Class getType() {
        return Map.class;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.strategy.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
    }

    @Override
    public LinkedHashMap<String, Object> getRowProperties() throws ExprValidationException {
        return this.eventType;
    }

    @Override
    public Boolean isMultirow() {
        return false;
    }

    @Override
    public Object[] evaluateTypableSingle(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.strategy.evaluateTypableSingle(eventsPerStream, isNewData, context);
    }

    @Override
    public Object[][] evaluateTypableMulti(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.toPrecedenceFreeEPLInternal(writer);
    }

    @Override
    protected boolean equalsNodeInternal(ExprTableAccessNode other) {
        return true;
    }
}

